/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermDocs;
import org.apache.lucene.ep.index.TermEnum;
import org.apache.lucene.ep.search.ExtendedFieldCache;
import org.apache.lucene.ep.search.FieldCache;
import org.apache.lucene.ep.search.SortComparator;
import org.apache.lucene.ep.util.FieldCacheSanityChecker;
import org.apache.lucene.ep.util.StringHelper;

class FieldCacheImpl
implements ExtendedFieldCache {
    private static final Logger logger = Logger.getLogger(FieldCacheImpl.class);
    private Map caches;
    private volatile PrintStream infoStream;

    FieldCacheImpl() {
        this.init();
    }

    private synchronized void init() {
        this.caches = new HashMap(7);
        this.caches.put(Byte.TYPE, new ByteCache(this));
        this.caches.put(Short.TYPE, new ShortCache(this));
        this.caches.put(Integer.TYPE, new IntCache(this));
        this.caches.put(Float.TYPE, new FloatCache(this));
        this.caches.put(Long.TYPE, new LongCache(this));
        this.caches.put(Double.TYPE, new DoubleCache(this));
        this.caches.put(String.class, new StringCache(this));
        this.caches.put(FieldCache.StringIndex.class, new StringIndexCache(this));
        this.caches.put(Comparable.class, new CustomCache(this));
        this.caches.put(Object.class, new AutoCache(this));
    }

    @Override
    public void purgeAllCaches() {
        this.init();
    }

    @Override
    public void purge(IndexReader r) {
        for (Cache c : this.caches.values()) {
            c.purge(r);
        }
    }

    @Override
    public FieldCache.CacheEntry[] getCacheEntries() {
        ArrayList<CacheEntryImpl> result = new ArrayList<CacheEntryImpl>(17);
        for (Class cacheType : this.caches.keySet()) {
            Cache cache = (Cache)this.caches.get(cacheType);
            for (Object readerKey : cache.readerCache.keySet()) {
                if (null == readerKey || !cache.readerCache.containsKey(readerKey)) continue;
                Map innerCache = (Map)cache.readerCache.get(readerKey);
                for (Map.Entry mapEntry : innerCache.entrySet()) {
                    Entry entry = (Entry)mapEntry.getKey();
                    result.add(new CacheEntryImpl(readerKey, entry.field, cacheType, entry.type, entry.custom, entry.locale, mapEntry.getValue()));
                }
            }
        }
        return result.toArray(new FieldCache.CacheEntry[result.size()]);
    }

    @Override
    public byte[] getBytes(IndexReader reader, String field) throws IOException {
        return this.getBytes(reader, field, null);
    }

    @Override
    public byte[] getBytes(IndexReader reader, String field, FieldCache.ByteParser parser) throws IOException {
        return (byte[])((Cache)this.caches.get(Byte.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public short[] getShorts(IndexReader reader, String field) throws IOException {
        return this.getShorts(reader, field, null);
    }

    @Override
    public short[] getShorts(IndexReader reader, String field, FieldCache.ShortParser parser) throws IOException {
        return (short[])((Cache)this.caches.get(Short.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public int[] getInts(IndexReader reader, String field) throws IOException {
        return this.getInts(reader, field, null);
    }

    @Override
    public int[] getInts(IndexReader reader, String field, FieldCache.IntParser parser) throws IOException {
        return (int[])((Cache)this.caches.get(Integer.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public float[] getFloats(IndexReader reader, String field) throws IOException {
        return this.getFloats(reader, field, null);
    }

    @Override
    public float[] getFloats(IndexReader reader, String field, FieldCache.FloatParser parser) throws IOException {
        return (float[])((Cache)this.caches.get(Float.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public long[] getLongs(IndexReader reader, String field) throws IOException {
        return this.getLongs(reader, field, null);
    }

    @Override
    public long[] getLongs(IndexReader reader, String field, FieldCache.LongParser parser) throws IOException {
        return (long[])((Cache)this.caches.get(Long.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public long[] getLongs(IndexReader reader, String field, ExtendedFieldCache.LongParser parser) throws IOException {
        return (long[])((Cache)this.caches.get(Long.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public double[] getDoubles(IndexReader reader, String field) throws IOException {
        return this.getDoubles(reader, field, null);
    }

    @Override
    public double[] getDoubles(IndexReader reader, String field, FieldCache.DoubleParser parser) throws IOException {
        return (double[])((Cache)this.caches.get(Double.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public double[] getDoubles(IndexReader reader, String field, ExtendedFieldCache.DoubleParser parser) throws IOException {
        return (double[])((Cache)this.caches.get(Double.TYPE)).get(reader, new Entry(field, parser));
    }

    @Override
    public String[] getStrings(IndexReader reader, String field) throws IOException {
        return (String[])((Cache)this.caches.get(String.class)).get(reader, new Entry(field, null));
    }

    @Override
    public FieldCache.StringIndex getStringIndex(IndexReader reader, String field) throws IOException {
        return (FieldCache.StringIndex)((Cache)this.caches.get(FieldCache.StringIndex.class)).get(reader, new Entry(field, null));
    }

    @Override
    public Object getAuto(IndexReader reader, String field) throws IOException {
        return ((Cache)this.caches.get(Object.class)).get(reader, new Entry(field, null));
    }

    @Override
    public Comparable[] getCustom(IndexReader reader, String field, SortComparator comparator) throws IOException {
        return (Comparable[])((Cache)this.caches.get(Comparable.class)).get(reader, new Entry(field, comparator));
    }

    @Override
    public void setInfoStream(PrintStream stream) {
        this.infoStream = stream;
    }

    @Override
    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    static final class CustomCache
    extends Cache {
        CustomCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            SortComparator comparator = (SortComparator)entry.custom;
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        Comparable termval = comparator.getComparable(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    }

    static final class AutoCache
    extends Cache {
        AutoCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            String field = StringHelper.intern(entryKey.field);
            try (TermEnum enumerator = reader.terms(new Term(field));){
                Term term = enumerator.term();
                if (term == null) {
                    throw new RuntimeException("no terms in field " + field + " - cannot determine type");
                }
                Object ret = null;
                if (term.field() == field) {
                    String termtext = term.text().trim();
                    try {
                        Integer.parseInt(termtext);
                        ret = this.wrapper.getInts(reader, field);
                    }
                    catch (NumberFormatException nfe1) {
                        try {
                            Long.parseLong(termtext);
                            ret = this.wrapper.getLongs(reader, field);
                        }
                        catch (NumberFormatException nfe2) {
                            try {
                                Float.parseFloat(termtext);
                                ret = this.wrapper.getFloats(reader, field);
                            }
                            catch (NumberFormatException nfe3) {
                                ret = this.wrapper.getStringIndex(reader, field);
                            }
                        }
                    }
                } else {
                    throw new RuntimeException("field \"" + field + "\" does not appear to be indexed");
                }
                int[] nArray = ret;
                return nArray;
            }
        }
    }

    static final class StringIndexCache
    extends Cache {
        StringIndexCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            String field = StringHelper.intern(entryKey.field);
            int[] retArray = new int[reader.maxDoc()];
            String[] mterms = new String[reader.maxDoc() + 1];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            int t = 0;
            mterms[t++] = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        mterms[t] = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = t;
                        }
                        ++t;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (t == 0) {
                mterms = new String[1];
            } else if (t < mterms.length) {
                String[] terms = new String[t];
                System.arraycopy(mterms, 0, terms, 0, t);
                mterms = terms;
            }
            FieldCache.StringIndex value = new FieldCache.StringIndex(retArray, mterms);
            return value;
        }
    }

    static final class StringCache
    extends Cache {
        StringCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            String field = StringHelper.intern(entryKey.field);
            String[] retArray = new String[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        String termval = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    }

    static final class DoubleCache
    extends Cache {
        DoubleCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.DoubleParser parser = (FieldCache.DoubleParser)entry.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getDoubles(reader, field, FieldCache.DEFAULT_DOUBLE_PARSER);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getDoubles(reader, field, FieldCache.NUMERIC_UTILS_DOUBLE_PARSER);
                }
            }
            double[] retArray = null;
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        double termval = parser.parseDouble(term.text());
                        if (retArray == null) {
                            retArray = new double[reader.maxDoc()];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (retArray == null) {
                retArray = new double[reader.maxDoc()];
            }
            return retArray;
        }
    }

    static final class LongCache
    extends Cache {
        LongCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.LongParser parser = (FieldCache.LongParser)entry.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getLongs(reader, field, FieldCache.DEFAULT_LONG_PARSER);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getLongs(reader, field, FieldCache.NUMERIC_UTILS_LONG_PARSER);
                }
            }
            long[] retArray = null;
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        long termval = parser.parseLong(term.text());
                        if (retArray == null) {
                            retArray = new long[reader.maxDoc()];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (retArray == null) {
                retArray = new long[reader.maxDoc()];
            }
            return retArray;
        }
    }

    static final class FloatCache
    extends Cache {
        FloatCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.FloatParser parser = (FieldCache.FloatParser)entry.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getFloats(reader, field, FieldCache.DEFAULT_FLOAT_PARSER);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getFloats(reader, field, FieldCache.NUMERIC_UTILS_FLOAT_PARSER);
                }
            }
            float[] retArray = null;
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        float termval = parser.parseFloat(term.text());
                        if (retArray == null) {
                            retArray = new float[reader.maxDoc()];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (retArray == null) {
                retArray = new float[reader.maxDoc()];
            }
            return retArray;
        }
    }

    static final class IntCache
    extends Cache {
        IntCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.IntParser parser = (FieldCache.IntParser)entry.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getInts(reader, field, FieldCache.DEFAULT_INT_PARSER);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getInts(reader, field, FieldCache.NUMERIC_UTILS_INT_PARSER);
                }
            }
            int[] retArray = null;
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        int termval = parser.parseInt(term.text());
                        if (retArray == null) {
                            retArray = new int[reader.maxDoc()];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (retArray == null) {
                retArray = new int[reader.maxDoc()];
            }
            return retArray;
        }
    }

    static final class ShortCache
    extends Cache {
        ShortCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.ShortParser parser = (FieldCache.ShortParser)entry.custom;
            if (parser == null) {
                return this.wrapper.getShorts(reader, field, FieldCache.DEFAULT_SHORT_PARSER);
            }
            short[] retArray = new short[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        short termval = parser.parseShort(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    }

    static final class ByteCache
    extends Cache {
        ByteCache(FieldCache wrapper) {
            super(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader reader, Entry entryKey) throws IOException {
            Entry entry = entryKey;
            String field = entry.field;
            FieldCache.ByteParser parser = (FieldCache.ByteParser)entry.custom;
            if (parser == null) {
                return this.wrapper.getBytes(reader, field, FieldCache.DEFAULT_BYTE_PARSER);
            }
            byte[] retArray = new byte[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        byte termval = parser.parseByte(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    }

    static class Entry {
        final String field;
        final int type;
        final Object custom;
        final Locale locale;

        Entry(String field, int type, Locale locale) {
            this.field = StringHelper.intern(field);
            this.type = type;
            this.custom = null;
            this.locale = locale;
        }

        Entry(String field, Object custom) {
            this.field = StringHelper.intern(field);
            this.type = 9;
            this.custom = custom;
            this.locale = null;
        }

        Entry(String field, int type, FieldCache.Parser parser) {
            this.field = StringHelper.intern(field);
            this.type = type;
            this.custom = parser;
            this.locale = null;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                if (other.field == this.field && other.type == this.type && (other.locale == null ? this.locale == null : other.locale.equals(this.locale)) && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.type ^ (this.custom == null ? 0 : this.custom.hashCode()) ^ (this.locale == null ? 0 : this.locale.hashCode());
        }
    }

    static abstract class Cache {
        final FieldCache wrapper;
        final Map readerCache = new WeakHashMap();

        Cache() {
            this.wrapper = null;
        }

        Cache(FieldCache wrapper) {
            this.wrapper = wrapper;
        }

        protected abstract Object createValue(IndexReader var1, Entry var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purge(IndexReader r) {
            Object readerKey = r.getFieldCacheKey();
            Map map = this.readerCache;
            synchronized (map) {
                this.readerCache.remove(readerKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(IndexReader reader, Entry key) throws IOException {
            Object value;
            HashMap<Entry, Object> innerCache;
            Object readerKey = reader.getFieldCacheKey();
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = (HashMap<Entry, Object>)this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<Entry, Object>();
                    this.readerCache.put(readerKey, innerCache);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new FieldCache.CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof FieldCache.CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    FieldCache.CreationPlaceholder progress = (FieldCache.CreationPlaceholder)value;
                    if (progress.value == null) {
                        PrintStream infoStream;
                        progress.value = this.createValue(reader, key);
                        Map map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                        }
                        if (key.custom != null && this.wrapper != null && (infoStream = this.wrapper.getInfoStream()) != null) {
                            this.printNewInsanity(infoStream, progress.value);
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        private void printNewInsanity(PrintStream infoStream, Object value) {
            FieldCacheSanityChecker.Insanity[] insanities = FieldCacheSanityChecker.checkSanity(this.wrapper);
            block0: for (int i = 0; i < insanities.length; ++i) {
                FieldCacheSanityChecker.Insanity insanity = insanities[i];
                FieldCache.CacheEntry[] entries = insanity.getCacheEntries();
                for (int j = 0; j < entries.length; ++j) {
                    if (entries[j].getValue() != value) continue;
                    infoStream.println("WARNING: new FieldCache insanity created\nDetails: " + insanity.toString());
                    infoStream.println("\nStack:\n");
                    logger.info((Object)("WARNING: new FieldCache insanity created\nDetails: " + insanity.toString()));
                    logger.error((Object)"error:", new Throwable());
                    continue block0;
                }
            }
        }
    }

    static final class StopFillCacheException
    extends RuntimeException {
        StopFillCacheException() {
        }
    }

    private static final class CacheEntryImpl
    extends FieldCache.CacheEntry {
        private final int sortFieldType;
        private final Locale locale;
        private final Object readerKey;
        private final String fieldName;
        private final Class cacheType;
        private final Object custom;
        private final Object value;

        CacheEntryImpl(Object readerKey, String fieldName, Class cacheType, int sortFieldType, Object custom, Locale locale, Object value) {
            this.readerKey = readerKey;
            this.fieldName = fieldName;
            this.cacheType = cacheType;
            this.sortFieldType = sortFieldType;
            this.custom = custom;
            this.locale = locale;
            this.value = value;
        }

        @Override
        public Object getReaderKey() {
            return this.readerKey;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public Class getCacheType() {
            return this.cacheType;
        }

        @Override
        public Object getCustom() {
            return this.custom;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            String r = super.toString();
            if (null != this.locale) {
                r = r + "...!!!Locale:" + this.locale + "???";
            }
            if (9 != this.sortFieldType) {
                r = r + "...!!!SortType:" + this.sortFieldType + "???";
            }
            return r;
        }
    }
}

