/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.BooleanClause;
import org.apache.lucene.ep.search.BooleanQuery;
import org.apache.lucene.ep.search.FilteredTermEnum;
import org.apache.lucene.ep.search.FuzzyTermEnum;
import org.apache.lucene.ep.search.MultiTermQuery;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.TermQuery;
import org.apache.lucene.ep.util.PriorityQueue;
import org.apache.lucene.ep.util.ToStringUtils;

public class FuzzyQuery
extends MultiTermQuery {
    public static final float defaultMinSimilarity = 0.5f;
    public static final int defaultPrefixLength = 0;
    private float minimumSimilarity;
    private int prefixLength;
    private boolean termLongEnough = false;

    public FuzzyQuery(Term term, float minimumSimilarity, int prefixLength) throws IllegalArgumentException {
        super(term);
        this.term = term;
        if (minimumSimilarity >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity >= 1");
        }
        if (minimumSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity < 0");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength < 0");
        }
        if ((float)term.text().length() > 1.0f / (1.0f - minimumSimilarity)) {
            this.termLongEnough = true;
        }
        this.minimumSimilarity = minimumSimilarity;
        this.prefixLength = prefixLength;
        this.rewriteMethod = SCORING_BOOLEAN_QUERY_REWRITE;
    }

    public FuzzyQuery(Term term, float minimumSimilarity) throws IllegalArgumentException {
        this(term, minimumSimilarity, 0);
    }

    public FuzzyQuery(Term term) {
        this(term, 0.5f, 0);
    }

    public float getMinSimilarity() {
        return this.minimumSimilarity;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new FuzzyTermEnum(reader, this.getTerm(), this.minimumSimilarity, this.prefixLength);
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("FuzzyQuery cannot change rewrite method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (!this.termLongEnough) {
            return new TermQuery(this.term);
        }
        FilteredTermEnum enumerator = this.getEnum(reader);
        int maxClauseCount = BooleanQuery.getMaxClauseCount();
        ScoreTermQueue stQueue = new ScoreTermQueue(maxClauseCount);
        ScoreTerm reusableST = null;
        try {
            do {
                float score = 0.0f;
                Term t = enumerator.term();
                if (t == null) continue;
                score = enumerator.difference();
                if (reusableST == null) {
                    reusableST = new ScoreTerm(t, score);
                } else {
                    if (!(score >= reusableST.score)) continue;
                    reusableST.score = score;
                    reusableST.term2 = t;
                }
                reusableST = (ScoreTerm)stQueue.insertWithOverflow(reusableST);
            } while (enumerator.next());
        }
        finally {
            enumerator.close();
        }
        BooleanQuery query = new BooleanQuery(true);
        int size = stQueue.size();
        for (int i = 0; i < size; ++i) {
            ScoreTerm st = (ScoreTerm)stQueue.pop();
            TermQuery tq = new TermQuery(st.term2);
            tq.setBoost(this.getBoost() * st.score);
            query.add(tq, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('~');
        buffer.append(Float.toString(this.minimumSimilarity));
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.minimumSimilarity);
        result = 31 * result + this.prefixLength;
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FuzzyQuery other = (FuzzyQuery)obj;
        if (Float.floatToIntBits(this.minimumSimilarity) != Float.floatToIntBits(other.minimumSimilarity)) {
            return false;
        }
        if (this.prefixLength != other.prefixLength) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    protected static class ScoreTermQueue
    extends PriorityQueue {
        public ScoreTermQueue(int size) {
            this.initialize(size);
        }

        @Override
        protected boolean lessThan(Object a, Object b) {
            ScoreTerm termA = (ScoreTerm)a;
            ScoreTerm termB = (ScoreTerm)b;
            if (termA.score == termB.score) {
                return termA.term2.compareTo(termB.term2) > 0;
            }
            return termA.score < termB.score;
        }
    }

    protected static class ScoreTerm {
        public Term term2;
        public float score;

        public ScoreTerm(Term term, float score) {
            this.term2 = term;
            this.score = score;
        }
    }
}

