/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.Collector;
import org.apache.lucene.ep.search.DocIdSet;
import org.apache.lucene.ep.search.DocIdSetIterator;
import org.apache.lucene.ep.search.Filter;
import org.apache.lucene.ep.search.IndexSearcher;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Weight;

public class QueryWrapperFilter
extends Filter {
    private Query query;

    public QueryWrapperFilter(Query query) {
        this.query = query;
    }

    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        final BitSet bits = new BitSet(reader.maxDoc());
        new IndexSearcher(reader).search(this.query, new Collector(){
            private int base = 0;

            @Override
            public void setScorer(Scorer scorer) throws IOException {
            }

            @Override
            public final void collect(int doc) {
                bits.set(doc + this.base);
            }

            @Override
            public void setNextReader(IndexReader reader, int docBase) {
                this.base = docBase;
            }

            @Override
            public boolean acceptsDocsOutOfOrder() {
                return true;
            }
        });
        return bits;
    }

    @Override
    public DocIdSet getDocIdSet(final IndexReader reader) throws IOException {
        final Weight weight = this.query.weight(new IndexSearcher(reader));
        return new DocIdSet(){

            @Override
            public DocIdSetIterator iterator() throws IOException {
                return weight.scorer(reader, true, false);
            }

            @Override
            public boolean isCacheable() {
                return false;
            }
        };
    }

    public String toString() {
        return "QueryWrapperFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryWrapperFilter)) {
            return false;
        }
        return this.query.equals(((QueryWrapperFilter)o).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x923F64B9;
    }
}

