/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search.payloads;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Searcher;
import org.apache.lucene.ep.search.Weight;
import org.apache.lucene.ep.search.payloads.AveragePayloadFunction;
import org.apache.lucene.ep.search.payloads.PayloadTermQuery;
import org.apache.lucene.ep.search.spans.TermSpans;

public class BoostingTermQuery
extends PayloadTermQuery {
    public BoostingTermQuery(Term term) {
        this(term, true);
    }

    public BoostingTermQuery(Term term, boolean includeSpanScore) {
        super(term, new AveragePayloadFunction(), includeSpanScore);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new BoostingTermWeight(this, searcher);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BoostingTermQuery)) {
            return false;
        }
        BoostingTermQuery other = (BoostingTermQuery)o;
        return this.getBoost() == other.getBoost() && this.term.equals(other.term);
    }

    protected class BoostingTermWeight
    extends PayloadTermQuery.PayloadTermWeight {
        public BoostingTermWeight(BoostingTermQuery query, Searcher searcher) throws IOException {
            super(BoostingTermQuery.this, query, searcher);
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new PayloadTermQuery.PayloadTermWeight.PayloadTermSpanScorer(this, (TermSpans)this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
        }
    }
}

