/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class LockVerifyServer {
    private static final Logger logger = Logger.getLogger(LockVerifyServer.class);

    private static String getTime(long startTime) {
        return "[" + (System.currentTimeMillis() - startTime) / 1000L + "s] ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            logger.info((Object)"\nUsage: java org.apache.lucene.ep.store.LockVerifyServer port\n");
            System.exit(1);
        }
        int port = Integer.parseInt(args[0]);
        OutputStream out = null;
        InputStream in = null;
        Socket cs = null;
        ServerSocket s = null;
        try {
            try {
                s = new ServerSocket(port);
                s.setReuseAddress(true);
                logger.info((Object)("\nReady on port " + port + "..."));
                int lockedID = 0;
                long startTime = System.currentTimeMillis();
                while (true) {
                    cs = s.accept();
                    out = cs.getOutputStream();
                    in = cs.getInputStream();
                    int id = in.read();
                    int command = in.read();
                    boolean err = false;
                    if (command == 1) {
                        if (lockedID != 0) {
                            err = true;
                            logger.info((Object)(LockVerifyServer.getTime(startTime) + " ERROR: id " + id + " got lock, but " + lockedID + " already holds the lock"));
                        }
                        lockedID = id;
                    } else if (command == 0) {
                        if (lockedID != id) {
                            err = true;
                            logger.info((Object)(LockVerifyServer.getTime(startTime) + " ERROR: id " + id + " released the lock, but " + lockedID + " is the one holding the lock"));
                        }
                        lockedID = 0;
                    } else {
                        throw new RuntimeException("unrecognized command " + command);
                    }
                    logger.info((Object)".");
                    if (err) {
                        out.write(1);
                    } else {
                        out.write(0);
                    }
                    out.close();
                    in.close();
                    cs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (cs != null && !cs.isClosed()) {
                    cs.close();
                }
                if (s != null && !s.isClosed()) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (cs != null && !cs.isClosed()) {
                cs.close();
            }
            if (s != null && !s.isClosed()) {
                s.close();
            }
            throw throwable;
        }
    }
}

