/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizExpressionExecutor {
    private static final Logger logger = Logger.getLogger(BizExpressionExecutor.class);
    private AbstractExpressionInfo exp;
    private Map localCtx;
    private Interpreter interpreter;

    public BizExpressionExecutor(Interpreter interpreter, Map localCtx, AbstractExpressionInfo exp) {
        this.interpreter = interpreter;
        this.localCtx = localCtx;
        this.exp = exp;
    }

    public Object execute() throws Exception {
        return this.execute(this.exp);
    }

    private Object execute(AbstractExpressionInfo exp) throws Exception {
        SimpleExpressionInfo simpleExp;
        if (this.interpreter != null && this.exp != null && this.exp instanceof SimpleExpressionInfo && ExpressionType.SCRIPT.equals((Object)(simpleExp = (SimpleExpressionInfo)exp).getType())) {
            String value = BizExpressionExecutor.convert2ScriptFormat(simpleExp.getValue());
            logger.info((Object)("\u6267\u884c\u8868\u8fbe\u5f0f:" + value + "..."));
            try {
                Object result = this.interpreter.eval(value, this.localCtx);
                logger.info((Object)"\u6210\u529f\uff01");
                return result;
            }
            catch (InterpreterException ie) {
                if (ie.getOrigException() instanceof EASBizException) {
                    logger.info((Object)"\u6210\u529f\uff01");
                    throw (EASBizException)ie.getOrigException();
                }
                logger.info((Object)"\u5931\u8d25\uff01\u6267\u884c\u811a\u672c\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)ie);
            }
            catch (ParserException e) {
                logger.info((Object)"\u5931\u8d25\uff01\u51fa\u73b0\u811a\u672c\u89e3\u6790\u9519\u8bef\uff01", (Throwable)e);
            }
        }
        return null;
    }

    private static String convert2ScriptFormat(String exp) {
        if (StringUtils.isEmpty((String)exp)) {
            return "";
        }
        exp = StringUtils.replace((String)exp, (String)"com.kingdee.bos.ui.face.UIRuleUtil.getProperty((com.kingdee.bos.dao.IObjectValue)", (String)"com.kingdee.bos.ui.face.UIRuleUtil.getProperty(");
        return exp;
    }

    public static void main(String[] args) throws Exception {
        Interpreter interpreter = new Interpreter();
        HashMap<String, Integer> localCtx = new HashMap<String, Integer>();
        interpreter.setProperyExprOwnerNullIgore(true);
        localCtx.put("a", new Integer(1));
        localCtx.put("b", new Integer(2));
        localCtx.put("c", new Integer(1));
        Object d = interpreter.eval("a == b", localCtx);
        if (d instanceof Boolean && ((Boolean)d).booleanValue()) {
            System.out.print(interpreter.eval("a == b", localCtx));
            System.out.print(localCtx.get("c"));
        }
    }
}

