/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.util.StringUtils;

public class BizRuleExecuteHelper {
    public static void setTableColumnRequired(KDTable table, String columnName, boolean isRequired) {
        IColumn column;
        if (table != null && !StringUtils.isEmpty((String)columnName) && (column = table.getColumn(columnName)) != null) {
            column.setRequired(isRequired);
        }
    }

    public static void setTableColumnLocked(KDTable table, String columnName, boolean isLocked) {
        IColumn column;
        if (table != null && !StringUtils.isEmpty((String)columnName) && (column = table.getColumn(columnName)) != null) {
            column.getStyleAttributes().setLocked(isLocked);
        }
    }

    public static void setTableColumnHided(KDTable table, String columnName, boolean isHided) {
        IColumn column;
        if (table != null && !StringUtils.isEmpty((String)columnName) && (column = table.getColumn(columnName)) != null) {
            column.getStyleAttributes().setHided(isHided);
        }
    }

    public static void setTableColumnLabel(KDTable table, String columnName, String label) {
        ICell cell;
        if (table.getHeadRow(0) != null && (cell = table.getHeadRow(0).getCell(columnName)) != null) {
            cell.setValue((Object)label);
        }
    }

    public static void setRuleTableSumField(CoreUI coreUI, KDTable table, String[] sumFields) {
        if (coreUI instanceof EditUI) {
            ((EditUI)coreUI).setRuleTableSumField(table, sumFields);
        }
        if (coreUI instanceof ListUI && sumFields.length > 0) {
            ((ListUI)coreUI).setDepSumList(sumFields);
        }
    }

    public static void throwBizException(String requiredPrompt) throws EASBizException {
        throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{requiredPrompt});
    }

    public static boolean isNull(Object value) {
        return UIRuleUtil.isNull((Object)value);
    }

    public static Object getCellValue(KDTable table, int rowIndex, String columnName) {
        ICell cell;
        if (table != null && rowIndex >= 0 && rowIndex < table.getRowCount() && !StringUtils.isEmpty((String)columnName) && (cell = table.getCell(rowIndex, columnName)) != null) {
            return cell.getValue();
        }
        return null;
    }
}

