/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.framework.query.component.AbstractAutoCompletionPopup;
import com.kingdee.eas.framework.query.component.AbstractListPopupItem;
import com.kingdee.eas.framework.query.component.AutoCompletionTextField;
import com.kingdee.eas.framework.query.component.CompositeListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;
import com.kingdee.eas.framework.query.component.IQueryTextField;
import com.kingdee.eas.framework.query.component.ItemLabel;
import com.kingdee.eas.framework.query.component.ListPopup;
import com.kingdee.eas.framework.query.component.ListPopupItem;
import com.kingdee.eas.framework.query.component.QueryTextField;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.framework.util.QueryUtility;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.KeyEvent;

public class QuickFilterAutoCompletionPopup
extends AbstractAutoCompletionPopup
implements IListPopupItemExecute {
    private FilterItemCollection filters;
    private String[] signs;
    private MetaDataPK queryPK;
    private CompositeListPopupItem ITEM_ALL_LIKE;
    private IListPopupItemExecute executor;

    QuickFilterAutoCompletionPopup(AutoCompletionTextField parent) {
        super(parent);
    }

    public QuickFilterAutoCompletionPopup(IListPopupItemExecute executor, AutoCompletionTextField parent, MetaDataPK queryPK, Object[] configs) throws BOSException {
        this(parent);
        this.executor = executor;
        this.queryPK = queryPK;
        this.initFilterItems(configs);
        this.initPopupValue();
    }

    private void initFilterItems(Object[] configs) throws BOSException {
        this.filters = (FilterItemCollection)configs[0];
        this.signs = (String[])configs[1];
    }

    @Override
    protected void initPopupValue() throws BOSException {
        if (this.filters == null) {
            return;
        }
        this.quickItemSize = this.filters.size();
        if (this.quickItemSize == 0) {
            return;
        }
        String[] props = new String[this.quickItemSize];
        for (int i = 0; i < this.quickItemSize; ++i) {
            props[i] = this.filters.get(i).getPropertyName();
        }
        QueryUtility.getQueryFieldInfo(this.queryPK, props);
        StringBuilder sb = new StringBuilder();
        this.ITEM_ALL_LIKE = new CompositeListPopupItem((IListPopupItemExecute)this, null, CompositeListPopupItem.LinkType.OR);
        this.addAllLikePopupItem();
        for (int i = 0; i < this.quickItemSize; ++i) {
            FilterItemInfo itemInfo = this.filters.get(i);
            ListPopupItem item = new ListPopupItem(this, this.queryPK, itemInfo, this.signs[i]);
            this.popupItems.add(item);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(item.getFieldAlias());
            this.ITEM_ALL_LIKE.addListPopupItem(item);
        }
        this.autoCompletionTextField.searchInfoTips = QuickFilterResources.getMessage("CANSEARCH", new String[]{sb.toString()});
        this.quickItemSize += 2;
        super.initPopupValue();
    }

    void addAllLikePopupItem() {
        if (this.popupItems.contains(this.ITEM_ALL_LIKE)) {
            return;
        }
        this.popupItems.addFirst(ListPopup.SEPERATOR);
        this.popupItems.addFirst(this.ITEM_ALL_LIKE);
    }

    void removeAllLikePopupItem() {
        if (!this.popupItems.contains(this.ITEM_ALL_LIKE)) {
            return;
        }
        this.popupItems.remove(this.ITEM_ALL_LIKE);
        this.popupItems.remove(ListPopup.SEPERATOR);
    }

    @Override
    public void showPopup() {
        if (this.quickItemSize == 0) {
            return;
        }
        if (this.autoCompletionTextField.hasItemLabel()) {
            this.removeAllLikePopupItem();
        } else {
            this.addAllLikePopupItem();
        }
        this.setPopupPreferredHeight(25 * this.popupItems.size() + 5);
        super.showPopup();
    }

    @Override
    public void changeList() {
        for (IListPopupItem item : this.popupItems) {
            ((AbstractListPopupItem)item).setDisplayValue(this.autoCompletionTextField.getText().trim());
        }
        super.changeList();
    }

    @Override
    public void executeItem(IListPopupItem item, boolean isOnRefresh) {
        if (item instanceof CompositeListPopupItem) {
            this.executeCompositeListPopupItem((CompositeListPopupItem)item);
            return;
        }
        this.autoCompletionTextField.addSelectedPopupItem(item);
    }

    private void executeCompositeListPopupItem(CompositeListPopupItem citem) {
        if (citem.getLinkType().equals((Object)CompositeListPopupItem.LinkType.OR) && (citem.getDisplayValue() == null || citem.getDisplayValue().length() == 0)) {
            return;
        }
        this.doExecuteCompositeListPopupItem(citem);
    }

    private void doExecuteCompositeListPopupItem(CompositeListPopupItem citem) {
        try {
            CompositeListPopupItem thisItem = (CompositeListPopupItem)citem.clone();
            thisItem.setCompareValue(citem.getDisplayValue());
            this.autoCompletionTextField.clearFilters();
            if (thisItem.getLinkType().equals((Object)CompositeListPopupItem.LinkType.AND)) {
                for (IListPopupItem item : thisItem.getListPopupItems()) {
                    this.autoCompletionTextField.addUserObject(item);
                }
            } else {
                this.autoCompletionTextField.addUserObject(thisItem);
            }
            this.popup.setVisible(false);
            this.executor.executeItem(thisItem, false);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public IListPopupItem prepareSelectedPopupItem(IListPopupItem item) {
        String value = item.getDisplayValue();
        AbstractListPopupItem lpi = item instanceof ListPopupItem ? this.preparePopupItem((ListPopupItem)item, (Object)value) : this.preparePopupItem((CompositeListPopupItem)item, (Object)value);
        return lpi;
    }

    private AbstractListPopupItem preparePopupItem(CompositeListPopupItem item, Object value) {
        CompositeListPopupItem lpi = null;
        try {
            lpi = (CompositeListPopupItem)item.clone();
            lpi.setCompareValue(value);
        }
        catch (CloneNotSupportedException e1) {
            SysUtil.abort();
        }
        return lpi;
    }

    private AbstractListPopupItem preparePopupItem(ListPopupItem item, Object value) {
        ListPopupItem lpi = null;
        try {
            lpi = (ListPopupItem)item.clone();
            lpi.setCompareValue(value);
        }
        catch (CloneNotSupportedException e1) {
            SysUtil.abort();
        }
        return lpi;
    }

    @Override
    public void executeSelectedPopupItem(IListPopupItem item) {
        if (item instanceof ListPopupItem) {
            this.executor.executeItem(this.createCompositeListPopupItem(), false);
        } else {
            this.executor.executeItem(item, false);
        }
    }

    IListPopupItem createCompositeListPopupItem() {
        if (!this.autoCompletionTextField.hasItemLabel()) {
            return null;
        }
        IListPopupItem[] items = this.autoCompletionTextField.getListPopupItems();
        CompositeListPopupItem citem = new CompositeListPopupItem(this);
        for (IListPopupItem item : items) {
            citem.addListPopupItem(item);
        }
        return citem;
    }

    @Override
    public void processKeyPress(KeyEvent e) {
        if (this.popup.isVisible()) {
            super.processKeyPress(e);
        } else if (e.getKeyCode() == 10) {
            this.executor.executeItem(this.createCompositeListPopupItem(), false);
        }
    }

    @Override
    public ItemLabel createItemLabel(IQueryTextField queryTextField, IListPopupItem listPopupItem) {
        ItemLabel itemLabel = super.createItemLabel(queryTextField, listPopupItem);
        int maxWidthOfTextLabel = this.autoCompletionTextField.getInputMaxWidth() / 3 - itemLabel.getItemLabelWidth() - QueryTextField.iconGap * 3 - 2;
        itemLabel.setMaxTextLabelWidth(maxWidthOfTextLabel);
        return itemLabel;
    }
}

