/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.dingtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.dingtalk.DingtalkUrlContants;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class DingtalkAPIInvokeUtil {
    private static final Logger logger = Logger.getLogger(DingtalkAPIInvokeUtil.class);
    private static ConcurrentHashMap<String, AccessTokenInfo> accessTokenMap = new ConcurrentHashMap();

    public static String getAccessToken(String appKey) {
        AccessTokenInfo accessTokenInfo;
        block9: {
            long curTime;
            long passTime;
            accessTokenInfo = null;
            if (StringUtils.isEmpty((String)appKey)) {
                throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, appKey);
            }
            if (accessTokenMap.get(appKey) != null && !StringUtils.isEmpty((String)(accessTokenInfo = accessTokenMap.get(appKey)).accessToken) && (passTime = (curTime = System.currentTimeMillis()) - accessTokenInfo.accessTokenTime) / 1000L < accessTokenInfo.expireTime) {
                return accessTokenInfo.accessToken;
            }
            String accessToken = "";
            String AppSecret = XTServiceConfig.getInstance().getAppSecret(appKey);
            if (StringUtils.isEmpty((String)AppSecret)) {
                logger.error((Object)"===  DingtalkLogin getAccessToken no AppSecret ===");
                throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, appKey);
            }
            String url = DingtalkUrlContants.GET_ACCESSTOKEN_URL + "?appkey=" + appKey + "&appsecret=" + AppSecret;
            try {
                String dingtalkResult;
                if (accessTokenInfo == null) {
                    accessTokenInfo = new AccessTokenInfo();
                }
                if (StringUtils.isEmpty((String)(dingtalkResult = HttpClientUtil.doGet(url, "UTF-8")))) break block9;
                JSONObject jsonObj = JSON.parseObject((String)dingtalkResult);
                if (0L == jsonObj.getLong("errcode") && "ok".equalsIgnoreCase(jsonObj.getString("errmsg"))) {
                    accessTokenInfo.accessToken = jsonObj.getString("access_token");
                    accessTokenInfo.accessTokenTime = System.currentTimeMillis();
                    accessTokenMap.put(appKey, accessTokenInfo);
                    break block9;
                }
                throw new WorkflowException(WorkflowErrorEnums.CONNET_DINGTALKTOKENURL_EXCEPTION, null, jsonObj.getString("errmsg"));
            }
            catch (WorkflowException e) {
                logger.error((Object)"DingtalkLogin getAccessToken Exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"DingtalkLogin getAccessToken Exception", (Throwable)e);
                throw new WorkflowException(WorkflowErrorEnums.CONNET_DINGTALKTOKENURL_EXCEPTION, null, e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)accessTokenInfo.accessToken)) {
            throw new WorkflowException(WorkflowErrorEnums.CONNET_DINGTALKTOKENURL_EXCEPTION, null, appKey);
        }
        return accessTokenInfo.accessToken;
    }

    public static String pushTodoMessage(String msg, String appKey) throws Exception {
        logger.error((Object)("DingtalkLogin  pushTodoMessage appKey:" + appKey));
        String accessToken = DingtalkAPIInvokeUtil.getAccessToken(appKey);
        String url = DingtalkUrlContants.PUSH_TODO_URL + "?access_token=" + accessToken;
        logger.error((Object)("DingtalkLogin  pushTodoMessage url:" + url));
        return HttpClientUtil.doPost(url, msg, "UTF-8");
    }

    public static String pushNoticeMessage(String msg, String appKey) throws Exception {
        String accessToken = DingtalkAPIInvokeUtil.getAccessToken(appKey);
        String url = DingtalkUrlContants.PUSH_NOTICE_URL + "?access_token=" + accessToken;
        return HttpClientUtil.doPost(url, msg, "UTF-8");
    }

    public static String pushTodoTask(String msg, String unionid, String appKey) throws Exception {
        logger.error((Object)("DingtalkLogin  pushTodoMessage appKey:" + appKey));
        String url = DingtalkUrlContants.PUSH_TASK_URL.replace("{unionId}", unionid);
        logger.error((Object)("DingtalkLogin  pushTodoMessage url:" + url));
        String accessToken = DingtalkAPIInvokeUtil.getAccessToken(appKey);
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("x-acs-dingtalk-access-token", accessToken);
        return HttpClientUtil.doPost(url, msg, head, "UTF-8");
    }

    public static String getDingtalkUserUnionid(String dingtalkUserid, String appKey) throws Exception {
        logger.error((Object)("DingtalkLogin  getDingtalkUserUnionid dingtalkUserid:" + dingtalkUserid));
        String accessToken = DingtalkAPIInvokeUtil.getAccessToken(appKey);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userid", dingtalkUserid);
        String unionid = "";
        String url = DingtalkUrlContants.GET_USERDETAILINFO_V2URL + "?access_token=" + accessToken;
        String re = HttpClientUtil.doPost(url, JSON.toJSONString(param), "UTF-8");
        if (!StringUtils.isEmpty((String)re)) {
            JSONObject reObj = JSON.parseObject((String)re);
            if (reObj.getInteger("errcode") == 0 && "ok".equals(reObj.get((Object)"errmsg"))) {
                JSONObject resultObj = reObj.getJSONObject("result");
                unionid = resultObj.getString("unionid");
            } else {
                logger.error((Object)("getDingtalkUserUnionid failed appKey:" + appKey + ",response:" + re));
            }
        }
        return unionid;
    }

    public static String updateTodoMessage(String msg, String appKey) throws Exception {
        String accessToken = DingtalkAPIInvokeUtil.getAccessToken(appKey);
        String url = DingtalkUrlContants.UPDATE_TODO_URL + "?access_token=" + accessToken;
        return HttpClientUtil.doPost(url, msg, "UTF-8");
    }

    public static String updateTaskMessage(String msg, String unionid, String msgId, String appKey) throws Exception {
        String accessToken = DingtalkAPIInvokeUtil.getAccessToken(appKey);
        String url = DingtalkUrlContants.UPDATE_TASK_URL;
        url = url.replace("{unionId}", unionid).replace("{taskId}", msgId);
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("x-acs-dingtalk-access-token", accessToken);
        return HttpClientUtil.doPut(url, msg, head, "UTF-8");
    }

    public static String getDingtalkUserIdByPhone(String phone, String appKey) throws Exception {
        String accessToken = DingtalkAPIInvokeUtil.getAccessToken(appKey);
        String url = DingtalkUrlContants.GET_USERIDBYPHONE_URL + "?access_token=" + accessToken;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("mobile", phone);
        String paramStr = JSON.toJSONString(param);
        String re = HttpClientUtil.doPost(url, paramStr, "UTF-8");
        String dingtalkUserid = "";
        if (!StringUtils.isEmpty((String)re)) {
            JSONObject reObj = JSON.parseObject((String)re);
            if (reObj.getInteger("errcode") == 0 && "ok".equals(reObj.get((Object)"errmsg"))) {
                JSONObject resultObj = reObj.getJSONObject("result");
                dingtalkUserid = resultObj.getString("userid");
            } else {
                logger.error((Object)("getDingtalkUserIdByPhone failed appKey:" + appKey + ",response:" + re));
            }
        }
        return dingtalkUserid;
    }

    public static String[] tryAutoBind(Context ctx, String appKey, String userId) {
        String[] Idsarr = null;
        try {
            IUser user = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(userId));
            if (userInfo != null) {
                String phoneNumber = userInfo.getCell();
                phoneNumber = StringUtils.isEmpty((String)phoneNumber) ? userInfo.getOfficePhone() : phoneNumber;
                String string = phoneNumber = StringUtils.isEmpty((String)phoneNumber) ? userInfo.getHomePhone() : phoneNumber;
                if (!StringUtils.isEmpty((String)phoneNumber)) {
                    String dingtalkUserId = DingtalkAPIInvokeUtil.getDingtalkUserIdByPhone(phoneNumber, appKey);
                    String unionid = DingtalkAPIInvokeUtil.getDingtalkUserUnionid(dingtalkUserId, appKey);
                    if (!StringUtils.isEmpty((String)dingtalkUserId) && !StringUtils.isEmpty((String)unionid)) {
                        Idsarr = new String[]{dingtalkUserId, unionid};
                        DingtalkAPIInvokeUtil.saveOrUpdateBind(ctx, dingtalkUserId, unionid, userInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Dingtalk Messages UserInfo tryAutoBind failed!", (Throwable)e);
        }
        return Idsarr;
    }

    private static void saveOrUpdateBind(Context ctx, String userid, String unionid, UserInfo userInfo) {
        String sql = "SELECT FID FROM T_PM_EASDTUSERMAP WHERE FUSERID = ? OR FXTID = ? ";
        String easUserId = userInfo.getId().toString();
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{easUserId, userid});
            if (dataSet.next()) {
                sql = "UPDATE T_PM_EASDTUSERMAP SET FXTID = ?,FUNIONID = ? WHERE FUSERID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, unionid, easUserId});
            } else {
                String fpersonid = userInfo.getPerson().getId().toString();
                String fnumber = userInfo.getNumber();
                String fname = userInfo.getName();
                sql = "INSERT INTO T_PM_EASDTUSERMAP (FID, FPERSONID, FUSERID, FXTID, FUSERNUMBER,FUSERNAME,FUNIONID,FPERSONNAME)  VALUES(NEWBOSID('ABCD8899'),?,?,?,?,?,?,'\u6d88\u606f\u63a8\u9001\u7ed1\u5b9a')";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fpersonid, easUserId, userid, fnumber, fname, unionid});
            }
        }
        catch (Exception e) {
            logger.error((Object)"DingtalkAPIInvokeUtil saveOrUpdateBind error: ", (Throwable)e);
        }
    }

    private static class AccessTokenInfo {
        private String accessToken = null;
        private long accessTokenTime = 0L;
        private long expireTime = 7000L;

        private AccessTokenInfo() {
        }
    }
}

