/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.filter.CustomRequestWrapper;
import com.kingdee.lightapp.filter.DeployTestUtil;
import com.kingdee.lightapp.filter.login.BatchDealLoginAction;
import com.kingdee.lightapp.util.McloudParamsUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.wx.WXUtil;
import com.kingdee.lightapp.xt.LightAppServiceFacade;
import com.kingdee.lightapp.xt.UserNotFoundException;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.lightapp.xt.util.LoginHelper;
import com.kingdee.lightapp.xt.util.MsgConfirmHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import sun.misc.BASE64Decoder;

public class LightAppLoginFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(LightAppLoginFilter.class);
    private String[] userKey;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String errorInfo;
        Context ctx;
        String appId;
        String ticket;
        String openid;
        String eid;
        block26: {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            eid = request.getParameter("eid");
            openid = request.getParameter("openid");
            String nonce = request.getParameter("nonce");
            String timestamp = request.getParameter("timestamp");
            String opentoken = request.getParameter("opentoken");
            String pubaccid = request.getParameter("pubaccid");
            ticket = request.getParameter("ticket");
            appId = request.getParameter("appid");
            String code = request.getParameter("code");
            String state = request.getParameter("state");
            String token = request.getParameter("token");
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            String action = request.getParameter("action");
            String batchDealSign = request.getParameter("batchDealSign");
            String batchDealParam = request.getParameter("batchDealParam");
            ctx = null;
            HttpSession session = httpRequest.getSession();
            String servletPath = httpRequest.getServletPath();
            String methodName = request.getParameter("serviceMethodName");
            if ("getApiVersion".equals(methodName) || servletPath.endsWith(".html")) {
                chain.doFilter(request, response);
                return;
            }
            if ("/workflow".equals(httpRequest.getRequestURI()) && httpRequest.getParameterMap().size() == 0 || "/workflow/".equals(httpRequest.getRequestURI()) && httpRequest.getParameterMap().size() == 0) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String redirect = httpResponse.encodeRedirectURL("/workflow/index.html");
                httpResponse.sendRedirect(redirect);
                return;
            }
            if ("getunusualmsg".equalsIgnoreCase(action)) {
                this.dohanding(httpRequest, response);
                return;
            }
            if ("getUserPic".equalsIgnoreCase(action)) {
                this.getUserPic(httpRequest, response);
                return;
            }
            if ("bind".equalsIgnoreCase(action)) {
                this.bind(httpRequest, response);
                return;
            }
            if ("testDeploy".equalsIgnoreCase(action)) {
                DeployTestUtil.check(httpRequest, response);
                return;
            }
            if (servletPath.endsWith("/qing/lappEntrance.do") && request.getParameter("access_token") != null) {
                chain.doFilter(request, response);
                return;
            }
            if ("easLogin".equals(action)) {
                this.doEasLogin(httpRequest, response, eid, username, password);
                return;
            }
            String isWX = (String)session.getAttribute("isWX");
            System.out.println("lightapp isWX  = " + isWX);
            errorInfo = "";
            try {
                if ("true".equals(isWX) || this.isNotNull(state)) {
                    ctx = this.doWxLogin(httpRequest, response, eid, code, state);
                    break block26;
                }
                if (this.isNotNull(appId) && this.isNotNull(ticket)) {
                    ctx = this.doMcloudLogin(httpRequest, response, eid, appId, ticket);
                    if (!"10679".equals(appId) && !"10954".equals(appId) && !servletPath.endsWith("/qing/lappEntrance.do")) break block26;
                    HttpServletResponse res = (HttpServletResponse)response;
                    IUser user = null;
                    String userName = "";
                    try {
                        user = UserFactory.getLocalInstance((Context)ctx);
                        UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(ctx.getCaller().toString()));
                        userName = userInfo.getNumber();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String ltpatoken = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig()).toString();
                    String businessUrl = this.buildBusinessUrl(httpRequest);
                    String redirectUrl = "/portal/index2sso.jsp?username=" + userName + "&password=" + ltpatoken + "&isNotCheckRelogin=true&redirectTo=" + URLEncoder.encode(businessUrl, "UTF-8") + "&isTokenLogin=true";
                    logger.error((Object)("CloudLoginEASFilter loginEAS redirectUrl===" + redirectUrl));
                    res.sendRedirect(redirectUrl);
                    return;
                }
                if (this.isNotNull(token)) {
                    ctx = this.doOtherLogin(httpRequest, response, eid, token);
                    break block26;
                }
                if (!StringUtils.isEmpty((String)username)) {
                    ctx = this.doAPPLogin(httpRequest, response, eid, username, password);
                    break block26;
                }
                if (this.isNotNull(eid) && this.isNotNull(openid) && this.isNotNull(nonce) && this.isNotNull(timestamp) && this.isNotNull(opentoken) && this.isNotNull(pubaccid)) {
                    logger.info((Object)"enter from XT!");
                    session.setAttribute("isXTOld", (Object)"true");
                    ctx = this.loginEASByXT(httpRequest, eid, openid, nonce, timestamp, opentoken, pubaccid);
                    break block26;
                }
                if (this.isNotNull(eid) && this.isNotNull(openid) && this.isNotNull(appId)) {
                    logger.info((Object)"enter from XT  for xietong!");
                    ctx = this.loginEASByXT(httpRequest, appId, eid, openid);
                    break block26;
                }
                if (this.isNotNull(batchDealParam) && this.isNotNull(batchDealSign)) {
                    try {
                        ctx = this.loginEASBySign(httpRequest, batchDealParam, batchDealSign);
                        break block26;
                    }
                    catch (Exception e) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("success", false);
                        map.put("errorCode", -1);
                        map.put("error", "\u767b\u5f55\u5931\u8d25");
                        map.put("data", new HashMap());
                        this.writeResponseJson(response, map);
                        return;
                    }
                }
                logger.info((Object)"get XTContext from session!");
                if (session.getAttribute("XTContext") != null) {
                    ctx = (Context)session.getAttribute("XTContext");
                    break block26;
                }
                logger.info((Object)"params and session are null.");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("errorCode", "noParamsAndSession");
                this.writeResponseJson(response, map);
                return;
            }
            catch (UserNotFoundException e) {
                logger.error((Object)("lightapp LightAppLoginFilter login UserNotFoundException :: " + e.getMessage()), (Throwable)e);
                System.out.println("--------------\"errorCode\", \"UserNotFound\"");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("errorCode", "UserNotFound");
                this.writeResponseJson(response, map);
                return;
            }
            catch (WorkflowException wfe) {
                logger.error((Object)("LightAppLoginFilter WorkflowException error :: " + wfe.getMessage()), (Throwable)wfe);
                this.writeResponseExceptionJson(response, wfe);
                return;
            }
            catch (Exception e) {
                logger.error((Object)("lightapp LightAppLoginFilter login error11 :: " + e.getMessage()), (Throwable)e);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("errorCode", e.getMessage());
                this.writeResponseJson(response, map);
                return;
            }
        }
        if (ctx != null) {
            HttpServletRequest resq = (HttpServletRequest)request;
            CustomRequestWrapper newRequest = new CustomRequestWrapper(resq);
            newRequest.removeParameter("ticket");
            chain.doFilter((ServletRequest)newRequest, response);
        } else {
            HttpServletResponse res = (HttpServletResponse)response;
            res.sendRedirect("/lightapp/loginerr.jsp?appid=" + appId + "&ticket=" + ticket + "&eid=" + eid + "&openid=" + openid + "&errorInfo=" + errorInfo);
        }
    }

    private void writeResponseJson(ServletResponse response, HashMap map) throws IOException {
        JSONObject jsonObject = new JSONObject((Map)map);
        String result = jsonObject.toString();
        HttpServletResponse res = (HttpServletResponse)response;
        res.getWriter().write(result);
        res.getWriter().flush();
    }

    private void writeResponseExceptionJson(ServletResponse response, WorkflowException wfe) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        this.writeResponseJson(response, wfe.toInfoMap());
    }

    private Context loginEASBySign(HttpServletRequest httpRequest, String batchDealParam, String batchDealSign) throws Exception {
        Context ctx = BatchDealLoginAction.login(httpRequest, batchDealParam, batchDealSign);
        return ctx;
    }

    private String buildBusinessUrl(HttpServletRequest request) {
        String url = request.getRequestURI() + "?";
        Map paramMap = request.getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            Object ov = entry.getValue();
            String[] value = new String[1];
            if (ov instanceof String[]) {
                value = (String[])ov;
            } else {
                value[0] = ov.toString();
            }
            if (value[0] == null || "ticket".equals(entry.getKey())) continue;
            url = url + (String)entry.getKey() + "=" + URLEncoder.encode(value[0]) + "&";
        }
        return url.substring(0, url.length() - 1);
    }

    private Context doAPPLogin(HttpServletRequest httpRequest, ServletResponse response, String eid, String username, String password) throws IOException {
        HttpSession session = httpRequest.getSession();
        Context ctx = null;
        try {
            if (session.getAttribute("XTContext") != null) {
                ctx = (Context)session.getAttribute("XTContext");
            } else {
                ctx = LoginHelper.loginEAS(eid, URLDecoder.decode(username), password, "");
                session.setAttribute("XTContext", (Object)ctx);
                session.setAttribute("sessionTime", (Object)System.currentTimeMillis());
            }
        }
        catch (UserNotFoundException e) {
            logger.error((Object)e.getMessage());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("errorCode", "UserNotFound");
            this.writeResponseJson(response, map);
        }
        catch (WorkflowException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            HttpServletResponse res = (HttpServletResponse)response;
            res.sendRedirect("/lightapp/loginerr.jsp?eid=" + eid + "&username=" + username + "&errorInfo=" + e.getMessage());
        }
        return ctx;
    }

    private void doKKLogin(HttpServletRequest httpRequest, ServletResponse response, String eid, String token) throws IOException {
        HttpSession session = httpRequest.getSession();
        Context ctx = null;
        if (this.needLoginEas(session, eid)) {
            try {
                String username = this.getUserName(token);
                LtpaToken ltpatoken = LtpaTokenManager.generate((String)username, (String)LtpaTokenManager.getDefaultLtpaConfig());
                String authPassword = ltpatoken.getTokenStr();
                String encodePwd = CryptoTean.encrypt((String)username, (String)authPassword);
                ctx = LoginHelper.loginEAS(eid, username, encodePwd, "BaseTrdLtpaToken");
                httpRequest.getSession().setAttribute("XTContext", (Object)ctx);
                httpRequest.getSession().setAttribute("sessionTime", (Object)System.currentTimeMillis());
                httpRequest.getSession().setAttribute("eid", (Object)eid);
            }
            catch (UserNotFoundException e) {
                logger.error((Object)("lightapp LightAppLoginFilter login error :: " + e.getMessage()), (Throwable)e);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("errorCode", "EAS_LOGIN_CODE_00001");
                this.writeResponseJson(response, map);
                return;
            }
            catch (Exception e) {
                logger.error((Object)("lightapp LightAppLoginFilter login error :: " + e.getMessage() + e));
                HttpServletResponse res = (HttpServletResponse)response;
                res.sendRedirect("/lightapp/loginerr.jsp?eid=" + eid + "token=" + token + "&errorInfo=" + e.getMessage());
                return;
            }
        } else {
            ctx = (Context)session.getAttribute("XTContext");
        }
    }

    private void doEasLogin(HttpServletRequest httpRequest, ServletResponse response, String eid, String username, String password) throws IOException {
        HttpSession session = httpRequest.getSession();
        String result = "";
        try {
            password = URLDecoder.decode(password);
            Context ctx = LoginHelper.loginEAS(eid, username, password, "");
            session.setAttribute("XTContext", (Object)ctx);
            result = ctx == null ? "error" : "success";
        }
        catch (WorkflowException e) {
            logger.error((Object)("lightapp LightAppLoginFilter login error :: " + e.getMessage() + e));
            result = "error:" + e.getErrorDetail();
        }
        catch (Exception e) {
            logger.error((Object)("lightapp LightAppLoginFilter login error :: " + e.getMessage() + e));
            result = "error:" + e.getMessage();
        }
        HttpServletResponse res = (HttpServletResponse)response;
        res.getWriter().write(result);
        res.getWriter().flush();
    }

    public static String getFromBase64(String s) {
        byte[] b = null;
        String result = null;
        if (s != null) {
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                b = decoder.decodeBuffer(s);
                result = new String(b, "gb2312");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Context doOtherLogin(HttpServletRequest httpRequest, ServletResponse response, String eid, String token) throws IOException {
        HttpSession session = httpRequest.getSession();
        Context ctx = null;
        String username = "";
        String secret = "";
        if (this.needLoginEas(session, eid)) {
            try {
                String tokenurl = XTServiceConfig.getInstance().getOtherAppUrl("tokenurl");
                String appid = XTServiceConfig.getInstance().getOtherAppUrl("appid");
                secret = XTServiceConfig.getInstance().getOtherAppUrl("secret");
                if (!StringUtils.isEmpty((String)tokenurl)) {
                    String result = LightAppLoginFilter.getUserBytokenUrl(tokenurl, token, appid, secret);
                    JSONObject jsonObj = JSON.parseObject((String)result);
                    String telphone = (String)jsonObj.get((Object)"telphone");
                    if (!StringUtils.isEmpty((String)telphone)) {
                        UserInfo user = LoginHelper.getUserByPhone(ctx, telphone);
                        username = user.getNumber();
                    } else {
                        username = (String)jsonObj.get((Object)"username");
                    }
                    if (StringUtils.isEmpty((String)username)) {
                        username = (String)jsonObj.get((Object)"message");
                    }
                } else {
                    username = this.getUserName(token);
                }
                if (StringUtils.isEmpty((String)username)) {
                    throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_OTHERAPPPARAMSERROE);
                }
                LtpaToken ltpatoken = LtpaTokenManager.generate((String)username, (String)LtpaTokenManager.getDefaultLtpaConfig());
                String authPassword = ltpatoken.getTokenStr();
                String encodePwd = CryptoTean.encrypt((String)username, (String)authPassword);
                ctx = LoginHelper.loginEAS(eid, username, encodePwd, "BaseTrdLtpaToken");
                httpRequest.getSession().setAttribute("openid", (Object)username);
                httpRequest.getSession().setAttribute("XTContext", (Object)ctx);
                httpRequest.getSession().setAttribute("sessionTime", (Object)System.currentTimeMillis());
                httpRequest.getSession().setAttribute("eid", (Object)eid);
            }
            catch (WorkflowException e) {
                throw e;
            }
            catch (UserNotFoundException e) {
                logger.error((Object)("lightapp LightAppLoginFilter login error :: " + e.getMessage()), (Throwable)e);
                throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_NOOTHERAPPPARAMS);
            }
            catch (Exception e) {
                logger.error((Object)("lightapp LightAppLoginFilter login error :: " + e.getMessage() + e));
                throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_NOOTHERAPPPARAMS);
            }
        } else {
            ctx = (Context)session.getAttribute("XTContext");
        }
        return ctx;
    }

    private Context doMcloudLogin(HttpServletRequest httpRequest, ServletResponse response, String eid, String appId, String ticket) throws Exception {
        HttpSession session = httpRequest.getSession();
        Context ctx = null;
        if (this.needLoginEas(session, eid)) {
            session.setAttribute("isXT", (Object)"true");
            ctx = this.loginEAS(httpRequest, appId, ticket);
        } else {
            ctx = (Context)session.getAttribute("XTContext");
        }
        return ctx;
    }

    private Context doWxLogin(HttpServletRequest httpRequest, ServletResponse response, String eid, String code, String state) throws Exception {
        HttpSession session = httpRequest.getSession();
        Context ctx = null;
        if (this.needLoginEas(session, eid)) {
            session.setAttribute("isWX", (Object)"true");
            if (code != null) {
                session.setAttribute("code", (Object)code);
            }
            if (state != null) {
                session.setAttribute("state", (Object)state);
            }
            ctx = this.loginEASByWx(httpRequest, code, state);
        } else {
            ctx = (Context)session.getAttribute("XTContext");
        }
        return ctx;
    }

    private void bind(HttpServletRequest httpRequest, ServletResponse response) throws IOException {
        String result;
        try {
            Map map = WXUtil.doBind(httpRequest);
            JSONObject jsonObject = new JSONObject(map);
            result = jsonObject.toString();
        }
        catch (WorkflowException e) {
            HashMap<String, Object> infoMap = e.toInfoMap();
            infoMap.put("result", "error");
            result = JSON.toJSONString(infoMap);
        }
        catch (Exception e) {
            logger.debug((Object)"LightAppLoginFilter bind error:", (Throwable)e);
            result = "{result:\"" + e.getMessage() + "\"}";
        }
        HttpServletResponse res = (HttpServletResponse)response;
        res.getWriter().write(result);
        res.getWriter().flush();
    }

    private void getUserPic(HttpServletRequest httpRequest, ServletResponse response) throws IOException {
        String result;
        try {
            Map map = WXUtil.doGetUserPic(httpRequest);
            JSONObject jsonObject = new JSONObject(map);
            result = jsonObject.toString();
        }
        catch (Exception e) {
            result = "{error:\"" + e.getMessage() + "\"}";
        }
        HttpServletResponse res = (HttpServletResponse)response;
        res.getWriter().write(result);
        res.getWriter().flush();
    }

    private void dohanding(HttpServletRequest httpRequest, ServletResponse response) throws IOException {
        String result;
        String type = httpRequest.getParameter("type");
        try {
            List list;
            Map m;
            if ("reSendMsg".equals(type)) {
                m = MsgConfirmHelper.reSendMsg(httpRequest);
                result = JSON.toJSONString((Object)m);
            } else if ("reChangeMsg".equals(type)) {
                m = MsgConfirmHelper.reChangeMsg(httpRequest);
                result = JSON.toJSONString((Object)m);
            } else if ("getAllUndoneMsg".equals(type)) {
                list = MsgConfirmHelper.getAllUndoneMsg(httpRequest);
                result = JSON.toJSONString((Object)list);
            } else {
                list = MsgConfirmHelper.getAllUnUsualMsg(httpRequest);
                result = JSON.toJSONString((Object)list);
            }
        }
        catch (Exception e) {
            result = "{error:\"" + e.getMessage() + "\"}";
            logger.error((Object)result);
        }
        HttpServletResponse res = (HttpServletResponse)response;
        res.getWriter().write(result);
        res.getWriter().flush();
    }

    private static String getUserBytokenUrl(String tokenurl, String token, String appid, String secret) {
        ByteArrayOutputStream outStream = null;
        InputStream inputStream = null;
        try {
            String username = "";
            tokenurl = tokenurl.indexOf("?") > -1 ? tokenurl + "&token=" + token : tokenurl + "?token=" + token;
            URL url = new URL(tokenurl);
            URLConnection URLconnection = url.openConnection();
            HttpURLConnection httpConnection = (HttpURLConnection)URLconnection;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("appid", appid);
            map.put("secret", secret);
            map.put("token", token);
            String value = JSON.toJSONString(map);
            httpConnection.addRequestProperty("loginInfo", value);
            httpConnection.setReadTimeout(5000);
            httpConnection.setReadTimeout(5000);
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                outStream = new ByteArrayOutputStream();
                inputStream = httpConnection.getInputStream();
                byte[] data = new byte[1024];
                int count = -1;
                while ((count = inputStream.read(data, 0, 1024)) != -1) {
                    outStream.write(data, 0, count);
                }
                data = null;
                String string = new String(outStream.toByteArray());
                return string;
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_OTHERTOKENURL_IOEXCEPTION, tokenurl, null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_OTHERTOKENURL_FAILED, tokenurl, null);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    inputStream = null;
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    outStream = null;
                }
            }
        }
        return null;
    }

    private boolean needLoginEas(HttpSession session, String eid) {
        boolean need = true;
        if (session.getAttribute("sessionTime") != null) {
            System.out.println("lightapp sessionTime  = " + session.getAttribute("sessionTime"));
            String seid = (String)session.getAttribute("eid");
            if (!StringUtils.isEmpty((String)eid) && (!StringUtils.isEmpty((String)seid) && !eid.equals(seid) || StringUtils.isEmpty((String)seid))) {
                session.setAttribute("seid", (Object)eid);
                return true;
            }
            need = false;
        }
        if (!need) {
            if (session.getAttribute("XTContext") == null) {
                System.out.println("lightapp XTContext  = null");
                need = true;
            }
        } else {
            session.setAttribute("XTContext", null);
            session.setAttribute("openId", null);
        }
        return need;
    }

    private boolean isNotNull(String str) {
        boolean bl = true;
        if (str == null || str.length() < 1 || "null".equals(str.toLowerCase(Locale.ENGLISH))) {
            bl = false;
        }
        return bl;
    }

    private Context loginEAS(HttpServletRequest httpRequest, String appId, String ticket) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        XtParamsDTO xtparamsDto = McloudParamsUtil.getInstance().getXtParamsDTO(httpRequest, appId, ticket);
        if (!StringUtils.isEmpty((String)httpRequest.getParameter("eid"))) {
            xtparamsDto.setEid(httpRequest.getParameter("eid"));
        }
        if (xtparamsDto == null || xtparamsDto.getEid() == null || xtparamsDto.getOpenid() == null) {
            logger.error((Object)"LightAppLoginFilter == loginEAS== get params from mclound error!!!");
            throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_NOXTPARAMSDTO);
        }
        ctx = LightAppServiceFacade.loginEAS(httpRequest, xtparamsDto);
        session.setAttribute("openid", (Object)xtparamsDto.getOpenid());
        session.setAttribute("eid", (Object)xtparamsDto.getEid());
        return ctx;
    }

    public String getUserName(String tokenString) {
        byte[] token = Base64.decode((String)tokenString);
        int length = token.length - 40;
        byte[] bytes = new byte[length];
        System.arraycopy(token, 20, bytes, 0, length);
        String username = this.formatUser(new String(bytes));
        System.out.println("username:" + username);
        return username;
    }

    private String formatUser(String user) {
        int index;
        String[] userInfo = user.split("\\s*[/,;]\\s*");
        if (userInfo.length > 1 && this.userKey != null) {
            for (int i = 0; i < this.userKey.length; ++i) {
                String key = this.userKey[i] + "=";
                for (int j = 0; j < userInfo.length; ++j) {
                    if (!userInfo[j].toUpperCase(Locale.ENGLISH).startsWith(key.toUpperCase(Locale.ENGLISH))) continue;
                    return userInfo[j].substring(key.length());
                }
            }
        }
        if ((index = userInfo[0].indexOf(61)) == -1) {
            return userInfo[0];
        }
        return userInfo[0].substring(index + 1);
    }

    private Context loginEASByWx(HttpServletRequest httpRequest, String code, String state) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        XtParamsDTO xtparamsDto = WXUtil.getXtParamsDTO(httpRequest, session, code, state);
        try {
            if (xtparamsDto == null || xtparamsDto.getEid() == null || xtparamsDto.getOpenid() == null) {
                logger.error((Object)"LightAppLoginFilter == loginEAS== get params from wx error!!!");
                throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_NOWXPARAMSDTO);
            }
            session.setAttribute("openid", (Object)xtparamsDto.getOpenid());
            session.setAttribute("eid", (Object)xtparamsDto.getEid());
            ctx = LightAppServiceFacade.loginEAS(httpRequest, xtparamsDto);
            session.setAttribute("XTContext", (Object)ctx);
            session.setAttribute("sessionTime", (Object)System.currentTimeMillis());
        }
        catch (UserNotFoundException e) {
            System.out.println("--------UserNotFoundException");
            boolean isFromXT = true;
            if (session.getAttribute("isWX") != null && session.getAttribute("isWX").toString().equalsIgnoreCase("true")) {
                isFromXT = false;
            }
            if (!isFromXT) {
                ctx = WXUtil.doAutoBind(httpRequest, xtparamsDto, code, state);
            }
            throw new UserNotFoundException();
        }
        return ctx;
    }

    private Context loginEASByXT(HttpServletRequest httpRequest, String eid, String openid, String nonce, String timestamp, String opentoken, String pubaccid) throws Exception {
        Context ctx = null;
        XtParamsDTO xtparamsDto = new XtParamsDTO();
        xtparamsDto.setEid(eid);
        xtparamsDto.setOpenid(openid);
        xtparamsDto.setOpentoken(opentoken);
        xtparamsDto.setNonce(nonce);
        xtparamsDto.setTimestamp(timestamp);
        xtparamsDto.setPubaccid(pubaccid);
        if (LightAppLoginFilter.checkLinkLegal(xtparamsDto)) {
            ctx = LightAppServiceFacade.loginEAS(httpRequest, xtparamsDto);
        } else {
            logger.error((Object)"LightAppLoginFilter == loginEASByXT== can not match the key!!!");
        }
        return ctx;
    }

    private Context loginEASByXT(HttpServletRequest httpRequest, String appId, String eid, String openid) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        XtParamsDTO xtparamsDto = McloudParamsUtil.getInstance().getXtParamsDTOByEid(appId, eid, openid);
        if (xtparamsDto == null || xtparamsDto.getEid() == null || xtparamsDto.getOpenid() == null) {
            logger.error((Object)"LightAppLoginFilter == loginEAS== get params from mclound error!!!");
            throw new Exception("EAS_LOGIN_CODE_00005");
        }
        session.setAttribute("openid", (Object)xtparamsDto.getOpenid());
        session.setAttribute("eid", (Object)xtparamsDto.getEid());
        ctx = LightAppServiceFacade.loginEAS(httpRequest, xtparamsDto);
        return ctx;
    }

    private static boolean checkLinkLegal(XtParamsDTO xtparamsDto) {
        boolean result = false;
        String pubacckey = XTServiceConfig.getInstance().getPubkeyBypubaccid(xtparamsDto.getEid(), xtparamsDto.getPubaccid());
        if (pubacckey == null) {
            logger.error((Object)"checkLinkLegal pubacckey is null");
            return result;
        }
        if (StringUtil.isNotEmpty(xtparamsDto.getEid())) {
            Object[] sourceData = new String[]{xtparamsDto.getEid(), xtparamsDto.getOpenid(), xtparamsDto.getPubaccid(), pubacckey, xtparamsDto.getNonce(), xtparamsDto.getTimestamp()};
            Arrays.sort(sourceData);
            String token = DigestUtils.shaHex((String)StringUtils.join((Object[])sourceData));
            if (xtparamsDto.getOpentoken().equals(token)) {
                result = true;
            }
        }
        return result;
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }

    public void destroy() {
    }
}

