/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.filter.login;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.lightapp.filter.login.SignUtil;
import com.kingdee.lightapp.util.McloudParamsUtil;
import com.kingdee.lightapp.xt.LightAppServiceFacade;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class BatchDealLoginAction {
    private static final Logger logger = Logger.getLogger(BatchDealLoginAction.class);

    public static Context login(HttpServletRequest httpRequest, String batchDealParam, String batchDealSign) throws Exception {
        String sourceIds;
        JSONArray ja;
        JSONObject jb = JSONObject.parseObject((String)batchDealParam);
        String eid = jb.getString("eid");
        String sourceType = jb.getString("sourceType");
        String openId = jb.getString("openId");
        boolean check = BatchDealLoginAction.checkSign(eid, openId, sourceType, ja = JSON.parseArray((String)(sourceIds = jb.getString("sourceIds"))), batchDealSign);
        if (!check) {
            logger.error((Object)"BatchDealLoginAction \uff1aSIGN\u6821\u9a8c\u5931\u8d25");
            throw new Exception("SIGN\u6821\u9a8c\u5931\u8d25");
        }
        logger.error((Object)"BatchDealLoginAction\uff1aSIGN\u6821\u9a8c\u6210\u529f");
        Context ctx = BatchDealLoginAction.loginEAS(httpRequest, eid, sourceType, openId);
        httpRequest.getSession().setAttribute("sessionTime", (Object)System.currentTimeMillis());
        return ctx;
    }

    private static boolean checkSign(String eid, String openId, String sourceType, JSONArray sourceIds, String sign) {
        String signKey = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "signKey", "");
        try {
            String mySign = BatchDealLoginAction.genSign(signKey, openId, sourceType, sourceIds);
            return sign.equals(mySign);
        }
        catch (Exception e) {
            logger.error((Object)"BatchDealLoginAction \uff1aSIGN\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private static String genSign(String signKey, String openId, String sourceType, JSONArray sourceIds) throws Exception {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(openId);
        vals.add(sourceType);
        if (!sourceIds.isEmpty()) {
            for (int i = 0; i < sourceIds.size(); ++i) {
                String sourceId = sourceIds.getString(i);
                vals.add(sourceId);
            }
        }
        Collections.sort(vals, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        String sortedVal = StringUtils.arrayToString((Object[])vals.toArray(), (String)"&");
        return SignUtil.genHmacSHA1(sortedVal, signKey);
    }

    private static Context loginEAS(HttpServletRequest httpRequest, String eid, String appId, String openid) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        XtParamsDTO xtparamsDto = McloudParamsUtil.getInstance().getXtParamsDTOByEid(appId, eid, openid);
        if (xtparamsDto == null || xtparamsDto.getEid() == null || xtparamsDto.getOpenid() == null) {
            logger.error((Object)"LightAppLoginFilter == loginEAS== get params from mclound error!!!");
            throw new Exception("EAS_LOGIN_CODE_00005");
        }
        session.setAttribute("openid", (Object)xtparamsDto.getOpenid());
        session.setAttribute("eid", (Object)xtparamsDto.getEid());
        ctx = LightAppServiceFacade.loginEAS(httpRequest, xtparamsDto);
        return ctx;
    }
}

