/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.pa.api;

import com.alibaba.fastjson.JSON;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.util.AppAuth2;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJUrlContants;
import com.kingdee.util.StringUtils;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class YZJInvokeUtil {
    private static final Logger logger = Logger.getLogger(YZJInvokeUtil.class);
    protected static YZJInvokeUtil instance = null;
    private static Map<String, AccessTokenInfo> accessTokenMap = new HashMap<String, AccessTokenInfo>();
    private static Map<String, AccessTokenInfo> teamAccessTokenMap = new HashMap<String, AccessTokenInfo>();

    private YZJInvokeUtil() {
    }

    public static YZJInvokeUtil getInstance() {
        if (instance == null) {
            instance = new YZJInvokeUtil();
        }
        return instance;
    }

    public String getAccessToken(String appId, String cloudtime) throws Exception {
        long curTime;
        long passTime;
        AccessTokenInfo accessTokenInfo = null;
        if (accessTokenMap.get(appId) != null && !StringUtils.isEmpty((String)(accessTokenInfo = accessTokenMap.get(appId)).accessToken) && (passTime = (curTime = System.currentTimeMillis()) - accessTokenInfo.accessTokenTime) / 1000L < accessTokenInfo.expireTime) {
            return accessTokenInfo.accessToken;
        }
        String apivs = XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        accessTokenInfo = "old".equalsIgnoreCase(apivs) ? this.getAccessTokenOld(appId) : this.getAccessTokenFromYZJ(null, appId, cloudtime, "app");
        accessTokenMap.put(appId, accessTokenInfo);
        return accessTokenInfo.accessToken;
    }

    public String getTeamAccessToken(String eid, String appId, String cloudtime) throws Exception {
        long curTime;
        long passTime;
        String key = eid + "-" + appId;
        AccessTokenInfo accessTokenInfo = null;
        if (teamAccessTokenMap.get(key) != null && !StringUtils.isEmpty((String)(accessTokenInfo = teamAccessTokenMap.get(key)).accessToken) && (passTime = (curTime = System.currentTimeMillis()) - accessTokenInfo.accessTokenTime) / 1000L < accessTokenInfo.expireTime) {
            return accessTokenInfo.accessToken;
        }
        accessTokenInfo = this.getAccessTokenFromYZJ(eid, appId, cloudtime, "team");
        teamAccessTokenMap.put(key, accessTokenInfo);
        return accessTokenInfo.accessToken;
    }

    private AccessTokenInfo getAccessTokenOld(String appId) {
        String secret = XTServiceConfig.getInstance().getAppSecret(appId);
        if (StringUtils.isEmpty((String)secret)) {
            throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, appId);
        }
        String url = YZJUrlContants.GET_ACCESSTOKEN_PRIURL + "?grant_type=client_credential&appid=" + appId + "&secret=" + secret;
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        accessTokenInfo.accessToken = "";
        String response = "";
        logger.error((Object)("getAccessTokenOld url:" + url));
        try {
            JSONObject jsonObj;
            String headerValue = AppAuth2.appAuth2Treaty(appId, secret);
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("authorization", headerValue);
            response = HttpClientUtil.doGet(url, headMap, "UTF-8");
            if (!StringUtil.isNotEmpty(response)) {
                logger.error((Object)"getAccessTokenOld response is null");
                throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_NORESPONSE);
            }
            JSONObject obj = jsonObj = new JSONObject(response);
            accessTokenInfo.accessToken = obj.getString("access_token");
            accessTokenInfo.expireTime = Long.parseLong(obj.getString("expires_in"));
            accessTokenInfo.accessTokenTime = System.currentTimeMillis();
        }
        catch (WorkflowException e) {
            logger.error((Object)("YZJInvokeUtil getAccessToken message getAccessToken url==" + url + " \u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
            throw e;
        }
        catch (UnknownHostException e) {
            logger.error((Object)("YZJInvokeUtil getAccessToken message getAccessToken url==" + url + " \u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_UNKNOWNHOST, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        catch (SocketException e) {
            logger.error((Object)("YZJInvokeUtil getAccessToken message getAccessToken url==" + url + " \u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_SOCKETEXCEPTION, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        catch (JSONException e) {
            logger.error((Object)("YZJInvokeUtil getAccessToken message getAccessToken url==" + url + " \u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_JSONEXCEPTION, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        catch (Exception e) {
            accessTokenInfo.expireTime = 0L;
            logger.error((Object)("YZJInvokeUtil getAccessToken message getAccessToken url==" + url + " \u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_EXCEPTION, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        return accessTokenInfo;
    }

    private AccessTokenInfo getAccessTokenFromYZJ(String eid, String appId, String cloudtime, String tokenScope) {
        String secret = XTServiceConfig.getInstance().getAppSecret(appId);
        if (StringUtils.isEmpty((String)secret)) {
            throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, appId);
        }
        long timeStrap = this.getTimeStamp(cloudtime);
        String url = YZJUrlContants.GET_ACCESSTOKEN_URL;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)eid)) {
            param.put("eid", eid);
        }
        param.put("scope", tokenScope);
        param.put("appId", appId);
        param.put("secret", secret);
        param.put("timestamp", timeStrap);
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        accessTokenInfo.accessToken = "";
        String response = "";
        accessTokenInfo.accessTokenTime = System.currentTimeMillis();
        try {
            JSONObject jsonObj;
            response = HttpClientUtil.doPost(url, JSON.toJSONString(param), "UTF-8");
            if (StringUtil.isNotEmpty(response)) {
                jsonObj = new JSONObject(response);
                if (jsonObj == null || !jsonObj.getBoolean("success")) {
                    accessTokenInfo.expireTime = 0L;
                    logger.error((Object)("YZJInvokeUtil getAccessToken message url==" + url + "  \u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25\u8fd4\u56de\u4fe1\u606f = " + response));
                    String moreDetail = "\u9519\u8bef:" + jsonObj.get("errorCode") + ":" + jsonObj.get("error");
                    throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_FAILED, YZJUrlContants.GET_ACCESSTOKEN_URL, moreDetail);
                }
            } else {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_NORESPONSE);
            }
            JSONObject obj = (JSONObject)jsonObj.get("data");
            accessTokenInfo.accessToken = obj.getString("accessToken");
            accessTokenInfo.expireTime = Long.parseLong(obj.getString("expireIn"));
        }
        catch (WorkflowException e) {
            throw e;
        }
        catch (UnknownHostException e) {
            throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_UNKNOWNHOST, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        catch (SocketException e) {
            throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_SOCKETEXCEPTION, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        catch (JSONException e) {
            throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_JSONEXCEPTION, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        catch (Exception e) {
            accessTokenInfo.expireTime = 0L;
            logger.error((Object)("YZJInvokeUtil getAccessToken message getAccessToken url==" + url + " \u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_EXCEPTION, YZJUrlContants.GET_ACCESSTOKEN_URL, null);
        }
        return accessTokenInfo;
    }

    private long getTimeStamp(String cloudtime) {
        long timestamp = -1L;
        if (!StringUtil.isEmpty(cloudtime)) {
            try {
                timestamp = Long.parseLong(cloudtime);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (timestamp == -1L) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    private class AccessTokenInfo {
        private String accessToken = null;
        private long accessTokenTime = 0L;
        private long expireTime = 0L;

        private AccessTokenInfo() {
        }
    }
}

