/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.pa.api.YZJInvokeUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJUrlContants;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TransferUserIdToXtIdUtil {
    private static final Logger logger = Logger.getLogger(TransferUserIdToXtIdUtil.class);
    private static int PAGESIZE = 900;

    public static List<String> transferWithList4Dingtalk(Context ctx, List<String> userIdList) {
        String tableName = "T_PM_EASDTUSERMAP";
        return TransferUserIdToXtIdUtil.transferWithList(ctx, tableName, userIdList);
    }

    public static List<String> transferWithList4Welink(Context ctx, List<String> userIdList) {
        String tableName = "T_PM_EASWLUSERMAP";
        return TransferUserIdToXtIdUtil.transferWithList(ctx, tableName, userIdList);
    }

    public static List<String> transferWithList4KccLight(Context ctx, String tableName, List<String> userIdList) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        if (userIdList != null) {
            int totalCount = userIdList.size();
            int totalPage = (totalCount - 1) / PAGESIZE + 1;
            for (int i = 0; i < totalPage; ++i) {
                String uid;
                IRowSet rs;
                int firstCount = i * PAGESIZE;
                int maxCount = (i + 1) * PAGESIZE;
                if (maxCount > totalCount) {
                    maxCount = totalCount;
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append("''");
                for (int j = firstCount; j < maxCount; ++j) {
                    if (!StringUtil.isNotEmpty(userIdList.get(j))) continue;
                    sb.append(",'").append(userIdList.get(j)).append("'");
                }
                if (sb.length() <= 5) continue;
                String sql = "SELECT FXTID,FCORPUSERID FROM " + tableName + " WHERE FUSERID IN (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        uid = StringUtil.isEmpty(rs.getString("FCORPUSERID")) ? rs.getString("FXTID") : rs.getString("FCORPUSERID");
                        xtIdList.add(uid);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("transferWithList4KccLight === excute sql error" + e.getMessage()));
                }
                if (xtIdList.size() != 0) continue;
                sql = "SELECT FXTID,FCORPUSERID FROM " + tableName + " WHERE FPERSONID IN (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        uid = StringUtil.isEmpty(rs.getString("FCORPUSERID")) ? rs.getString("FXTID") : rs.getString("FCORPUSERID");
                        xtIdList.add(uid);
                    }
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                    continue;
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                }
            }
        }
        return xtIdList;
    }

    private static List<String> transferWithList(Context ctx, String tableName, List<String> userIdList) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        if (userIdList != null) {
            int totalCount = userIdList.size();
            int totalPage = (totalCount - 1) / PAGESIZE + 1;
            for (int i = 0; i < totalPage; ++i) {
                IRowSet rs;
                int firstCount = i * PAGESIZE;
                int maxCount = (i + 1) * PAGESIZE;
                if (maxCount > totalCount) {
                    maxCount = totalCount;
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append("''");
                for (int j = firstCount; j < maxCount; ++j) {
                    if (!StringUtil.isNotEmpty(userIdList.get(j))) continue;
                    sb.append(",'").append(userIdList.get(j)).append("'");
                }
                if (sb.length() <= 5) continue;
                String sql = "select FXtId from " + tableName + " where FuserId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtil.isEmpty(rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                }
                if (xtIdList.size() != 0) continue;
                sql = "select FXtId from " + tableName + " where FPersonId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtil.isEmpty(rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                    continue;
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                }
            }
        }
        return xtIdList;
    }

    public static Map<String, String> transferWithMap4YZJ(Context ctx, List<String> userIdList) {
        String tableName = "T_PM_EASXTUSERMAP";
        return TransferUserIdToXtIdUtil.transferWithMap(ctx, tableName, userIdList);
    }

    private static Map<String, String> transferWithMap(Context ctx, String tableName, List<String> userIdList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (userIdList != null) {
            int totalCount = userIdList.size();
            int totalPage = (totalCount - 1) / PAGESIZE + 1;
            for (int i = 0; i < totalPage; ++i) {
                String openid;
                IRowSet rs;
                int firstCount = i * PAGESIZE;
                int maxCount = (i + 1) * PAGESIZE;
                if (maxCount > totalCount) {
                    maxCount = totalCount;
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append("''");
                for (int j = firstCount; j < maxCount; ++j) {
                    if (!StringUtil.isNotEmpty(userIdList.get(j))) continue;
                    sb.append(",'").append(userIdList.get(j)).append("'");
                }
                if (sb.length() <= 5) continue;
                String sql = "select FuserId, FXtId from " + tableName + " where FuserId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        openid = rs.getString("FXtId");
                        if (StringUtil.isEmpty(openid)) continue;
                        hashMap.put(rs.getString("FuserId"), openid);
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                }
                if (hashMap.keySet().size() >= userIdList.size()) continue;
                sql = "select FPersonId, FXtId from " + tableName + " where FPersonId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        openid = rs.getString("FXtId");
                        if (StringUtil.isEmpty(openid)) continue;
                        hashMap.put(rs.getString("FPersonId"), openid);
                    }
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                    continue;
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                }
            }
        }
        return hashMap;
    }

    public static String getOrgIdByXtId(Context ctx, String openid, String appid) {
        String yzjOrgId = null;
        String sql = "SELECT A.FXTORGID FROM T_PM_EASXTORGMAP A,T_ORG_BASEUNIT B,T_PM_USER C,T_PM_EASXTUSERMAP D  WHERE A.FEASORGID = B.FID AND  B.FID = C.FDEFORGUNITID AND C.FID = D.FUSERID AND D.FXTID = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{openid});
            while (rs.next()) {
                yzjOrgId = rs.getString("FXTORGID");
            }
        }
        catch (Exception e) {
            logger.error((Object)("transferUserIdToXtId ===getOrgIdByXtId error" + e.getMessage()));
        }
        if (StringUtil.isEmpty(yzjOrgId)) {
            String realeid = XTServiceConfig.getInstance().getXTInfoProperties().get("realEid");
            if (StringUtils.isEmpty((CharSequence)realeid)) {
                String ais = ctx.getAIS();
                realeid = XTServiceConfig.getInstance().getEidByDbCode(ais);
            }
            yzjOrgId = TransferUserIdToXtIdUtil.getYZJPersonOrgId(realeid, openid, appid);
            try {
                TransferUserIdToXtIdUtil.updateOrgInfo(ctx, openid, yzjOrgId);
            }
            catch (Exception e) {
                logger.error((Object)("transferUserIdToXtId ===updateOrgInfo error" + e.getMessage()));
            }
        }
        return yzjOrgId;
    }

    private static void updateOrgInfo(Context ctx, String openid, String yzjOrgId) throws BOSException, SQLException {
        String orgunitid = "";
        String sql = "SELECT B.FID FROM T_ORG_BASEUNIT B,T_PM_USER C,T_PM_EASXTUSERMAP D  WHERE B.FID = C.FDEFORGUNITID AND C.FID = D.FUSERID AND D.FXTID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{openid});
        while (rs.next()) {
            orgunitid = rs.getString("FID");
        }
        if (!StringUtil.isEmpty(orgunitid)) {
            sql = "SELECT 1 FROM T_PM_EASXTORGMAP WHERE FEASORGID = ? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgunitid});
            if (rs.next()) {
                sql = "UPDATE T_PM_EASXTORGMAP SET FXTORGID = ?  WHERE  FEASORGID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{yzjOrgId, orgunitid});
            } else {
                sql = "INSERT INTO T_PM_EASXTORGMAP (FID, FEASORGID, FXTORGID) VALUES(NEWBOSID('ABCD8899'),?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{orgunitid, yzjOrgId});
            }
        }
    }

    private static String getYZJPersonOrgId(String eid, String openid, String appid) {
        try {
            JSONObject personInfoObject;
            String accessToken = YZJInvokeUtil.getInstance().getAccessToken(appid, "");
            String url = YZJUrlContants.ORG_PERSON_URL + "?accessToken=" + accessToken + "&eid=" + eid + "&openId=" + openid;
            String personInfoJson = HttpClientUtil.doPost(url, "", "UTF-8");
            if (!StringUtils.isEmpty((CharSequence)personInfoJson) && (personInfoObject = JSON.parseObject((String)personInfoJson)).getBoolean("success").booleanValue()) {
                JSONArray jsonArray = personInfoObject.getJSONArray("data");
                JSONObject infoDataObject = jsonArray.getJSONObject(0);
                return infoDataObject.getString("orgId");
            }
        }
        catch (Exception e) {
            logger.error((Object)("transferUserIdToXtId ===getYZJPersonInfo error" + e.getMessage()));
        }
        return null;
    }
}

