/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.workflow.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.workflow.util.YZJMessageDeal;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class MessageStatusSyncJob
implements IJobHandler,
ICoreJobHandler {
    private static Logger logger = Logger.getLogger(MessageStatusSyncJob.class);
    private long delayTime;
    private String response;

    public static void init(Context ctx, ArrayList<String> paramList) {
        try {
            MessageStatusSyncJob messageStatusSyncJob = new MessageStatusSyncJob();
            messageStatusSyncJob.setDelayTime(2000L);
            JobInstanceConfig jobInstance = new JobInstanceConfig((IJobHandler)messageStatusSyncJob, false, false, 500);
            Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + messageStatusSyncJob.getDelayTime());
            String title = "\u4e91\u4e4b\u5bb6\u5f85\u529e\u8f6c\u5df2\u529e :" + paramList.get(0);
            Job job = new Job(ctx, title, jobInstance, paramList, scheduledTime);
            JobManager.instance().add(job);
        }
        catch (Throwable t) {
            logger.error((Object)("\u4e91\u4e4b\u5bb6\u5f85\u529e\u8f6c\u5df2\u529e :" + paramList.get(0) + " failed!"), t);
        }
    }

    public Object execute(Job job) throws Exception {
        Context ctx = job.getContext();
        ArrayList paramList = (ArrayList)job.getParameters();
        String assignId = (String)paramList.get(0);
        String userId = (String)paramList.get(1);
        String MsgId = "";
        int count = 1;
        logger.error((Object)("MessageStatusSyncJob assignId:" + assignId));
        try {
            MsgId = this.dealYZJMessage(userId, assignId, ctx, MsgId, count);
        }
        catch (Exception e2) {
            logger.error((Object)("xtmsg MsgId Deal  \u7b2c\u4e00\u6b21 error:" + assignId), (Throwable)e2);
            try {
                Thread.sleep(5000L);
                MsgId = this.dealYZJMessage(userId, assignId, ctx, MsgId, ++count);
            }
            catch (Exception e3) {
                logger.error((Object)("xtmsg MsgId Deal  \u7b2c\u4e8c\u6b21 error:" + assignId), (Throwable)e3);
                try {
                    Thread.sleep(10000L);
                    MsgId = this.dealYZJMessage(userId, assignId, ctx, MsgId, ++count);
                }
                catch (Exception e) {
                    logger.error((Object)("xtmsg MsgId Deal  \u4e09\u6b21 error:" + assignId), (Throwable)e);
                    YZJMessageDeal.insertError(MsgId, assignId, e.getMessage(), "SyncJobcount:" + count, ctx);
                    throw e;
                }
            }
        }
        return this.response;
    }

    private String dealYZJMessage(String userId, String assignId, Context ctx, String MsgId, int count) throws BOSException, SQLException, Exception {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        ArrayList<String> openids = new ArrayList<String>();
        String version = XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        String sql = "select A.msgid,b.fxtid,a.fuserid  from t_assign_xtmsg A,t_pm_easxtusermap B where A.fuserid=b.fuserid and  A.fassignid= '" + assignId + "' and a.fstate  is null ";
        IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (countRowSet.size() > 0) {
            while (countRowSet.next()) {
                Object columnObj = countRowSet.getObject("msgid");
                MsgId = columnObj.toString();
                Object columnObj1 = countRowSet.getObject("fxtid");
                String openId = columnObj1.toString();
                openids.add(openId);
            }
        } else {
            this.getOpernIds(userId, ctx, openids);
            MsgId = eid + "-" + assignId;
        }
        if (openids.size() == 0) {
            logger.error((Object)("-----------changge xtmsg assignId \u67e5\u8be2openids\u5931\u8d25 : " + assignId));
            this.response = "\u67e5\u8be2openids\u5931\u8d25\uff01";
            throw new Exception("\u67e5\u8be2openids\u5931\u8d25");
        }
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        HashMap<String, Object> dealMap = new HashMap<String, Object>();
        dealMap.put("sourcetype", appId);
        dealMap.put("sourceitemid", MsgId);
        HashMap<String, Integer> actionMap = new HashMap<String, Integer>();
        actionMap.put("deal", 1);
        actionMap.put("read", 1);
        dealMap.put("actiontype", actionMap);
        dealMap.put("openids", openids);
        logger.error((Object)("-----------changge xtmsg MsgId : " + MsgId));
        String url = YZJMessageDeal.getConnectServerURL(appId);
        this.response = HttpClientUtil.doPost(url, JSON.toJSONString(dealMap), "UTF-8");
        JSONObject map = new HashMap();
        map = JSON.parseObject((String)this.response);
        Object obj = map.get("success");
        String success = obj.toString();
        if (!"true".equals(success)) {
            YZJMessageDeal.insertError(MsgId, assignId, this.response, "SyncJobcount:" + count, ctx);
            throw new Exception(this.response);
        }
        String updatesql = "update t_assign_xtmsg  set fstate= '1' where  msgid= '" + MsgId + "'";
        DbUtil.execute((Context)ctx, (String)updatesql);
        logger.error((Object)("xtmsg MsgId  :" + MsgId + "-----------changge xtmsg result : " + this.response));
        return MsgId;
    }

    private void getOpernIds(String userId, Context ctx, List<String> openids) throws BOSException, SQLException {
        String sql = "select fxtid,fuserid  from t_pm_easxtusermap B where   fuserid=? ";
        IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
        ResultSetMetaData meta = countRowSet.getMetaData();
        while (countRowSet.next()) {
            String openId = countRowSet.getString("fxtid");
            openids.add(openId);
        }
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public long getDelayTime() {
        return this.delayTime;
    }
}

