/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.wx;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.wx.AccessTokenCache;
import com.kingdee.lightapp.xt.UserNotFoundException;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.lightapp.xt.util.LoginHelper;
import com.kingdee.util.ConfigurationItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXUtil {
    private static final Logger logger = LoggerFactory.getLogger(WXUtil.class);
    private static String[] wxConfigs = null;
    private static String wxhost = null;
    private static Object lock = new Object();
    private static HashMap openid2avatar = new HashMap();

    public static String getSendMessageUrl(String agentid) throws Exception {
        return WXUtil.getWXHost() + "/cgi-bin/message/send?access_token=" + AccessTokenCache.getAccessToken(agentid, "");
    }

    public static XtParamsDTO getXtParamsDTO(HttpSession session, String code, String state) throws Exception {
        long t1 = System.currentTimeMillis();
        String[] configs = WXUtil.getWXConfig();
        XtParamsDTO xtParamsDTO = new XtParamsDTO();
        xtParamsDTO.setEid(state);
        String openid = (String)session.getAttribute("openid");
        if (openid == null) {
            openid = WXUtil.getUserIDFromWX(ServletActionContext.getRequest(), session, configs, code);
        }
        xtParamsDTO.setOpenid(openid);
        xtParamsDTO.setWx(true);
        logger.info(" get openid from WX timout : " + (System.currentTimeMillis() - t1));
        return xtParamsDTO;
    }

    public static XtParamsDTO getXtParamsDTO(HttpServletRequest httpRequest, HttpSession session, String code, String state) throws Exception {
        long t1 = System.currentTimeMillis();
        String[] configs = WXUtil.getWXConfig();
        XtParamsDTO xtParamsDTO = new XtParamsDTO();
        xtParamsDTO.setEid(state);
        String openid = (String)session.getAttribute("openid");
        if (openid == null) {
            openid = WXUtil.getUserIDFromWX(httpRequest, session, configs, code);
        }
        xtParamsDTO.setOpenid(openid);
        xtParamsDTO.setWx(true);
        logger.info(" get openid from WX timout : " + (System.currentTimeMillis() - t1));
        return xtParamsDTO;
    }

    private static String getUserIDFromWX(HttpServletRequest httpRequest, HttpSession session, String[] configs, String code) throws Exception {
        String userId;
        block12: {
            userId = "";
            String agentid = httpRequest.getParameter("agentid");
            if (StringUtils.isEmpty((CharSequence)agentid)) {
                agentid = httpRequest.getParameter("appid");
            }
            if (StringUtils.isEmpty((CharSequence)agentid)) {
                agentid = configs[2];
            }
            System.out.println("code=" + code);
            String state = httpRequest.getParameter("state");
            String access_token = AccessTokenCache.getAccessToken(agentid, state);
            System.out.println("agentid=" + agentid);
            String getUserInfoUrl = WXUtil.getWXHost() + "/cgi-bin/user/getuserinfo";
            try {
                String url = getUserInfoUrl + "?access_token=" + URLEncoder.encode(access_token, "UTF-8") + "&code=" + URLEncoder.encode(code, "UTF-8") + "&agentid=" + URLEncoder.encode(agentid, "UTF-8");
                System.out.println("wxurl=" + url);
                String result = WXUtil.getResponse(url);
                System.out.println("result=" + result);
                JSONObject jb = new JSONObject(result);
                if (!jb.isNull("UserId")) {
                    userId = jb.getString("UserId");
                    session.setAttribute("openid", (Object)userId);
                    break block12;
                }
                if (!jb.isNull("errcode") && "42001".equals(jb.get("errcode"))) {
                    AccessTokenCache.refreshAccessToken(agentid);
                    userId = WXUtil.getUserIDFromWX(httpRequest, session, configs, code);
                    session.setAttribute("openid", (Object)userId);
                    break block12;
                }
                if (!jb.isNull("errcode") && "40029".equals(jb.get("errcode"))) {
                    throw new WorkflowException(WorkflowErrorEnums.CONNET_WXUSERINFOURL_HASERROR, getUserInfoUrl, null);
                }
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WXUSERINFOURL_FAILED, getUserInfoUrl, null);
            }
            catch (WorkflowException e) {
                throw e;
            }
            catch (UnsupportedEncodingException e) {
                throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_WXPARAMSENCODING, getUserInfoUrl, e.getMessage());
            }
            catch (HttpException e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WXUSERINFOURL_HTTPEXCEPTION, getUserInfoUrl, null);
            }
            catch (IOException e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WXUSERINFOURL_IOEXCEPTION, getUserInfoUrl, null);
            }
            catch (JSONException e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WXUSERINFOURL_JSONEXCEPTION, getUserInfoUrl, e.getMessage());
            }
            catch (Exception e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WXUSERINFOURL_FAILED, getUserInfoUrl, e.getMessage());
            }
        }
        System.out.println("userId=" + userId);
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getWXConfig() {
        if (wxConfigs != null) {
            return wxConfigs;
        }
        Object object = lock;
        synchronized (object) {
            if (wxConfigs != null) {
                return wxConfigs;
            }
            ConfigurationItem ci = XTServiceConfig.getInstance().getConfiguration().getConfigItem("WX");
            wxConfigs = new String[3];
            WXUtil.wxConfigs[0] = ci.getProperty("corpid", "");
            WXUtil.wxConfigs[1] = ci.getProperty("corpsecret", "");
            WXUtil.wxConfigs[2] = ci.getProperty("agentid", "");
        }
        return wxConfigs;
    }

    public static String getWXHost() {
        if (!StringUtils.isEmpty((CharSequence)wxhost)) {
            return wxhost;
        }
        wxhost = "https://qyapi.weixin.qq.com";
        try {
            ConfigurationItem ci = XTServiceConfig.getInstance().getConfiguration().getConfigItem("WX");
            String host = ci.getProperty("host", "");
            if (!StringUtils.isEmpty((CharSequence)host)) {
                wxhost = host;
            }
        }
        catch (Exception e) {
            logger.error("Error when getWXHost", (Throwable)e);
        }
        return wxhost;
    }

    public static Map doGetUserPic(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        String type = request.getParameter("type");
        String[] ids = request.getParameter("ids").split(",");
        Map idsMap = null;
        if ("openid".equalsIgnoreCase(type)) {
            idsMap = new HashMap();
            for (int i = 0; i < ids.length; ++i) {
                idsMap.put(ids[i], ids[i]);
            }
        } else if ("userid".equalsIgnoreCase(type)) {
            idsMap = WXUtil.getOpenIdByUserIds(session, ids);
        } else if ("procinstid".equalsIgnoreCase(type)) {
            idsMap = WXUtil.getOpenIdByProcInstIds(session, ids);
        }
        Map<String, String> retMap = new HashMap<String, String>();
        if (idsMap != null && idsMap.size() > 0) {
            retMap = WXUtil.getWxPic(idsMap, wxConfigs[2]);
        }
        retMap.put("picFromWX", "true");
        return retMap;
    }

    public static Map getWxPic(Map idsMap, String agentid) throws Exception {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String access_token = AccessTokenCache.getAccessToken(agentid, "");
        String tempUrl = WXUtil.getWXHost() + "/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID".replace("ACCESS_TOKEN", access_token);
        int i = 0;
        String url = null;
        Iterator iter = idsMap.entrySet().iterator();
        while (iter.hasNext()) {
            String avatar;
            url = tempUrl;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String openid = (String)entry.getValue();
            if (openid2avatar.containsKey(openid)) {
                avatar = (String)openid2avatar.get(openid);
                if (avatar != null) {
                    retMap.put(key, avatar);
                }
            } else {
                avatar = "";
                if (openid != null && openid.length() > 0) {
                    try {
                        url = url.replace("USERID", openid);
                        String result = WXUtil.getResponse(url);
                        JSONObject jb = new JSONObject(result);
                        if (!jb.isNull("avatar")) {
                            avatar = jb.getString("avatar");
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Error when getUserPic", t);
                    }
                }
                openid2avatar.put(openid, avatar);
                if (avatar != null) {
                    retMap.put(key, avatar);
                }
            }
            ++i;
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String saveAvatarToLocal(String path, String openid, String avatar) {
        OutputStream os = null;
        InputStream is = null;
        try {
            File outFile = new File(path + openid + ".jpeg");
            long da = outFile.lastModified();
            Date date = new Date(da);
            Date now = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            int day = c.get(5);
            c.set(5, day + 1);
            String dayBefore = new SimpleDateFormat("yyyy/MM/dd").format(c.getTime());
            Date date2 = new Date(dayBefore);
            boolean flag = date2.before(now);
            if (!outFile.exists() && flag) {
                URL url = new URL(avatar);
                os = new FileOutputStream(outFile);
                is = url.openStream();
                byte[] buff = new byte[1024];
                int length = 0;
                while ((length = is.read(buff)) > 0) {
                    os.write(buff, 0, length);
                }
            }
            String string = "/lightapp/avatar/" + openid + ".jpeg";
            return string;
        }
        catch (Exception e) {
            logger.error("saveAvatarToLocal", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                is = null;
                logger.error("saveAvatarToLocal1", (Throwable)e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                os = null;
                logger.error("saveAvatarToLocal2", (Throwable)e);
            }
        }
        return null;
    }

    private static Map getOpenIdByProcInstIds(HttpSession session, String[] ids) {
        String str = "";
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                str = str + ",";
            }
            str = str + "'" + ids[i] + "'";
        }
        String sql = " select A.fprocinstid ,B.fxtid from t_wfr_procinst A ,t_pm_easwxusermap B where   A. finitiatorid=B.fuserid and A.fprocinstid in (" + str + ")";
        Context ctx = (Context)session.getAttribute("XTContext");
        try {
            HashMap<String, String> idsMap = new HashMap<String, String>();
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (dataSet.next()) {
                String procinstid = dataSet.getString(1);
                String wxid = dataSet.getString(2);
                if (wxid == null || wxid.length() <= 0) continue;
                idsMap.put(procinstid, wxid);
            }
            return idsMap;
        }
        catch (Exception e) {
            logger.error("getOpenIdByProcInstIds error: ", (Throwable)e);
            return null;
        }
    }

    private static Map getOpenIdByUserIds(HttpSession session, String[] ids) {
        String str = "";
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                str = str + ",";
            }
            str = str + "'" + ids[i] + "'";
        }
        String sql = " select fuserid, fxtid from t_pm_easwxusermap  where   fuserid in (" + str + ")";
        Context ctx = (Context)session.getAttribute("XTContext");
        try {
            HashMap<String, String> idsMap = new HashMap<String, String>();
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (dataSet.next()) {
                String procinstid = dataSet.getString(1);
                String wxid = dataSet.getString(2);
                if (wxid == null || wxid.length() <= 0) continue;
                idsMap.put(procinstid, wxid);
            }
        }
        catch (Exception e) {
            logger.error("getOpenIdByUserIds error: ", (Throwable)e);
        }
        return null;
    }

    public static String getResponse(String url) throws Exception {
        return HttpClientUtil.doGet(url, "UTF-8");
    }

    public static Context doAutoBind(HttpServletRequest httpRequest, XtParamsDTO xtparamsDto, String code, String state) throws UserNotFoundException {
        HttpSession session = httpRequest.getSession();
        Context ctx = null;
        boolean isFromXT = true;
        if (session.getAttribute("isWX") != null && session.getAttribute("isWX").toString().equalsIgnoreCase("true")) {
            isFromXT = false;
        }
        try {
            String eid = (String)session.getAttribute("eid");
            if (StringUtils.isEmpty((CharSequence)eid)) {
                eid = (String)session.getAttribute("state");
            }
            System.out.println("-----------xtparamsDto.getOpenid()=" + xtparamsDto.getOpenid());
            UserInfo user = WXUtil.getEasUserUPhone(httpRequest, xtparamsDto, code, state);
            System.out.println("-----------user.getNumber()=" + user.getNumber());
            if (user == null || StringUtils.isEmpty((CharSequence)user.getNumber())) {
                System.out.println("-----------UserNotFoundException");
                throw new UserNotFoundException();
            }
            ctx = LoginHelper.loginEAS(user, xtparamsDto);
            session.setAttribute("XTContext", (Object)ctx);
            WXUtil.bind0(ctx, xtparamsDto.getOpenid(), isFromXT);
        }
        catch (UserNotFoundException e1) {
            throw new UserNotFoundException();
        }
        catch (Exception e) {
            logger.debug("WXUtil error:", (Throwable)e);
        }
        return ctx;
    }

    private static UserInfo getEasUserUPhone(HttpServletRequest httpRequest, XtParamsDTO xtparamsDto, String code, String state) throws Exception {
        String[] configs = WXUtil.getWXConfig();
        String ais = XTServiceConfig.getInstance().getDbCode(xtparamsDto.getEid());
        Context ctx = new Context(null, "eas", ais, new Locale("l2"));
        UserInfo user = new UserInfo();
        HttpSession session = httpRequest.getSession();
        String phone = "";
        String agentid = httpRequest.getParameter("agentid");
        if (StringUtils.isEmpty((CharSequence)agentid)) {
            agentid = configs[2];
        }
        String access_token = AccessTokenCache.getAccessToken(agentid, state);
        String url = WXUtil.getWXHost() + "/cgi-bin/user/get?access_token=" + URLEncoder.encode(access_token, "UTF-8") + "&userid=" + xtparamsDto.getOpenid();
        String result = WXUtil.getResponse(url);
        JSONObject jb = new JSONObject(result);
        if (!jb.isNull("mobile")) {
            phone = jb.getString("mobile");
            session.setAttribute("phone", (Object)phone);
            user = LoginHelper.getUserByPhone(ctx, phone);
        }
        return user;
    }

    public static Map doBind(HttpServletRequest httpRequest) {
        HttpSession session = httpRequest.getSession();
        String user = httpRequest.getParameter("user");
        String password = httpRequest.getParameter("password");
        HashMap<String, String> result = new HashMap<String, String>();
        String openid = (String)session.getAttribute("openid");
        String eid = (String)session.getAttribute("eid");
        boolean isFromXT = true;
        if (session.getAttribute("isWX") != null && session.getAttribute("isWX").toString().equalsIgnoreCase("true")) {
            isFromXT = false;
        }
        try {
            Context ctx = LoginHelper.loginEAS(eid, URLDecoder.decode(user), password, "");
            session.setAttribute("XTContext", (Object)ctx);
            WXUtil.bind0(ctx, openid, isFromXT);
            result.put("result", "ok");
        }
        catch (WorkflowException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("WXUtil error:", (Throwable)e);
            result.put("result", e.getMessage());
            result.put("error", "11");
        }
        return result;
    }

    private static void bind0(Context ctx, String openid, boolean isFromXT) throws SQLException {
        String userid = ctx.getCaller().toString();
        String tableName = " T_PM_EASWXUSERMAP ";
        String sql = null;
        if (isFromXT) {
            tableName = " T_PM_EASXTUSERMAP ";
        }
        sql = "SELECT B.FPERSONID FROM " + tableName + " A,T_PM_USER B WHERE (A.FPERSONID = B.FPERSONID OR A.FUSERID = B.FID ) AND B.FID = ? ";
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userid});
            if (dataSet.next()) {
                String fpersonid = dataSet.getString("FPERSONID");
                sql = "UPDATE " + tableName + " SET FXTID = ?,FPERSONID = ? WHERE FUserID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{openid, fpersonid, userid});
            } else {
                sql = "select fid,  fpersonid, fnumber, fname_l2 from t_pm_user where fid = ?";
                dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userid});
                String fpersonid = null;
                String fnumber = null;
                String fname = null;
                if (dataSet.next()) {
                    fpersonid = dataSet.getString(2);
                    fnumber = dataSet.getString(3);
                    fname = dataSet.getString(4);
                }
                sql = "insert into " + tableName + " (fid, fpersonid, fuserid, fxtid, fusernumber,fusername,fpersonname)  values(newbosid('ABCD8899'),?,?,?,?,?,'\u6d41\u7a0b\u52a9\u624b\u7ed1\u5b9a')";
                logger.debug("WXUtils sql :" + sql);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fpersonid, userid, openid, fnumber, fname});
            }
        }
        catch (Exception e) {
            logger.error("WXUtils error: ", (Throwable)e);
        }
    }

    public static String encodeWXGetCodeUrl(String url) {
        String[] config = WXUtil.getWXConfig();
        url = url + "&state=" + config[0];
        url = url.replaceAll("&appid=\\w*&", "&agentid=" + config[2] + "&");
        url = URLEncoder.encode(url);
        String ret = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=CORPID&redirect_uri=URL&response_type=code&scope=snsapi_base&state=CORPID#wechat_redirect".replaceAll("CORPID", config[0]);
        ret = ret.replace("URL", url);
        return ret;
    }
}

