/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.convert;

import com.kingdee.eas.mobile.convert.CompanyOrgUnitInfoConvert;
import com.kingdee.eas.mobile.convert.Convert;
import com.kingdee.eas.mobile.convert.NullConvert;
import com.kingdee.eas.mobile.convert.util.BooleanConvert;
import com.kingdee.eas.mobile.convert.util.CtrlUnitInfoConvert;
import com.kingdee.eas.mobile.convert.util.EnumConvert;
import com.kingdee.eas.mobile.convert.util.StringConvert;
import com.kingdee.eas.mobile.convert.util.UserInfoConvert;
import com.kingdee.eas.mobile.convert.util.UtilDataConvert;

public class ConvertFactory {
    private static final ConvertFactory instance = new ConvertFactory();
    private static final Convert[] converts = new Convert[]{new BooleanConvert(), new StringConvert(), new UtilDataConvert(), new CompanyOrgUnitInfoConvert(), new CtrlUnitInfoConvert(), new UserInfoConvert()};

    private ConvertFactory() {
    }

    public static ConvertFactory getInstance() {
        return instance;
    }

    public Convert createConvert(Object obj) {
        if (obj == null) {
            return new NullConvert();
        }
        return this.createConvert(obj.getClass());
    }

    public Convert createConvert(Class<?> clazz) {
        for (Convert convert : converts) {
            if (!convert.canProcess(clazz)) continue;
            return convert;
        }
        EnumConvert enumConvert = new EnumConvert(clazz);
        if (enumConvert.canProcess(clazz)) {
            return enumConvert;
        }
        return enumConvert;
    }
}

