/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg;

import com.kingdee.eas.mobile.msg.BizFunction;
import com.kingdee.eas.mobile.msg.BizModuleItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class BizModuleConfig
implements Serializable {
    public static final int EMAIL_MODE = 1;
    public static final int RTX_MODE = 2;
    public static final int MOBILE_MODE = 4;
    private String host;
    private int port;
    private int msgTypes;
    private ArrayList configedModules = new ArrayList();
    private HashMap fullInfoItems = new HashMap();

    public void addConfigurable(String className, BizFunction[] functions, String aliasName) {
        if (!this.fullInfoItems.containsKey(className)) {
            BizModuleItem wrap = new BizModuleItem(className, functions, aliasName);
            this.fullInfoItems.put(className, wrap);
        }
    }

    public void addConfigedModule(String command, String className, int key) {
        if (this.fullInfoItems.containsKey(className)) {
            BizModuleItem temp = (BizModuleItem)this.fullInfoItems.get(className);
            BizModuleItem wrap = new BizModuleItem(command, className, key);
            wrap.setBizFunctions(temp.getBizFunctions());
            wrap.setModuleName(temp.getModuleName());
            this.configedModules.add(wrap);
        }
    }

    public BizModuleItem getModule(String className) {
        return (BizModuleItem)this.fullInfoItems.get(className);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int i) {
        this.port = i;
    }

    public ArrayList getConfigedModules() {
        return this.configedModules;
    }

    public void setConfigedModules(ArrayList map) {
        this.configedModules = map;
    }

    public void addConfigurable(BizModuleItem wrap) {
        if (!this.fullInfoItems.containsKey(wrap.getClassName())) {
            this.fullInfoItems.put(wrap.getClassName(), wrap);
        }
        if (wrap.getCommand() != null && wrap.getCommand().trim().length() > 0) {
            this.addConfigedModule(wrap.getCommand(), wrap.getClassName(), wrap.getBizKey());
        }
    }

    public BizFunction[] getBizFunction(String className) {
        BizFunction[] functions = null;
        if (className == null) {
            return new BizFunction[0];
        }
        BizModuleItem fullInfo = (BizModuleItem)this.fullInfoItems.get(className);
        if (fullInfo != null) {
            functions = fullInfo.getBizFunctions();
        }
        if (functions == null) {
            functions = new BizFunction[]{};
        }
        return functions;
    }

    public BizFunction[] getBizFunction(BizModuleItem wrap) {
        if (wrap == null) {
            return new BizFunction[0];
        }
        return this.getBizFunction(wrap.getClassName());
    }

    public BizModuleItem[] getModules() {
        BizModuleItem[] items = null;
        Collection fullInfos = this.fullInfoItems.values();
        items = new BizModuleItem[fullInfos.size()];
        fullInfos.toArray(items);
        if (items == null) {
            items = new BizModuleItem[]{};
        }
        return items;
    }

    public void setFullItem(HashMap map) {
        this.fullInfoItems = map;
    }

    public int getMsgTypes() {
        return this.msgTypes;
    }

    public void setMsgTypes(int i) {
        this.msgTypes = i;
    }

    public boolean isEmailOK() {
        return this.isByMode(this.msgTypes, 1);
    }

    public boolean isRtxOK() {
        return this.isByMode(this.msgTypes, 2);
    }

    public boolean isMobileOK() {
        return this.isByMode(this.msgTypes, 4);
    }

    private boolean isByMode(int mode, int tagMode) {
        return (mode & tagMode) == tagMode;
    }
}

