/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.builder;

import com.kingdee.cbos.process.vm.builder.FlowBuilder;
import com.kingdee.cbos.process.vm.builder.VariableBuilder;
import com.kingdee.cbos.process.vm.internal.f.Features;
import com.kingdee.cbos.process.vm.internal.f.advanced.Break;
import com.kingdee.cbos.process.vm.internal.f.advanced.CallSubFlow;
import com.kingdee.cbos.process.vm.internal.f.advanced.CancelChildrenWhen;
import com.kingdee.cbos.process.vm.internal.f.advanced.CaptureMessage;
import com.kingdee.cbos.process.vm.internal.f.advanced.ChildrenIteration;
import com.kingdee.cbos.process.vm.internal.f.advanced.ChildrenMultiInstance;
import com.kingdee.cbos.process.vm.internal.f.advanced.ClearLocalVariables;
import com.kingdee.cbos.process.vm.internal.f.advanced.Continue;
import com.kingdee.cbos.process.vm.internal.f.advanced.DataSync;
import com.kingdee.cbos.process.vm.internal.f.advanced.DisableNode;
import com.kingdee.cbos.process.vm.internal.f.advanced.ExclusiveRoute;
import com.kingdee.cbos.process.vm.internal.f.advanced.MsgReceiver;
import com.kingdee.cbos.process.vm.internal.f.advanced.MsgSender;
import com.kingdee.cbos.process.vm.internal.f.advanced.MultiRoute;
import com.kingdee.cbos.process.vm.internal.f.advanced.NotWaitForChildrenWhen;
import com.kingdee.cbos.process.vm.internal.f.advanced.RepeatChildren;
import com.kingdee.cbos.process.vm.internal.f.advanced.ResetLocalVariables;
import com.kingdee.cbos.process.vm.internal.f.advanced.SetAsCallee;
import com.kingdee.cbos.process.vm.internal.f.advanced.SetAsCaller;
import com.kingdee.cbos.process.vm.internal.f.advanced.StopTransit;
import com.kingdee.cbos.process.vm.internal.f.advanced.Synchronization;
import com.kingdee.cbos.process.vm.internal.f.advanced.WhenDoChildren;
import com.kingdee.cbos.process.vm.internal.f.advanced.WhileDoChildren;
import com.kingdee.cbos.process.vm.internal.f.basic.AdHoc;
import com.kingdee.cbos.process.vm.internal.f.basic.AsNotStart;
import com.kingdee.cbos.process.vm.internal.f.basic.AsStart;
import com.kingdee.cbos.process.vm.internal.f.basic.DeferredChoice;
import com.kingdee.cbos.process.vm.internal.f.basic.ExclusiveChoice;
import com.kingdee.cbos.process.vm.internal.f.basic.Fork;
import com.kingdee.cbos.process.vm.internal.f.basic.HaltOnTaskStarted;
import com.kingdee.cbos.process.vm.internal.f.basic.Join;
import com.kingdee.cbos.process.vm.internal.f.basic.MultiChoice;
import com.kingdee.cbos.process.vm.internal.f.plugin.ApplicationInvoke;
import com.kingdee.cbos.process.vm.internal.f.plugin.TaskStart;
import com.kingdee.cbos.process.vm.internal.f.plugin.TwoPhaseCompletion;
import com.kingdee.cbos.process.vm.internal.f.tcf.Catch;
import com.kingdee.cbos.process.vm.internal.f.tcf.Finally;
import com.kingdee.cbos.process.vm.internal.f.tcf.Try;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.GroupImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.DataTypes;
import com.kingdee.cbos.process.vm.model.Event;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.Transition;
import com.kingdee.cbos.process.vm.plugin.Application;
import com.kingdee.cbos.process.vm.plugin.Condition;
import com.kingdee.cbos.process.vm.plugin.Listener;
import com.kingdee.cbos.process.vm.plugin.Result;
import com.kingdee.cbos.process.vm.plugin.SubFlowLoader;
import com.kingdee.cbos.process.vm.plugin.Task;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.utils.condition.InstanceOf;
import java.util.HashMap;
import java.util.Map;

public final class NodeBuilder {
    private FlowBuilder flowBuilder;
    private NodeBuilder parentBuilder;
    private NodeImpl node;

    NodeBuilder(FlowBuilder flowBuilder, String id, String title) {
        this.flowBuilder = flowBuilder;
        FlowImpl flow = flowBuilder.getFlow();
        this.node = new NodeImpl(flow, flow.getRoot(), id, title);
    }

    private NodeBuilder(NodeBuilder parentBuilder, String id, String title) {
        this.parentBuilder = parentBuilder;
        this.flowBuilder = parentBuilder.flowBuilder;
        FlowImpl flow = parentBuilder.flowBuilder.getFlow();
        this.node = new NodeImpl(flow, parentBuilder.node, id, title);
    }

    public FlowBuilder flowBuilder() {
        return this.flowBuilder;
    }

    public FlowBuilder endNode() {
        if (this.parentBuilder != null) {
            throw new RuntimeException("\u4e0d\u662f\u9876\u5c42\u8282\u70b9\uff0c\u8bf7\u8c03\u7528parent()\u8fd4\u56de\uff01");
        }
        this.node = null;
        FlowBuilder builder = this.flowBuilder;
        this.flowBuilder = null;
        return builder;
    }

    public FlowBuilder getFlowBuilder() {
        return this.flowBuilder;
    }

    public NodeBuilder endToParent() {
        if (this.parentBuilder == null) {
            throw new RuntimeException("\u9876\u5c42\u8282\u70b9\u6ca1\u6709\u7236\u8282\u70b9\u6784\u9020\u5668\uff01");
        }
        this.node = null;
        NodeBuilder builder = this.parentBuilder;
        this.parentBuilder = null;
        return builder;
    }

    public NodeBuilder getParent() {
        return this.parentBuilder;
    }

    public NodeBuilder child(String id, String title) {
        return new NodeBuilder(this, id, title);
    }

    public NodeBuilder transition(String id, String title, Transition.Type type, String sourceId, String targetId, Condition condition) {
        this.flowBuilder.transition(id, title, type, sourceId, targetId, condition);
        return this;
    }

    public NodeBuilder transition(String id, String title, String sourceId, String targetId, Condition condition) {
        this.flowBuilder.transition(id, title, sourceId, targetId, condition);
        return this;
    }

    public VariableBuilder<Node, NodeBuilder> variable(String id, String name, String title, DataType type, Object initValue) {
        return this.variable(id, name, title, type, initValue, false);
    }

    public VariableBuilder<Node, NodeBuilder> variable(String id, String name, String title, DataType type, Object initValue, boolean singleton) {
        VariableImpl var = this.node.addVariable(id, title, name, type, initValue, singleton);
        return new VariableBuilder<Node, NodeBuilder>(this, var);
    }

    public NodeBuilder listener(Event<Node> e, Listener<Execution<Node>> listener) {
        this.node.addListener(e, listener);
        return this;
    }

    public NodeBuilder biz(Application app) {
        this.node.addFeature(new ApplicationInvoke(app));
        return this;
    }

    public NodeBuilder biz(Task task) {
        this.node.addFeature(new TaskStart(task, null));
        return this;
    }

    public NodeBuilder twoPhaseCompletion(Task task) {
        this.node.addFeature(new TwoPhaseCompletion(task));
        return this;
    }

    public NodeBuilder biz(Task task, Result res) {
        this.node.addFeature(new TaskStart(task, res));
        return this;
    }

    public NodeBuilder joinScope(String scopeId) {
        GroupImpl scope = this.flowBuilder.getFlow().getScope(scopeId);
        this.node.join(scope, 0);
        return this;
    }

    public NodeBuilder childrenSplit(String masterVar, String[] returnVars, String ... paramVars) {
        ChildrenMultiInstance feature = new ChildrenMultiInstance(masterVar, paramVars, returnVars);
        this.node.addFeature(feature);
        return this;
    }

    public NodeBuilder forEach(String listVar) {
        ChildrenIteration feature = new ChildrenIteration(listVar);
        this.node.addFeature(feature);
        return this;
    }

    public NodeBuilder fork() {
        Fork feature = Fork.INS;
        this.node.addFeature(feature);
        return this;
    }

    public NodeBuilder join(Node.Stage stage) {
        return this.join(stage, false);
    }

    public NodeBuilder join(Node.Stage stage, boolean omitReenter) {
        Join feature = new Join(stage, omitReenter);
        this.node.addFeature(feature);
        return this;
    }

    public NodeBuilder synchronization(Node.Stage stage) {
        Synchronization feature = new Synchronization(stage);
        this.node.addFeature(feature);
        return this;
    }

    public NodeBuilder synchronization() {
        return this.synchronization(Node.Stage.BEFORE_READY);
    }

    public NodeBuilder join() {
        return this.join(Node.Stage.BEFORE_READY);
    }

    public NodeBuilder clearVarBeforeEnd(String ... vars) {
        this.node.addFeature(new ClearLocalVariables(vars, NIS.CLEAR_VARIABLES_ON_COMPLETED.getLabel()));
        return this;
    }

    public NodeBuilder resetVarBeforeEnd(String ... vars) {
        this.node.addFeature(new ResetLocalVariables(vars, NIS.RESET_VARIABLES_ON_COMPLETED.getLabel()));
        return this;
    }

    public NodeBuilder resetVariablesWhenReady(String ... vars) {
        this.node.addFeature(new ResetLocalVariables(vars, NIS.RESET_VARIABLES_WHEN_READY.getLabel()));
        return this;
    }

    public NodeBuilder clearVariablesWhenReady(String ... vars) {
        this.node.addFeature(new ClearLocalVariables(vars, NIS.CLEAR_VARIABLES_WHEN_READY.getLabel()));
        return this;
    }

    public NodeBuilder stopTransit(Condition when) {
        this.node.addFeature(new StopTransit(when));
        return this;
    }

    public NodeBuilder disable(Condition when, String ... targets) {
        this.node.addFeature(new DisableNode(when, targets));
        return this;
    }

    public NodeBuilder multiRoute() {
        this.node.addFeature(new MultiRoute());
        return this;
    }

    public NodeBuilder exclusiveRoute() {
        this.node.addFeature(new ExclusiveRoute());
        return this;
    }

    public NodeBuilder deferredChoice() {
        this.node.addFeature(new DeferredChoice());
        return this;
    }

    public NodeBuilder adHoc() {
        return this.adHoc(Node.Stage.BEFORE_READY);
    }

    public NodeBuilder adHoc(Node.Stage stage) {
        this.node.addFeature(new AdHoc(stage));
        return this;
    }

    public NodeBuilder multiChoice() {
        this.node.addFeature(new MultiChoice());
        return this;
    }

    public NodeBuilder exclusiveChoice() {
        this.node.addFeature(new ExclusiveChoice());
        return this;
    }

    public NodeBuilder haltOnStarted() {
        this.node.addFeature(new HaltOnTaskStarted());
        return this;
    }

    public NodeBuilder asStart() {
        this.node.addFeature(AsStart.INS);
        return this;
    }

    public NodeBuilder asNotStart() {
        this.node.addFeature(AsNotStart.INS);
        return this;
    }

    public NodeBuilder asEnd() {
        this.node.setAsEnd();
        return this;
    }

    public NodeBuilder function(String[] paramVars, String ... returnVars) {
        this.node.addFeature(new SetAsCallee(paramVars, returnVars));
        return this;
    }

    public NodeBuilder call(String funcNodeId, String[] paramVars, String ... returnVars) {
        this.node.addFeature(new SetAsCaller(funcNodeId, paramVars, returnVars));
        return this;
    }

    public NodeBuilder call(SubFlowLoader subFlow, String[] paramVars, String ... returnVars) {
        this.node.addFeature(new CallSubFlow(subFlow, paramVars, returnVars));
        return this;
    }

    public NodeBuilder dataSync(Node.Stage stage, Condition condition, String ... vars) {
        this.node.addFeature(new DataSync(vars, condition, stage));
        return this;
    }

    public NodeBuilder cancelChildren(Condition when, String ... vars) {
        if (vars.length == 0) {
            throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u76d1\u542c\u7684\u6d41\u7a0b\u53d8\u91cf\u3002");
        }
        this.node.addFeature(new CancelChildrenWhen(vars, when));
        return this;
    }

    public NodeBuilder notWaitForChildren(Condition when, String ... vars) {
        if (vars.length == 0) {
            throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u76d1\u542c\u7684\u6d41\u7a0b\u53d8\u91cf\u3002");
        }
        this.node.addFeature(new NotWaitForChildrenWhen(vars, when));
        return this;
    }

    public NodeBuilder entryExclusive() {
        this.node.addFeature(Features.ENTRY_EXCLUSIVE);
        return this;
    }

    public NodeBuilder exitExclusive() {
        this.node.addFeature(Features.EXIT_EXCLUSIVE);
        return this;
    }

    public NodeBuilder childrenExclusive() {
        this.node.addFeature(Features.CHILDREN_EXCLUSIVE);
        return this;
    }

    public NodeBuilder receive(String msgVar, boolean isSync, Node.Stage stage, String ... assignedVars) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put(msgVar, assignedVars);
        return this.receive(map, isSync, stage);
    }

    public NodeBuilder receive(Map<String, String[]> receivers, boolean isSync, Node.Stage stage) {
        this.node.addFeature(new MsgReceiver(receivers, isSync, stage));
        return this;
    }

    public NodeBuilder send(String msgVar, Node.Stage stage, String ... contentVars) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put(msgVar, contentVars);
        return this.send(map, stage);
    }

    public NodeBuilder send(Map<String, String[]> senders, Node.Stage stage) {
        this.node.addFeature(new MsgSender(senders, stage));
        return this;
    }

    public NodeBuilder capture(String msgVar, String ... contentVars) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put(msgVar, contentVars);
        return this.capture(map, true);
    }

    public NodeBuilder capture(Map<String, String[]> messages, boolean requireAll) {
        this.node.addFeature(new CaptureMessage(messages, requireAll));
        return this;
    }

    public NodeBuilder deferredDispatch() {
        this.node.addFeature(Features.DEFERRED_DISPATCH);
        return this;
    }

    public NodeBuilder repeatChildrenWhen(Condition condition) {
        this.node.addFeature(new RepeatChildren(condition));
        return this;
    }

    public NodeBuilder whileDoChildren(Condition condition) {
        this.node.addFeature(new WhileDoChildren(condition));
        return this;
    }

    public NodeBuilder whenDoChildren(Condition condition) {
        this.node.addFeature(new WhenDoChildren(condition));
        return this;
    }

    public NodeBuilder asCatch(Condition condition) {
        this.node.addFeature(new Catch(condition));
        return this;
    }

    public NodeBuilder asCatch(Class<? extends Exception> error) {
        InstanceOf condition = new InstanceOf(DataTypes.ERROR.getName(), error);
        this.node.addFeature(new Catch(condition));
        return this;
    }

    public NodeBuilder asCatch() {
        this.node.addFeature(new Catch(null));
        return this;
    }

    public NodeBuilder asTry() {
        this.node.addFeature(new Try());
        return this;
    }

    public NodeBuilder asFinally() {
        this.node.addFeature(new Finally());
        return this;
    }

    public NodeBuilder breakWhen(Condition condition) {
        this.node.addFeature(new Break(condition));
        return this;
    }

    public NodeBuilder continueWhen(Condition condition) {
        this.node.addFeature(new Continue(condition));
        return this;
    }

    public void setAttribute(String name, Object value) {
        this.node.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.node.getAttribute(name);
    }

    public String getNodeId() {
        return this.node.getId();
    }

    public String getNodeTitle() {
        return this.node.getTitle();
    }
}

