/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.m.GroupImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.Output;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;

public class ChildrenMultiInstance
extends Feature {
    public static final String NAME = "children-multi-instance";
    private VariableImpl<?> masterVar;
    private VariableImpl<?> masterShadow;
    private VariableImpl<?>[] returnVars;
    private VariableImpl<?>[] returnShadows;
    private VariableImpl<?>[] paramVars;
    private String masterVarName;
    private String[] returnVarNames;
    private String[] paramVarNames;

    public ChildrenMultiInstance(String masterVar, String[] paramVars, String[] returnVars) {
        this.masterVarName = masterVar;
        this.returnVarNames = returnVars == null ? new String[]{} : returnVars;
        this.paramVarNames = paramVars == null ? new String[]{} : paramVars;
    }

    public VariableImpl<?> getMasterShadow() {
        return this.masterShadow;
    }

    public String[] getParamVarNames() {
        return this.paramVarNames;
    }

    public VariableImpl<?>[] getParamVars() {
        return (VariableImpl[])this.paramVars.clone();
    }

    public VariableImpl<?> getMasterVar() {
        return this.masterVar;
    }

    public VariableImpl<?>[] getReturnVars() {
        return (VariableImpl[])this.returnVars.clone();
    }

    public VariableImpl<?>[] getReturnShadows() {
        return (VariableImpl[])this.returnShadows.clone();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getCategories() {
        return new String[]{"data-area-creation"};
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public void preHandle(NodeImpl node) {
    }

    private void checkAndSetVariables(NodeImpl node) {
        int i;
        this.masterVar = node.retrieveVariable(this.masterVarName);
        if (!this.masterVar.getType().acceptMultiValue()) {
            throw new RuntimeException("(" + node + ")\u8303\u56f4\u5185\u7684\u53d8\u91cf(" + this.masterVar + ")\u662f\u539f\u5b50\u503c\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u4e3b\u53d8\u91cf\uff01");
        }
        this.returnVars = new VariableImpl[this.returnVarNames.length];
        for (i = 0; i < this.returnVars.length; ++i) {
            this.returnVars[i] = node.retrieveVariable(this.returnVarNames[i]);
            if (!this.returnVars[i].isSingleton()) continue;
            throw new RuntimeException(this.returnVars[i] + "\u662f\u5355\u4f8b\u53d8\u91cf\uff0c\u4e0d\u80fd\u4f5c\u4e3a(" + node + ")\u8fd4\u56de\u503c\uff01");
        }
        this.paramVars = new VariableImpl[this.paramVarNames.length];
        for (i = 0; i < this.paramVars.length; ++i) {
            this.paramVars[i] = node.retrieveVariable(this.paramVarNames[i]);
            if (!this.paramVars[i].isSingleton()) continue;
            throw new RuntimeException(this.paramVars[i] + "\u662f\u5355\u4f8b\u53d8\u91cf\uff0c\u4e0d\u80fd\u4f5c\u4e3a(" + node + ")\u53c2\u6570\uff01");
        }
    }

    private GroupImpl createScopeAndSetWR(NodeImpl node) {
        GroupImpl scope = new GroupImpl(node.getFlow(), "sg-" + node.getId(), "children-split:" + node);
        this.masterShadow = scope.addVariable("sv-" + node.getId(), this.masterVar.getTitle(), this.masterVar.getName(), this.masterVar.getType().getElementType(), null, false);
        this.returnShadows = new VariableImpl[this.returnVars.length];
        for (int i = 0; i < this.returnVars.length; ++i) {
            this.returnShadows[i] = this.returnVars[i] == this.masterVar ? this.masterShadow : this.returnVars[i];
        }
        Output output = new Output(this.returnShadows, this.returnVars);
        node.setOutput(output);
        return scope;
    }

    @Override
    public void postHandle(NodeImpl node) {
        if (node.getChildrenCount() == 0) {
            return;
        }
        this.checkAndSetVariables(node);
        GroupImpl scope = this.createScopeAndSetWR(node);
        for (NodeImpl child : node.getChildren()) {
            child.join(scope, 0);
        }
        node.insert(NIS.CREATE_DATA_AREA_4_MULTI_INSTANCE);
    }
}

