/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.node.Lock;
import com.kingdee.cbos.process.vm.internal.i.node.UnLock;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.model.DataTypes;

public final class CriticalSection {
    public static void createCriticalSection(FlowImpl flow, String sectId, String[] nodeIds, boolean global) {
        CriticalSection.checkId(flow, sectId);
        NodeImpl[] nodes = CriticalSection.checkNodes(flow, nodeIds);
        VariableImpl lock = flow.addVariable(sectId, sectId, sectId, DataTypes.BOOLEAN, false, global);
        VariableImpl waiting = lock.addVariable(sectId + "$", "W", "W", DataTypes.SET(DataTypes.STRING), null, global);
        Lock il = new Lock(lock, waiting, NIS.LOCK.getLabel());
        UnLock iu = new UnLock(lock, waiting, NIS.UNLOCK.getLabel());
        for (NodeImpl node : nodes) {
            node.insert(il);
            node.insert(iu);
        }
    }

    private static NodeImpl[] checkNodes(FlowImpl flow, String[] nodeIds) {
        NodeImpl[] nodes = new NodeImpl[nodeIds.length];
        for (int i = 0; i < nodes.length; ++i) {
            int addr;
            NodeImpl node = flow.getNode(nodeIds[i]);
            Instruction lock = node.getInstruction(addr = node.seekInstruction(NIS.LOCK.getLabel()));
            if (lock instanceof Lock) {
                throw new RuntimeException("\u8282\u70b9(" + node + ")\u5df2\u7ecf\u52a0\u5165\u4e34\u754c\u6bb5(" + ((Lock)lock).getBoolVar().getName() + ")!");
            }
            nodes[i] = node;
        }
        return nodes;
    }

    private static void checkId(FlowImpl flow, String sectId) {
        if (flow.getVariable(sectId) != null) {
            throw new RuntimeException("\u4e34\u754c\u6bb5\u6807\u8bc6(" + sectId + ")\u5df2\u88ab\u6d41\u7a0b\u53d8\u91cf\u540d\u79f0\u5360\u7528\u3002");
        }
        if (flow.getElement(sectId) != null || flow.getElement(sectId + "$") != null) {
            throw new RuntimeException("\u4e34\u754c\u6bb5\u6807\u8bc6(" + sectId + ")\u5df2\u88ab\u6d41\u7a0b\u5143\u7d20\u6807\u8bc6\u5360\u7528\u3002");
        }
    }
}

