/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.i.node.Utils;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.HashSet;

public final class DeferredChoice
extends AbstractInstruction {
    private static String TRANSITION = "T";
    private static String NODE = "N";
    private static String EXECUTION = "E";
    private static String MODE = "DC_MODE";
    private static String TARGETS = "DC_TARGET";

    public DeferredChoice(int index) {
        super(index);
    }

    public static void setDeferredChoice(ExecutionImpl<NodeImpl> e, TransitionImpl ... next) {
        e.setProperty(MODE, TRANSITION);
        NodeImpl node = (NodeImpl)e.getDefine();
        HashSet<String> targets = new HashSet<String>(next.length);
        for (TransitionImpl t : next) {
            if (node != t.getSource()) {
                throw new RuntimeException("(" + t + ")\u4e0d\u662f\u8282\u70b9(" + node + ")\u7684\u51fa\u53e3\u8f6c\u79fb\uff01");
            }
            targets.add(t.getId());
        }
        e.setProperty(TARGETS, targets);
    }

    public static void setDeferredChoice(ExecutionImpl<NodeImpl> e, NodeImpl ... next) {
        e.setProperty(MODE, NODE);
        NodeImpl p = ((NodeImpl)e.getDefine()).getParent();
        HashSet<String> targets = new HashSet<String>(next.length << 1);
        for (NodeImpl s : next) {
            if (s.getParent() != p) {
                throw new RuntimeException("(" + s + ")\u4e0e(" + e + ")\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u7236\u8282\u70b9\uff01");
            }
            targets.add(s.getId());
        }
        e.setProperty(TARGETS, targets);
    }

    public static void setDeferredChoice(ExecutionImpl<NodeImpl> e, ExecutionImpl<NodeImpl> ... next) {
        e.setProperty(MODE, EXECUTION);
        HashSet<String> targets = new HashSet<String>(next.length);
        for (ExecutionImpl<NodeImpl> s : next) {
            targets.add(s.getId());
            s.setPrior(e, null);
        }
        e.setProperty(TARGETS, targets);
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) {
        String key = ((NodeImpl)e.getDefine()).getId() + "#RETURN_TARGET";
        String targetActDefId = (String)e.getContext().getProperty(key);
        if (targetActDefId != null && targetActDefId.length() > 0) {
            e.getContext().setProperty(key, "");
            Utils.transit(e, e.getContext().getFlow().getNode(targetActDefId));
            return this.getLabel() + 2;
        }
        HashSet targets = (HashSet)e.getProperty(TARGETS);
        if (targets == null) {
            return 1;
        }
        String mode = (String)e.getProperty(MODE);
        FlowImpl flow = e.getContext().getFlow();
        if (TRANSITION.equals(mode)) {
            for (String id : targets) {
                TransitionImpl t = (TransitionImpl)flow.getTransition(id);
                Utils.transit(e, t);
            }
        } else if (NODE.equals(mode)) {
            for (String id : targets) {
                Utils.transit(e, flow.getNode(id));
            }
        } else if (EXECUTION.equals(mode)) {
            FlowContextImpl ctx = e.getContext();
            for (String id : targets) {
                Execution next = ctx.getExecution(id);
                if (next == null) {
                    throw new RuntimeException("Execution not found. id=" + id);
                }
                ctx.push((ExecutionImpl<?>)next);
            }
        } else {
            throw new RuntimeException("\u975e\u6cd5\u6a21\u5f0f(" + mode + ")\u3002");
        }
        return this.getLabel() + 2;
    }

    public String toString() {
        return "deferred-choice";
    }
}

