/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.i.node.Utils;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.plugin.Condition;
import com.kingdee.cbos.process.vm.plugin.Identifier;
import com.kingdee.cbos.process.vm.plugin.LiteralCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class FastRouteM
extends AbstractInstruction {
    private NodeImpl node;
    private Map<Object, List<TransitionImpl>> routeTab;
    private HashSet<Identifier> identifiers;
    private List<TransitionImpl> defaultTrans;
    private List<TransitionImpl> nomalTrans;

    public FastRouteM(NodeImpl node, int index) {
        super(index);
        this.node = node;
        if (node != null) {
            this.generateRouteTable();
        }
    }

    private void generateRouteTable() {
        this.routeTab = new HashMap<Object, List<TransitionImpl>>();
        this.defaultTrans = new ArrayList<TransitionImpl>();
        this.nomalTrans = new ArrayList<TransitionImpl>();
        this.identifiers = new HashSet();
        for (TransitionImpl exit : this.node.getNormalExits()) {
            Condition c = exit.getCondition();
            if (c == null) {
                this.defaultTrans.add(exit);
                continue;
            }
            if (c instanceof LiteralCondition) {
                Object[] domain;
                LiteralCondition lc = (LiteralCondition)c;
                Identifier identifier = lc.getIdentifier();
                this.identifiers.add(identifier);
                for (Object id : domain = lc.getDomain()) {
                    List<TransitionImpl> list = this.routeTab.get(id);
                    if (list == null) {
                        list = new ArrayList<TransitionImpl>();
                        this.routeTab.put(id, list);
                    }
                    list.add(exit);
                }
                continue;
            }
            this.nomalTrans.add(exit);
        }
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) throws Exception {
        Collection<TransitionImpl> selected = new HashSet<TransitionImpl>();
        for (Identifier identifier : this.identifiers) {
            for (Object id : identifier.getIds(e)) {
                List<TransitionImpl> list = this.routeTab.get(id);
                if (list == null) continue;
                selected.addAll(list);
            }
        }
        if (this.nomalTrans.size() > 0) {
            for (TransitionImpl t : this.nomalTrans) {
                if (!t.getCondition().test(e)) continue;
                selected.add(t);
            }
        }
        if (selected.size() == 0) {
            if (this.defaultTrans.size() == 0) {
                throw new RuntimeException("{" + e + "}\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8f6c\u79fb\uff01");
            }
            selected = this.defaultTrans;
        }
        Utils.transit(e, selected);
        return 1;
    }

    public String toString() {
        return "fast-route-m";
    }
}

