/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.plugin.Condition;
import java.util.ArrayList;

public final class HaltWhenNotSatisfied
extends AbstractInstruction {
    private ArrayList<Condition> conditions = new ArrayList(1);

    public HaltWhenNotSatisfied(Condition condition, int index) {
        super(index);
        this.conditions.add(condition);
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) throws Exception {
        for (Condition c : this.conditions) {
            if (c.test(e)) continue;
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "halt-when-not-satisfied[" + this.conditions.size() + "]";
    }

    public static void insert(NodeImpl node, Condition condition, Node.Stage stage) {
        int label;
        switch (stage) {
            case BEFORE_CHILDREN_STARTED: {
                label = NIS.HALT_BEFORE_CHILDREN_STARTED_WHEN.getLabel();
                break;
            }
            case BEFORE_CLOSED: {
                label = NIS.HALT_BEFORE_COMPLETED_WHEN.getLabel();
                break;
            }
            case BEFORE_READY: {
                label = NIS.HALT_BEFORE_READY_WHEN.getLabel();
                break;
            }
            case BEFORE_TRANSFERRING: {
                label = NIS.HALT_BEFORE_TRANSFERRING_WHEN.getLabel();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int addr = node.seekInstruction(label);
        Instruction original = node.getInstruction(addr);
        if (original.getLabel() == label) {
            ((HaltWhenNotSatisfied)original).conditions.add(condition);
        } else {
            node.insert(new HaltWhenNotSatisfied(condition, label));
        }
    }
}

