/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;

public final class NodesGroupExclusive
extends AbstractInstruction {
    private ArrayList<LinkedHashSet<NodeImpl>> groups;

    public NodesGroupExclusive(LinkedHashSet<NodeImpl> group, int index) {
        super(index);
        if (group == null) {
            return;
        }
        this.groups = new ArrayList(1);
        this.groups.add(group);
    }

    public void merge(LinkedHashSet<NodeImpl> group) {
        this.groups.add(group);
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) throws Exception {
        if ("true".equals(e.getProperty("$append$"))) {
            return 1;
        }
        for (HashSet hashSet : this.groups) {
            this.excludeOthers(e, hashSet);
        }
        return 1;
    }

    private void excludeOthers(ExecutionImpl<NodeImpl> e, HashSet<NodeImpl> group) {
        ExecutionImpl[] siblings;
        Execution<NodeImpl> ref = e;
        while (!group.contains(((ExecutionImpl)ref).getDefine())) {
            ref = ((ExecutionImpl)ref).getParent();
        }
        DataAreaImpl da = ((ExecutionImpl)ref).getDataArea();
        for (ExecutionImpl sibling : siblings = ((ExecutionImpl)((ExecutionImpl)ref).getParent()).getChildren().toArray(new ExecutionImpl[0])) {
            if (sibling == ref || sibling.getDataArea() != da || !group.contains(sibling.getDefine())) continue;
            sibling.terminate();
        }
    }

    public String toString() {
        return "group-exclusive" + this.groups;
    }

    public static void insert(NodeImpl src, LinkedHashSet<NodeImpl> group) {
        if (src.isTwoPhase()) {
            NodesGroupExclusive.handleInstruction(src, group, NIS.NODES_EXCLUSIVE_CONTROL_FOR_TWO_PHASE);
            NodesGroupExclusive.handleInstruction(src, group, NIS.NODES_EXCLUSIVE_CONTROL_BEFORE_TRANSFERRING);
        } else if (src.isTask()) {
            NodesGroupExclusive.handleInstruction(src, group, NIS.NODES_EXCLUSIVE_CONTROL_FOR_TASK);
            NodesGroupExclusive.handleInstruction(src, group, NIS.NODES_EXCLUSIVE_CONTROL_BEFORE_TRANSFERRING);
        } else {
            NodesGroupExclusive.handleInstruction(src, group, NIS.NODES_EXCLUSIVE_CONTROL_BEFORE_TRANSFERRING);
        }
        NodesGroupExclusive.handleInstruction(src, group, NIS.NODES_EXCLUSIVE_CONTROL_ON_ERROR_DELIVERED);
        if (src.getChildrenCount() > 0) {
            for (NodeImpl child : src.getChildren()) {
                NodesGroupExclusive.insert(child, group);
            }
        }
    }

    private static void handleInstruction(NodeImpl src, LinkedHashSet<NodeImpl> group, Instruction<NodeImpl> i) {
        int index = i.getLabel();
        int addr = src.seekInstruction(index);
        Instruction original = src.getInstruction(addr);
        if (original.getLabel() == index) {
            ((NodesGroupExclusive)original).merge(group);
        } else {
            src.insert(new NodesGroupExclusive(group, index));
        }
    }
}

