/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.var;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.VIS;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import java.util.ArrayList;

public class SignalWhenDataChanged
implements Instruction<VariableImpl<?>> {
    private int index;
    private ArrayList<String> nodeIds = new ArrayList(1);

    public SignalWhenDataChanged(String nodeId, int index) {
        this.index = index;
        this.nodeIds.add(nodeId);
    }

    @Override
    public int invoke(ExecutionImpl<VariableImpl<?>> e) {
        FlowContextImpl ctx = e.getContext();
        DataAreaImpl da = e.getDataArea();
        for (String nodeId : this.nodeIds) {
            for (ExecutionImpl<?> ex : ctx.getExecutions(nodeId)) {
                if (ex.getDataArea() != da) continue;
                ctx.push(ex);
            }
        }
        return 1;
    }

    @Override
    public int getLabel() {
        return this.index;
    }

    public String toString() {
        return "signal-when-data-changed" + this.nodeIds;
    }

    public static void insert(VariableImpl<?> v, NodeImpl node) {
        int label = VIS.SIGNAL_WHEN_DATA_CHANGED.getLabel();
        int addr = v.seekInstruction(label);
        if (addr == -1) {
            v.insert(new SignalWhenDataChanged(node.getId(), label));
            return;
        }
        Instruction original = v.getInstruction(addr);
        if (original.getLabel() == label) {
            ((SignalWhenDataChanged)original).nodeIds.add(node.getId());
        } else {
            v.insert(new SignalWhenDataChanged(node.getId(), label));
        }
    }
}

