/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.m;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.wrapper.FlowListenerWrapper;
import com.kingdee.cbos.process.vm.internal.i.wrapper.InvokeFlowListener;
import com.kingdee.cbos.process.vm.internal.i.wrapper.ListenerWrapper;
import com.kingdee.cbos.process.vm.internal.m.GroupImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.Priority;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableScopeImpl;
import com.kingdee.cbos.process.vm.internal.m.a.Graph;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.internal.r.mode.ModeImpl;
import com.kingdee.cbos.process.vm.model.Event;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.Group;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.ProcessElement;
import com.kingdee.cbos.process.vm.model.Transition;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Listener;
import com.kingdee.cbos.process.vm.plugin.Synchronizer;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.w3c.dom.Document;

public final class FlowImpl
extends VariableScopeImpl<FlowImpl>
implements Flow,
VariableScope {
    private Map<String, ProcessElement> elements = new HashMap<String, ProcessElement>();
    private Map<String, NodeImpl> nodes = new LinkedHashMap<String, NodeImpl>();
    private Map<String, TransitionImpl> transitions = new LinkedHashMap<String, TransitionImpl>();
    private List<VariableImpl<FlowImpl>> input = new ArrayList<VariableImpl<FlowImpl>>();
    private List<VariableImpl<FlowImpl>> output = new ArrayList<VariableImpl<FlowImpl>>();
    private NodeImpl root;
    private List<VariableImpl<?>> variable_addresses = new ArrayList();
    private Map<String, GroupImpl> groups = new HashMap<String, GroupImpl>();
    private Map<Listener<?>, Integer> listener2index = new HashMap();
    private Map<Listener<?>, VariableScope> listeners2host = new HashMap();
    private boolean readOnly = false;
    private Synchronizer synchronizer;
    private boolean subFlow = false;
    private Flow.Mode mode;
    private List<Feature> lazyFeatures = new ArrayList<Feature>();
    private List<NodeImpl> lazyNode = new ArrayList<NodeImpl>();
    private String crc;

    public FlowImpl(Synchronizer synchronizer, Flow.Mode mode, String id, String title, boolean subFlow) {
        super(id, title, Priority.STACK);
        this.mode = mode;
        this.synchronizer = synchronizer;
        this.subFlow = subFlow;
        this.root = new NodeImpl(this, null, "$", "$");
    }

    @Override
    public NodeImpl getRoot() {
        return this.root;
    }

    @Override
    public Graph getGraph() {
        return this.root.getGraph();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isSubFlow() {
        return this.subFlow;
    }

    @Override
    public ProcessElement getElement(String id) {
        return this.elements.get(id);
    }

    public int variableCount() {
        return this.variable_addresses.size();
    }

    @Override
    public NodeImpl getNode(String id) {
        return this.nodes.get(id);
    }

    public VariableImpl<?> getVariable(int address) {
        return this.variable_addresses.get(address);
    }

    @Override
    public Map<String, ? extends Node> getNodes() {
        return this.nodes;
    }

    @Override
    public GroupImpl getScope(String id) {
        return this.groups.get(id);
    }

    @Override
    public Map<String, ? extends Group> getScopes() {
        return this.groups;
    }

    public List<VariableImpl<FlowImpl>> getOutputVariables() {
        return this.output;
    }

    @Override
    public Flow.Mode getMode() {
        return this.mode;
    }

    public List<VariableImpl<FlowImpl>> getInputVariables() {
        return this.input;
    }

    void register(ProcessElement element) {
        String key = element.getId();
        ProcessElement original = this.elements.get(key);
        if (original == null) {
            this.elements.put(key, element);
            if (element instanceof NodeImpl) {
                this.nodes.put(key, (NodeImpl)element);
            } else if (element instanceof GroupImpl) {
                this.groups.put(key, (GroupImpl)element);
            } else if (element instanceof VariableImpl) {
                this.variable_addresses.add((VariableImpl)element);
            } else if (element instanceof TransitionImpl) {
                this.transitions.put(key, (TransitionImpl)element);
            }
        } else if (original != element && this.elements.containsKey(key)) {
            throw new RuntimeException("\u6807\u8bc6\u4e3a{" + key + "}\u7684\u5143\u7d20\u5df2\u5b58\u5728\uff01");
        }
    }

    public void registerListener(Listener<?> l) {
        this.registerListener(l, null);
    }

    void registerListener(Listener<?> l, VariableScope scope) {
        if (!this.listener2index.containsKey(l)) {
            this.listener2index.put(l, this.listener2index.size());
            if (scope != null) {
                this.listeners2host.put(l, scope);
            }
        }
    }

    public int getListenerIndex(Listener<?> l) {
        return this.listener2index.get(l);
    }

    public void addInput(String var) {
        Variable variable = this.getVariable(var);
        if (variable == null) {
            throw new RuntimeException("\u6d41\u7a0b\u53d8\u91cf\u4e0d\u5b58\u5728\uff01");
        }
        if (this.input.contains(variable)) {
            throw new RuntimeException("\u6d41\u7a0b\u53d8\u91cf(" + var + ")\u5df2\u52a0\u5165\u4e3a\u8f93\u5165\u53d8\u91cf\uff01");
        }
        this.input.add((VariableImpl<FlowImpl>)variable);
    }

    public void addOutput(String var) {
        Variable variable = this.getVariable(var);
        if (variable == null) {
            throw new RuntimeException("\u6d41\u7a0b\u53d8\u91cf\u4e0d\u5b58\u5728\uff01");
        }
        if (this.output.contains(variable)) {
            throw new RuntimeException("\u6d41\u7a0b\u53d8\u91cf(" + var + ")\u5df2\u52a0\u5165\u4e3a\u8f93\u51fa\u53d8\u91cf\uff01");
        }
        this.output.add((VariableImpl<FlowImpl>)variable);
    }

    public void addLazyFeature(Feature f, NodeImpl node) {
        this.lazyFeatures.add(f);
        this.lazyNode.add(node);
    }

    public void solidify() {
        super.solidifyVariables();
        this.input = Collections.unmodifiableList(this.input);
        this.output = Collections.unmodifiableList(this.output);
        this.root.solidify();
        this.prepare4Synchcronizer();
        this.lazyBind();
        for (GroupImpl groupImpl : this.groups.values()) {
            groupImpl.solidify();
        }
        for (TransitionImpl transitionImpl : this.transitions.values()) {
            transitionImpl.solidify();
        }
        for (Map.Entry entry : this.listeners2host.entrySet()) {
            ((Listener)entry.getKey()).compile((VariableScope)entry.getValue());
        }
        super.solidifyListeners();
        this.groups = Collections.unmodifiableMap(this.groups);
        this.nodes = Collections.unmodifiableMap(this.nodes);
        this.insertInstructions();
        ModeImpl.getModeImpl(this).validate(this);
        this.readOnly = true;
        this.generateCRC();
    }

    private void lazyBind() {
        for (int i = 0; i < this.lazyFeatures.size(); ++i) {
            this.lazyFeatures.get(i).postHandle(this.lazyNode.get(i));
        }
        this.lazyFeatures = null;
        this.lazyNode = null;
    }

    private void prepare4Synchcronizer() {
        if (this.synchronizer == null) {
            return;
        }
        for (NodeImpl node : this.nodes.values()) {
            if (node.getParent() == null) continue;
            node.insert(NIS.INSTANCE_CREATE);
            node.insert(NIS.INSTANCE_COMPLETE);
            if (node.contains(NIS.ERROR_DELIVER)) {
                node.insert(NIS.TEMINATE_ON_ERROR_DELIVERED);
            }
            node.insert(NIS.INSTANCE_FAILED);
            node.insert(NIS.INSTANCE_RETRY);
            node.insert(NIS.INSTANCE_SUSPEND);
            node.insert(NIS.INSTANCE_RESUME);
            node.insert(NIS.INSTANCE_TEMINATE);
        }
    }

    @Override
    public Transition getTransition(String id) {
        return this.transitions.get(id);
    }

    private void insertInstructions() {
        if (this.subFlow) {
            for (NodeImpl nodeImpl : this.nodes.values()) {
                if (!nodeImpl.isStart() || nodeImpl.isComposite() || !nodeImpl.getParent().isStart()) continue;
                nodeImpl.insert(NIS.SUB_FLOW_PARTIAL_COMPLETED);
            }
        }
        this.root.insert(NIS.END_FLOW);
        for (ListenerWrapper listenerWrapper : this.getListeners()) {
            this.root.insert(new InvokeFlowListener(listenerWrapper));
        }
    }

    @Override
    Map<String, VariableImpl<? extends VariableScope>> getOtherAvailableVariables() {
        return this.getVariables();
    }

    public void addListener(Event<Flow> e, Listener<Execution<Flow>> listener) {
        this.registerListener(listener, this);
        Listener<Execution<Flow>> l = listener;
        this.addListener(new FlowListenerWrapper(e, (Listener<ExecutionImpl<FlowImpl>>)l, this));
    }

    @Override
    public FlowContext newInstance() {
        if (this.isSubFlow()) {
            throw new RuntimeException("\u5b50\u6d41\u7a0b\u4e0d\u652f\u6301\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b\u3002");
        }
        return new FlowContextImpl(this);
    }

    @Override
    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @Override
    public String dumpMicroPrograms() {
        StringBuilder sb = new StringBuilder();
        sb.append("variables\uff1a");
        for (VariableImpl<?> v : this.variable_addresses) {
            v.dumpMicroProgram(sb);
        }
        sb.append("\r\n\r\n").append("nodes\uff1a");
        this.root.dumpMicroProgram(sb, 0);
        return sb.toString();
    }

    @Override
    public String dumpDiagram() {
        StringBuilder sb = new StringBuilder();
        this.root.dumpDiagram(sb);
        return sb.toString();
    }

    private void generateCRC() {
        CRC32 crc = new CRC32();
        for (VariableImpl<?> v : this.variable_addresses) {
            v.updateCRC(crc);
            String s = v.getName();
            for (int j = 0; j < s.length(); ++j) {
                crc.update(s.charAt(j));
            }
        }
        for (NodeImpl n : this.nodes.values()) {
            n.updateCRC(crc);
        }
        this.crc = Long.toHexString(crc.getValue());
    }

    @Override
    public String getCrc() {
        return this.crc;
    }

    @Override
    public FlowContext fromXml(Document document) {
        return FlowContextImpl.fromXml(this, document);
    }

    @Override
    public boolean isBefore(String nodeA, String nodeB) {
        NodeImpl a = this.getNode(nodeA);
        NodeImpl b = this.getNode(nodeB);
        if (a.getParent() != b.getParent()) {
            throw new IllegalArgumentException("\u8282\u70b9(" + a + ")\u4e0e(" + b + ")\u4e0d\u5c5e\u4e8e\u540c\u4e00\u8282\u70b9\u5757!");
        }
        Graph g = a.getParent().getGraph();
        return g.reach(nodeA, nodeB);
    }
}

