/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.m;

import com.kingdee.cbos.process.vm.internal.m.AbstractElement;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.r.DataAreaImpl;
import com.kingdee.cbos.process.vm.model.Transition;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.plugin.Condition;
import java.util.Map;

public class TransitionImpl
extends AbstractElement
implements Transition {
    private Transition.Type type;
    private NodeImpl source;
    private NodeImpl target;
    private Condition condition;
    private Map<String, String> assigns;
    private VariableImpl<?>[] from;
    private VariableImpl<?>[] to;
    private boolean backward;

    public TransitionImpl(String id, String title, Transition.Type type, NodeImpl source, NodeImpl target, Condition condition, Map<String, String> assigns) {
        super(source.getFlow(), id, title);
        if (source.isCompensation()) {
            throw new RuntimeException("\u4e0d\u80fd\u4e3a\u8865\u507f\u8282\u70b9\u5efa\u7acb\u51fa\u53e3\u8f6c\u79fb\uff01");
        }
        if (source.getParent() != target.getParent()) {
            throw new RuntimeException("\u6e90\u8282\u70b9\u4e0e\u76ee\u6807\u8282\u70b9\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5757\u3002");
        }
        this.type = type;
        this.source = source;
        this.target = target;
        this.condition = condition;
        source.addOutGoing(this);
        target.addInComing(this);
        this.assigns = assigns;
    }

    @Override
    public Transition.Type getType() {
        return this.type;
    }

    @Override
    public NodeImpl getSource() {
        return this.source;
    }

    @Override
    public NodeImpl getTarget() {
        return this.target;
    }

    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward() {
        this.backward = true;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    void solidify() {
        if (this.condition != null) {
            this.condition.compile(this.source);
        }
        if (this.assigns == null || this.assigns.size() == 0) {
            return;
        }
        int i = 0;
        this.from = new VariableImpl[this.assigns.size()];
        this.to = new VariableImpl[this.assigns.size()];
        for (Map.Entry<String, String> assign : this.assigns.entrySet()) {
            Variable to = this.target.retrieveVariable(assign.getValue());
            Variable from = this.source.retrieveVariable(assign.getKey());
            this.from[i] = from;
            this.to[i] = to;
            ++i;
        }
        this.assigns = null;
    }

    public void assign(DataAreaImpl dataArea) {
        if (this.from == null) {
            return;
        }
        int j = this.from.length;
        for (int i = 0; i < j; ++i) {
            Object v = dataArea.getAt(this.from[i]);
            dataArea.setAt(this.to[i], v);
        }
    }
}

