/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XmlUtil {
    public static Document parse(String xml) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String toString(Document document) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(document), new StreamResult(bos));
            return bos.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5c06xml\u6587\u6863\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u5931\u8d25\uff01", e);
        }
    }

    public static Element getChild(Element parent, String tagName) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            String name;
            if (!(nodes.item(i) instanceof Element) || !(name = (e = (Element)nodes.item(i)).getTagName()).endsWith(tagName)) continue;
            if (name.length() == tagName.length()) {
                return e;
            }
            int j = name.length() - tagName.length() - 1;
            if (j <= 0 || name.charAt(j) != ':') continue;
            return e;
        }
        return null;
    }

    public static Collection<Element> getChildren(Element parent, String tagName) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            if (!(nodes.item(i) instanceof Element) || !(e = (Element)nodes.item(i)).getNodeName().equals(tagName)) continue;
            children.add(e);
        }
        return children;
    }
}

