/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.cache;

import com.kingdee.cbos.process.vm.utils.cache.CacheListener;
import com.kingdee.cbos.process.vm.utils.cache.EmptyListener;
import com.kingdee.cbos.process.vm.utils.cache.MCastListener;
import com.kingdee.cbos.process.vm.utils.cache.RPCBroadcastListener;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import org.apache.log4j.Logger;

public class CacheListenerFactory {
    private static Logger log = Logger.getLogger(CacheListenerFactory.class);
    private static CacheListener instance = CacheListenerFactory.create();
    private static String policy;
    private static final String MULTICAST = "multicast";
    private static final String RPC = "rpc";
    private static final String NONE = "none";

    public static CacheListener getCacheListener() {
        return instance;
    }

    public static void refresh() {
        instance = CacheListenerFactory.create();
    }

    private static void readConfig() {
        try {
            ConfigurationItem item = Configuration.getInstance().getConfigItem("Workflow");
            policy = item.getProperty("DistributeCachePolicy");
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
        if (policy == null) {
            policy = MULTICAST;
        }
    }

    private static CacheListener create() {
        CacheListenerFactory.readConfig();
        if (NONE.equalsIgnoreCase(policy)) {
            return new EmptyListener();
        }
        if (MULTICAST.equalsIgnoreCase(policy)) {
            try {
                return new MCastListener();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                log.error((Object)"error when create MCastListener", (Throwable)e);
                log.warn((Object)"CacheListener will use RPCBroadcast instead.");
            }
        }
        return new RPCBroadcastListener();
    }
}

