/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.cache;

import com.kingdee.cbos.process.vm.utils.cache.Cache;
import com.kingdee.cbos.process.vm.utils.cache.CacheListenerFactory;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GroupCache<V>
implements Cache<String, V> {
    Cache<String, V> local;
    private String namespace;
    private static Map<String, GroupCache<?>> caches = new ConcurrentHashMap();

    public GroupCache(String namespace, Cache<String, V> local) {
        this.check(namespace, local);
        this.local = local;
        this.namespace = namespace;
        caches.put(namespace, this);
    }

    private void check(String namespace, Cache<String, V> local) {
        if (local instanceof GroupCache) {
            throw new IllegalArgumentException();
        }
        if (caches.containsKey(namespace)) {
            this.getOutput().println("WARN::\u547d\u540d\u7a7a\u95f4\u4e3a{" + namespace + "}\u7684\u7f13\u5b58\u5df2\u7ecf\u6ce8\u518c\uff01");
        }
    }

    public Cache getLocal() {
        return this.local;
    }

    private PrintStream getOutput() {
        return System.out;
    }

    @Override
    public V get(String key) {
        return this.local.get(key);
    }

    @Override
    public V put(String key, V value) {
        return this.local.put(key, value);
    }

    @Override
    public V remove(String key) {
        V v = this.local.remove(key);
        CacheListenerFactory.getCacheListener().remove(this.namespace, key);
        return v;
    }

    @Override
    public void clear() {
        this.local.clear();
        CacheListenerFactory.getCacheListener().clear(this.namespace);
    }

    @Override
    public int size() {
        return this.local.size();
    }

    public static GroupCache<?> getCache(String namespace) {
        return caches.get(namespace);
    }

    @Override
    public boolean exists(String key) {
        return this.local.exists(key);
    }
}

