/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.cache;

import com.kingdee.cbos.process.vm.utils.cache.Cache;
import com.kingdee.cbos.process.vm.utils.cache.LocalCache;
import java.util.HashSet;

public final class SmartCache<K, V>
implements Cache<K, V> {
    private Cache<K, V> cache;
    private Loader<K, V> loader;
    private HashSet<K> loading = new HashSet();

    public SmartCache(Class<?> initiatorClass, int capacity, int timeout, Loader<K, V> loader) {
        this(initiatorClass.getName(), capacity, timeout, loader);
    }

    public SmartCache(Cache<K, V> cache, Loader<K, V> loader) {
        this.cache = cache;
        this.loader = loader;
    }

    public SmartCache(String name, int capacity, int timeout, Loader<K, V> loader) {
        this.cache = new LocalCache(name, capacity, timeout);
        this.loader = loader;
    }

    public SmartCache(Class<?> initiatorClass, int capacity, Loader<K, V> loader) {
        this(initiatorClass, capacity, 0, loader);
    }

    public synchronized boolean isLoading(K id) {
        String key = id.toString();
        return this.loading.contains(key);
    }

    @Override
    public V get(K id) {
        V obj = this.cache.get(id);
        if (obj != null) {
            return obj;
        }
        return this.load(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V load(K id) {
        try {
            this.lock(id);
            V obj = this.cache.get(id);
            if (obj == null) {
                obj = this.loader.load(id);
                obj = this.put2cache(id, obj);
            }
            V v = obj;
            return v;
        }
        finally {
            this.release(id);
        }
    }

    private synchronized V put2cache(K id, V obj) {
        V old = this.cache.get(id);
        if (old == null) {
            this.cache.put(id, obj);
        } else {
            obj = old;
        }
        return obj;
    }

    private synchronized void release(K id) {
        this.loading.remove(id);
        this.notifyAll();
    }

    private synchronized void lock(K id) {
        if (this.loading.contains(id)) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.loading.add(id);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public V remove(K key) {
        return this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public boolean exists(K key) {
        return this.cache.exists(key);
    }

    public static interface Loader<K, T> {
        public T load(K var1);
    }
}

