/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.condition;

import com.kingdee.cbos.process.vm.internal.Consts;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Identifier;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.utils.condition.Utils;
import java.lang.reflect.Method;

public final class XPathIdentifier
implements Identifier {
    private String var;
    private String methodName;
    private Variable<?> v;
    private Method method;
    private String xpath;

    public XPathIdentifier(String var, String methodName, String xpath) {
        if (var == null || methodName == null) {
            throw new NullPointerException();
        }
        this.var = var;
        this.methodName = methodName;
        this.xpath = xpath;
    }

    public String[] getIds(Execution<?> e) {
        Object o = e.get(this.v);
        if (o == null) {
            return Consts.EMPTY_STR_ARRAY;
        }
        try {
            return Utils.toStringArray(this.method.invoke(o, this.xpath));
        }
        catch (Exception e1) {
            throw new RuntimeException("\u4f7f\u7528\u53c2\u6570(" + this.xpath + ")\u8bbf\u95ee\u53d8\u91cf(" + this.var + ")\u503c(" + o + ")\u7684\u65b9\u6cd5(" + this.methodName + ")\u5931\u8d25");
        }
    }

    @Override
    public void compile(VariableScope scope) {
        Variable<? extends VariableScope> v = scope.retrieveVariable(this.var);
        if (v == this.v) {
            return;
        }
        if (this.v != null) {
            throw new RuntimeException("\u53d8\u91cf\u51b2\u7a81\uff0c\u5e94\u7528\u672c\u6807\u8bc6\u7684\u5404\u53d8\u91cf\u8303\u56f4\u6709\u4e0d\u540c\u7684(" + this.var + ")\u53d8\u91cf\uff0e");
        }
        this.v = v;
        Class<?> type = v.getType().getValueClass();
        try {
            this.method = type.getMethod(this.methodName, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("\u53d8\u91cf(" + this.var + ")\u6ca1\u6709\u65b9\u6cd5(" + this.methodName + ")\u3002");
        }
        if (this.method.getReturnType() == Void.TYPE) {
            throw new RuntimeException("\u53d8\u91cf(" + this.var + ")\u7684\u65b9\u6cd5(" + this.methodName + ")\u6ca1\u6709\u8fd4\u56de\u503c\u3002");
        }
    }

    public int hashCode() {
        return this.var.hashCode() ^ this.methodName.hashCode() ^ this.xpath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != XPathIdentifier.class) {
            return false;
        }
        XPathIdentifier i = (XPathIdentifier)obj;
        return i.var.equals(this.var) && i.methodName.equals(this.methodName) && i.xpath.equals(this.xpath);
    }

    public String toString() {
        return this.var + "#" + this.methodName;
    }
}

