/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.group;

import com.kingdee.cbos.process.vm.utils.Ref;
import com.kingdee.cbos.process.vm.utils.group.Member;
import com.kingdee.cbos.process.vm.utils.group.MessageServer;
import com.kingdee.cbos.process.vm.utils.group.MessageService;
import java.net.SocketAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MessageGroup {
    public static final Ref<Integer> MAX_SIZE = new Ref<Integer>(1000);
    public static final Ref<Integer> TIMEOUT = new Ref<Integer>(5);
    private static final String COMMAND = "GROUP_NOTIFY";
    private static String name = UUID.randomUUID().toString();
    private static final Map<String, Member> members = new ConcurrentHashMap<String, Member>();

    public static String getName() {
        return name;
    }

    public static synchronized void beat() {
        MessageServer.send(COMMAND, name);
        for (Member m : MessageGroup.getMembers()) {
            if (m.check() != 0) continue;
            members.remove(m.getName());
        }
    }

    public static synchronized Member[] getMembers() {
        int size = members.size();
        return members.values().toArray(new Member[size]);
    }

    private static synchronized Member addMember(String serverId) {
        if (members.size() >= MAX_SIZE.get()) {
            return null;
        }
        Member member = new Member(serverId);
        members.put(serverId, member);
        return member;
    }

    static {
        MessageServer.register(COMMAND, new MessageService(){

            @Override
            public void handle(SocketAddress host, String serverId, String msgId, String group) {
                Member member;
                if (name.compareTo(group) < 0) {
                    name = group;
                }
                if ((member = this.getMember(serverId)) == null) {
                    return;
                }
                member.refresh();
            }

            private Member getMember(String serverId) {
                Member member = (Member)members.get(serverId);
                if (member == null) {
                    member = MessageGroup.addMember(serverId);
                }
                return member;
            }
        });
    }
}

