/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.extension.manager;

import com.kingdee.bos.qing.common.extension.manager.IExtensionClassProvider;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaInfoExtensionClassProvider<T>
implements IExtensionClassProvider {
    private static final String EXTENSION_DIR = "META-INF/qing-extension/";
    private Class<T> interfaceClass;

    public MetaInfoExtensionClassProvider(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    @Override
    public Map<String, List<Class<? extends T>>> loadExtensionClass() {
        HashMap<String, List<Class<? extends T>>> extensionClasses = new HashMap<String, List<Class<? extends T>>>();
        String filePath = EXTENSION_DIR + this.interfaceClass.getName();
        try {
            ClassLoader classLoader = this.getClassLoader(this.interfaceClass);
            Enumeration<URL> urls = classLoader.getResources(filePath);
            if (null != urls) {
                while (urls.hasMoreElements()) {
                    URL extensionUrl = urls.nextElement();
                    this.loadExtensionResources(extensionUrl, this.interfaceClass, extensionClasses);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error("load extension from meta inf failed", e);
        }
        return extensionClasses;
    }

    @Override
    public Class<T> getExtensionType() {
        return this.interfaceClass;
    }

    private ClassLoader getClassLoader(Class<?> interfaceClass) {
        ClassLoader cl = interfaceClass.getClassLoader();
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensionResources(URL extensionUrl, Class<T> interfaceClass, Map<String, List<Class<? extends T>>> extClassMap) {
        BufferedReader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            String line;
            inputStreamReader = new InputStreamReader(extensionUrl.openStream());
            reader = new BufferedReader(inputStreamReader);
            while ((line = reader.readLine()) != null) {
                int index;
                if (line.length() <= 0 || (index = line.indexOf(61)) <= 0) continue;
                String extensionName = line.substring(0, index).trim();
                String className = line.substring(index + 1).trim();
                try {
                    Class<?> extClass = Class.forName(className);
                    if (!interfaceClass.isAssignableFrom(extClass)) continue;
                    List<Class<T>> implClasses = extClassMap.get(extensionName);
                    if (null == implClasses) {
                        implClasses = new ArrayList<Class<? extends T>>();
                        extClassMap.put(extensionName, implClasses);
                    }
                    if (implClasses.contains(extClass)) continue;
                    implClasses.add(extClass);
                }
                catch (ClassNotFoundException e) {
                    LogUtil.error("className:" + className, e);
                }
            }
        }
        catch (Exception e) {
            try {
                LogUtil.error("", e);
            }
            catch (Throwable throwable) {
                this.close(inputStreamReader, reader);
                throw throwable;
            }
            this.close(inputStreamReader, reader);
        }
        this.close(inputStreamReader, reader);
    }

    private void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (null == closeable) continue;
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

