/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.extension.manager;

import com.kingdee.bos.qing.common.extension.manager.IExtensionFilter;
import com.kingdee.bos.qing.common.extension.manager.QingExtensionConfig;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QingExtensionLoader<T> {
    private QingExtensionConfig extensionConfig;
    private Map<String, List<Class<? extends T>>> subExtensionClassMaps;
    private static Map<Class<?>, QingExtensionLoader> EXTENSION_LOADERS = new ConcurrentHashMap();

    public static <T> QingExtensionLoader<T> getExtensionLoader(QingExtensionConfig extensionConfig) {
        QingExtensionLoader<T> loaderInMap;
        Class<?> classType = extensionConfig.getExtensionClass();
        QingExtensionLoader<T> loader = EXTENSION_LOADERS.get(classType);
        if (null == loader && (loaderInMap = EXTENSION_LOADERS.putIfAbsent(classType, loader = new QingExtensionLoader<T>(extensionConfig))) != null) {
            loader = loaderInMap;
        }
        return loader;
    }

    private QingExtensionLoader(QingExtensionConfig extensionConfig) {
        this.extensionConfig = extensionConfig;
    }

    public List<T> getExtensions(String[] names) {
        ArrayList<T> extensions = new ArrayList<T>();
        for (String extensionName : names) {
            List<T> allExtensions = this.getAllExtensions(extensionName);
            if (null == allExtensions) continue;
            extensions.addAll(allExtensions);
        }
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFilteredExtension(String name) {
        if (this.extensionConfig.getExtensionFilter() == null) {
            return null;
        }
        QingExtensionLoader qingExtensionLoader = this;
        synchronized (qingExtensionLoader) {
            if (null == this.subExtensionClassMaps) {
                this.subExtensionClassMaps = this.extensionConfig.getClassProvider().loadExtensionClass();
            }
        }
        List<Class<T>> extensionClasses = this.subExtensionClassMaps.get(name);
        if (null == extensionClasses) {
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug("no extension class impl found for extension name:" + name);
            }
            return null;
        }
        IExtensionFilter extensionFilter = this.extensionConfig.getExtensionFilter();
        for (Class<T> implClass : extensionClasses) {
            if (!extensionFilter.filterExtensionClass(implClass)) continue;
            try {
                T extension = implClass.newInstance();
                return extension;
            }
            catch (Exception e) {
                LogUtil.error("create extension class instance error,classImpl name:" + implClass.getName(), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAllExtensions(String name) {
        QingExtensionLoader qingExtensionLoader = this;
        synchronized (qingExtensionLoader) {
            if (null == this.subExtensionClassMaps) {
                this.subExtensionClassMaps = this.extensionConfig.getClassProvider().loadExtensionClass();
            }
        }
        return this.createExtensionInstance(name);
    }

    private List<T> createExtensionInstance(String name) {
        List<Class<T>> extensionClasses = this.subExtensionClassMaps.get(name);
        if (null == extensionClasses) {
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug("no extension class impl found for extension name:" + name);
            }
            return null;
        }
        ArrayList<T> extensions = new ArrayList<T>(extensionClasses.size());
        for (Class<T> implClass : extensionClasses) {
            try {
                T extension = implClass.newInstance();
                extensions.add(extension);
            }
            catch (Exception e) {
                LogUtil.error("create class instance error,className:" + implClass.getName(), e);
            }
        }
        return extensions;
    }
}

