/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.model.server;

import com.kingdee.bos.qing.common.framework.model.AbstractMessage;
import com.kingdee.bos.qing.common.framework.model.server.ServerChannelMessage;
import com.kingdee.bos.qing.common.framework.model.server.ServerRemoteCallMessage;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractServerMessage
extends AbstractMessage {
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();
    private static Map<String, Class<? extends AbstractServerMessage>> serverMessageClassMap = new HashMap<String, Class<? extends AbstractServerMessage>>();

    public static AbstractServerMessage decodeFromJsonString(String jsonString) {
        return JsonUtil.decodeFromString(customJsonParser, jsonString, AbstractServerMessage.class);
    }

    static {
        customJsonParser.addCustomDecoder(AbstractServerMessage.class, new ServerMessageJsonDecoder());
        customJsonParser.addCustomDecoder(AbstractResponseWrap.class, new ResponseWrapJsonDecoder());
        serverMessageClassMap.put("ServerRemoteCall", ServerRemoteCallMessage.class);
        serverMessageClassMap.put("ServerChannel", ServerChannelMessage.class);
    }

    static class ResponseWrapJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractResponseWrap> {
        ResponseWrapJsonDecoder() {
        }

        @Override
        protected AbstractResponseWrap decode(JsonUtil.AbstractJsonDecoder.Json json) {
            if (json.hasAttr("errorCode")) {
                return (AbstractResponseWrap)this.fromJson(json, ResponseErrorWrap.class);
            }
            return (AbstractResponseWrap)this.fromJson(json, ResponseSuccessWrap.class);
        }
    }

    static class ServerMessageJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractServerMessage> {
        ServerMessageJsonDecoder() {
        }

        @Override
        protected AbstractServerMessage decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String messageType = json.getAttrValue("messageType");
            Class clientMessageClass = (Class)serverMessageClassMap.get(messageType);
            if (clientMessageClass != null) {
                return (AbstractServerMessage)this.fromJson(json, clientMessageClass);
            }
            return null;
        }
    }
}

