/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.dependency;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianFactory;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianInputFactory;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.server.annotation.ServiceAnnotationUtil;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotation;
import com.kingdee.bos.qing.common.framework.server.dependency.QingHessianServiceFactory;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MethodInvokeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QingServiceFactory {
    private static Map<String, Class<?>> serviceClassMap = new HashMap();

    QingServiceFactory() {
    }

    public static void regist(String serviceType, Class<?> serviceClass) {
        if (serviceClassMap.containsKey(serviceType)) {
            throw new RuntimeException("something is wrong");
        }
        ServiceAnnotationUtil.handlerClassAnnotation(serviceClass);
        serviceClassMap.put(serviceType, serviceClass);
    }

    public static final Object getServiceImpl(String serviceType) throws InstantiationException, IllegalAccessException {
        Class<?> clazz;
        if (serviceType == null) {
            return null;
        }
        int lastIndexOf = serviceType.lastIndexOf(47);
        if (lastIndexOf > 0) {
            String oldwUrl = serviceType.substring(0, lastIndexOf);
            String newUrl = serviceType.substring(lastIndexOf);
            lastIndexOf = oldwUrl.lastIndexOf(47);
            serviceType = newUrl = oldwUrl.substring(lastIndexOf) + newUrl;
        }
        if ((clazz = serviceClassMap.get(serviceType)) == null) {
            return null;
        }
        return clazz.newInstance();
    }

    static {
        QingServiceFactory.regist("QingSystemFramework", QingSystemFrameworkService.class);
    }

    public static class QingHessianService
    implements IQingContextable {
        private QingContext qingContext;
        private static SerializerFactory serializerFactory = new SerializerFactory();
        private static HessianInputFactory inputFactory = new HessianInputFactory();
        private static HessianFactory hessianFactory = new HessianFactory();
        private static Map<Class<?>, Map<String, Method>> cache = new HashMap();

        @Override
        public void setQingContext(QingContext qingContext) {
            this.qingContext = qingContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @LongTimeServiceMethodAnnotation
        public byte[] invoke(String serviceName, byte[] requestBytes) throws IOException {
            HessianOutput out;
            HessianInput in;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(requestBytes);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            HessianInputFactory.HeaderType header = inputFactory.readHeader((InputStream)byteArrayInputStream);
            switch (header) {
                case CALL_1_REPLY_1: {
                    in = hessianFactory.createHessianInput((InputStream)byteArrayInputStream);
                    out = hessianFactory.createHessianOutput((OutputStream)byteArrayOutputStream);
                    break;
                }
                case CALL_1_REPLY_2: {
                    in = hessianFactory.createHessianInput((InputStream)byteArrayInputStream);
                    out = hessianFactory.createHessian2Output((OutputStream)byteArrayOutputStream);
                    break;
                }
                case HESSIAN_2: {
                    in = hessianFactory.createHessian2Input((InputStream)byteArrayInputStream);
                    in.readCall();
                    out = hessianFactory.createHessian2Output((OutputStream)byteArrayOutputStream);
                    break;
                }
                default: {
                    throw new IllegalStateException(header + " is an unknown Hessian call");
                }
            }
            if (serializerFactory != null) {
                in.setSerializerFactory(serializerFactory);
                out.setSerializerFactory(serializerFactory);
            }
            this.invoke(serviceName, (AbstractHessianInput)in, (AbstractHessianOutput)out);
            IQingFile qingFile = FileFactory.newTempFile(QingTempFileType.EXPORT);
            ByteArrayInputStream inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                qingFile.write(new CopyWriteCall(inputStream, false), true);
            }
            catch (Throwable throwable) {
                CloseUtil.close(inputStream);
                inputStream = null;
                throw throwable;
            }
            CloseUtil.close(inputStream);
            inputStream = null;
            return ResponseUtil.output(new ResponseSuccessWrap(qingFile.getName()));
        }

        private void invoke(String serviceName, AbstractHessianInput in, AbstractHessianOutput out) throws IOException {
            String methodName = in.readMethod();
            int argLength = in.readMethodArgLength();
            Object service = null;
            try {
                service = QingHessianServiceFactory.getServiceImpl(serviceName);
            }
            catch (Exception e) {
                out.writeFault("NoSuchServiceName", this.escapeMessage("service " + serviceName + " not found"), null);
                out.close();
                return;
            }
            Class<?> serviceClass = service.getClass();
            Method method = this.getMethod(serviceClass, methodName + "__" + argLength);
            if (method == null) {
                method = this.getMethod(serviceClass, methodName);
            }
            if (method == null) {
                String message = this.escapeMessage("method " + method + " argument length mismatch, received length=" + argLength);
                LogUtil.error(message);
                out.writeFault("NoSuchMethod", message, null);
                out.close();
                return;
            }
            Class<?>[] args = method.getParameterTypes();
            if (argLength != args.length && argLength >= 0) {
                String message = this.escapeMessage("method " + method + " argument length mismatch, received length=" + argLength);
                LogUtil.error(message);
                out.writeFault("NoSuchMethod", message, null);
                out.close();
                return;
            }
            Object[] values = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                values[i] = in.readObject(args[i]);
            }
            in.completeCall();
            Object result = null;
            try {
                MethodInvokeUtil.interfaceInject(this.qingContext, service, values);
                MethodInvokeUtil.annotationInject(this.qingContext, service, method, values);
                result = method.invoke(service, values);
            }
            catch (Exception e) {
                LogUtil.error(e.getMessage(), e);
                Throwable e1 = e;
                if (e1 instanceof InvocationTargetException) {
                    e1 = ((InvocationTargetException)e).getTargetException();
                }
                out.writeFault("ServiceException", this.escapeMessage(e1.getMessage()), (Object)e1);
                out.close();
                return;
            }
            out.writeReply(result);
            out.close();
        }

        private String escapeMessage(String msg) {
            if (msg == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int length = msg.length();
            block6: for (int i = 0; i < length; ++i) {
                char ch = msg.charAt(i);
                switch (ch) {
                    case '<': {
                        sb.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block6;
                    }
                    case '\u0000': {
                        sb.append("&#00;");
                        continue block6;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block6;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            return sb.toString();
        }

        private Method getMethod(Class<?> serviceClass, String methodName) {
            Map<String, Method> methodMap = cache.get(serviceClass);
            if (methodMap == null) {
                methodMap = new HashMap<String, Method>();
                Method[] methodList = serviceClass.getMethods();
                for (int i = 0; i < methodList.length; ++i) {
                    Method method = methodList[i];
                    if (methodMap.get(method.getName()) == null) {
                        methodMap.put(method.getName(), methodList[i]);
                    }
                    Class<?>[] param = method.getParameterTypes();
                    String mangledName = method.getName() + "__" + param.length;
                    methodMap.put(mangledName, methodList[i]);
                }
                cache.put(serviceClass, methodMap);
            }
            return methodMap.get(methodName);
        }
    }

    public static class QingSystemFrameworkService
    implements IQingContextable {
        private QingContext qingContext;

        @Override
        public void setQingContext(QingContext qingContext) {
            this.qingContext = qingContext;
        }

        public byte[] closePage(Map<String, String> params) {
            String clientID = params.get("clientID");
            ArrayList<String> clientIDs = new ArrayList<String>();
            clientIDs.add(clientID);
            ClientManager.setClientClosed(this.qingContext, clientIDs);
            return ResponseUtil.output(new ResponseSuccessWrap(true));
        }
    }
}

