/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.msgpublish;

import com.kingdee.bos.qing.common.framework.server.msgpublish.IMsgPublisherListener;
import com.kingdee.bos.qing.common.framework.server.msgpublish.MsgPublishAction;
import com.kingdee.bos.qing.common.framework.server.msgpublish.MsgPublisherState;
import com.kingdee.bos.qing.common.framework.server.msgpublish.PublisherOutofDateException;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncServerChannelMsgPublisher
implements Runnable {
    private LinkedBlockingQueue<MsgPublishAction> actionQueue = new LinkedBlockingQueue();
    private volatile boolean running = false;
    private String clientID;
    private Object statesLock = new Object();
    private IMsgPublisherListener listener;
    private volatile MsgPublisherState msgPublisherState = MsgPublisherState.NOT_BEGIN;
    private AtomicLong actionCounter = new AtomicLong(0L);

    public AsyncServerChannelMsgPublisher(String clientID, IMsgPublisherListener publishListener) {
        this.clientID = clientID;
        this.listener = publishListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishMsg(MsgPublishAction action) throws PublisherOutofDateException {
        boolean notifyBegin = false;
        Object object = this.statesLock;
        synchronized (object) {
            if (this.msgPublisherState.ordinal() >= MsgPublisherState.PUBLISH_SUCCEED.ordinal()) {
                throw new PublisherOutofDateException();
            }
            if (this.isNotStarted()) {
                this.running = true;
                notifyBegin = true;
            }
            action.setIndex(this.actionCounter.incrementAndGet());
            this.actionQueue.offer(action);
        }
        if (notifyBegin) {
            this.listener.onPublisherStateChanged(this.clientID, MsgPublisherState.READY_BEGIN, this);
        }
    }

    private boolean isNotStarted() {
        return this.msgPublisherState == MsgPublisherState.NOT_BEGIN && !this.running;
    }

    @Override
    public void run() {
        this.msgPublisherState = MsgPublisherState.PUBLISHING;
        while (this.running) {
            MsgPublishAction action = this.poll();
            if (null != action) {
                this.doAction(action);
                continue;
            }
            this.stopMe();
        }
        if (null != this.listener) {
            this.listener.onPublisherStateChanged(this.clientID, this.msgPublisherState, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMe() {
        Object object = this.statesLock;
        synchronized (object) {
            if (this.actionQueue.size() == 0) {
                this.running = false;
                this.msgPublisherState = MsgPublisherState.PUBLISH_SUCCEED;
            }
        }
    }

    private MsgPublishAction poll() {
        try {
            return this.actionQueue.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }

    private void doAction(MsgPublishAction action) {
        try {
            action.run();
            while (this.actionQueue.size() > 0) {
                ArrayList<MsgPublishAction> reserved = new ArrayList<MsgPublishAction>();
                this.actionQueue.drainTo(reserved);
                List<MsgPublishAction> actions = this.mergeSameTypeAction(reserved);
                for (MsgPublishAction publishAction : actions) {
                    publishAction.run();
                }
            }
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
        }
    }

    private List<MsgPublishAction> mergeSameTypeAction(List<MsgPublishAction> reserved) {
        MsgPublishAction preAction = null;
        ArrayList<MsgPublishAction> actionsAfterMerge = new ArrayList<MsgPublishAction>();
        if (reserved.size() == 0) {
            return actionsAfterMerge;
        }
        for (MsgPublishAction msgPublishAction : reserved) {
            if (null != preAction) {
                if (preAction.mergeAction(msgPublishAction)) continue;
                actionsAfterMerge.add(msgPublishAction);
                preAction = msgPublishAction;
                continue;
            }
            actionsAfterMerge.add(msgPublishAction);
            preAction = msgPublishAction;
        }
        return actionsAfterMerge;
    }
}

