/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.model.server.ServerRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.server.task.DuplicatedWorkWaiting;
import com.kingdee.bos.qing.common.framework.server.task.IThreadTaskInvokeListener;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MethodInvokeUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.concurrent.Callable;

public class AsynServerRequestInvokeTask
implements Callable<Void> {
    private QingContext context;
    private ServerRequestInvokeContext invokeContext;
    private Object service;
    private volatile byte[] result = null;
    private IThreadTaskInvokeListener invokeTaskListener;
    private String sourceServer;
    private String taskId;
    private ThreadPoolManage.QingThreadPoolName threadPoolName;
    private boolean isNeedInvokeLocal = false;
    private QingServiceAsynDispatcherModel dispatcherModel;
    private long blockBeginTime = -1L;

    public AsynServerRequestInvokeTask(QingContext context, ServerRequestInvokeContext invokeContext, Object service, QingServiceAsynDispatcherModel dispatcherModel) {
        this.context = context;
        this.invokeContext = invokeContext;
        this.service = service;
        this.dispatcherModel = dispatcherModel;
    }

    public QingServiceAsynDispatcherModel getDispatcherModel() {
        return this.dispatcherModel;
    }

    public boolean isNeedInvokeLocal() {
        return this.isNeedInvokeLocal;
    }

    public long getBlockBeginTime() {
        return this.blockBeginTime;
    }

    public void setBlockBeginTime(long blockBeginTime) {
        this.blockBeginTime = blockBeginTime;
    }

    public void setNeedInvokeLocal(boolean needInvokeLocal) {
        this.isNeedInvokeLocal = needInvokeLocal;
    }

    public ThreadPoolManage.QingThreadPoolName getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(ThreadPoolManage.QingThreadPoolName threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public void setInvokeTaskListener(IThreadTaskInvokeListener invokeTaskListener) {
        this.invokeTaskListener = invokeTaskListener;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getSourceServer() {
        return this.sourceServer;
    }

    public void setSourceServer(String sourceServer) {
        this.sourceServer = sourceServer;
    }

    public byte[] getResult() {
        return this.result;
    }

    public QingContext getContext() {
        return this.context;
    }

    public String getTaskDesc() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" method name\uff1a");
        stringBuilder.append(this.dispatcherModel.getMethodName());
        stringBuilder.append(" service name:");
        stringBuilder.append(this.service.getClass().getName());
        stringBuilder.append(" taskId\uff1a");
        stringBuilder.append(this.taskId);
        return stringBuilder.toString();
    }

    public ServerRequestInvokeContext getInvokeContext() {
        return this.invokeContext;
    }

    @Override
    public Void call() {
        boolean needContinue = this.notifyTaskBegin();
        if (!needContinue) {
            return null;
        }
        try {
            LogUtil.info("mservice node AsynServerRequestInvokeTask call " + this.dispatcherModel.getCallID() + " start");
            ServerRequestInvokeContext.setThreadLocal(this.invokeContext);
            ServerRequestInvokeContext.setAsynServerRequestTL(this);
            this.doCall();
        }
        finally {
            this.notifyTaskFinished();
        }
        return null;
    }

    private boolean notifyTaskBegin() {
        if (null != this.invokeTaskListener) {
            return this.invokeTaskListener.onTaskBegin(this);
        }
        return true;
    }

    private void notifyTaskFinished() {
        if (null != this.invokeTaskListener) {
            this.invokeTaskListener.onTaskFinished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCall() {
        Exception exception = null;
        byte[] invokeResult = null;
        AbstractResponseWrap data = null;
        try {
            invokeResult = (byte[])MethodInvokeUtil.invoke(this.context, this.service, this.dispatcherModel.getMethodName(), this.dispatcherModel.getParameters());
            if (invokeResult != null) {
                data = AbstractResponseWrap.decodeFromBytes(invokeResult);
            }
        }
        catch (DuplicatedWorkWaiting e) {
            return;
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
            exception = e;
            data = new ResponseErrorWrap(exception);
        }
        String callID = this.dispatcherModel.getCallID();
        try {
            ServerRequestInvokeContext innerInvokeContext = ServerRequestInvokeContext.get();
            if (innerInvokeContext != null) {
                innerInvokeContext.stopHealthCheck();
            }
            String clientID = this.dispatcherModel.getClientID();
            boolean isClientClosed = ClientManager.isClientClosed(clientID, false, null);
            boolean isCallCanceled = ClientCallManager.isCallCanceled(clientID, callID, null);
            if (isClientClosed || isCallCanceled) {
                LogUtil.error("mservice node AsynServerRequestInvokeTask ClientClosed " + isClientClosed + ",callID " + callID + ",clientID " + clientID);
                LogUtil.error("mservice node AsynServerRequestInvokeTask CallCanceled " + isCallCanceled + ",callID " + callID + ",clientID " + clientID);
                return;
            }
            if (data != null) {
                this.setResult(data);
            } else {
                LogUtil.error("mservice node AsynServerRequestInvokeTask call, Result is null.,callID " + callID + ",clientID " + clientID + ",sessionID " + QingSessionUtil.getQingSessionImpl().getId());
            }
        }
        finally {
            ServerRequestInvokeContext.removeThreadLocal();
            TracerUtil.clearCurrentThreadCache();
            LogUtil.info("mservice node AsynServerRequestInvokeTask call " + callID + " end");
        }
    }

    public void setResult(AbstractResponseWrap data) {
        ServerRemoteCallMessage serverRemoteCallMessage = new ServerRemoteCallMessage(this.dispatcherModel.getClientID(), this.dispatcherModel.getCallID(), data);
        ClientCallManager.setCallResult(serverRemoteCallMessage);
        this.result = serverRemoteCallMessage.toBytes();
    }
}

