/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceHelper;
import com.kingdee.bos.qing.common.framework.server.annotation.rptexec.RptExecServiceHelper;
import com.kingdee.bos.qing.common.framework.server.dependency.QingServiceFactory;
import com.kingdee.bos.qing.common.framework.server.task.AsynServerRequestInvokeTask;
import com.kingdee.bos.qing.common.framework.server.task.InvokeHealthCheckTask;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsynServerRequestInvoker {
    private QingContext context;
    private QingServiceAsynDispatcherModel dispatcherModel;

    public AsynServerRequestInvoker(QingContext context, QingServiceAsynDispatcherModel dispatcherModel) {
        this.context = context;
        this.dispatcherModel = dispatcherModel;
    }

    public byte[] invoke() throws InterruptedException, ExecutionException, IllegalAccessException, InstantiationException {
        Object service;
        String clientID = this.dispatcherModel.getClientID();
        String callID = this.dispatcherModel.getCallID();
        String serviceType = this.dispatcherModel.getServiceType();
        String methodName = this.dispatcherModel.getMethodName();
        Object[] parameters = this.dispatcherModel.getParameters();
        if (!ClientCallManager.isCallWorkingInServer(ServerRequestInvokeContext.CheckerName.RPCServer, clientID, callID, false) && (service = QingServiceFactory.getServiceImpl(serviceType)) != null) {
            ServerRequestInvokeContext invokeContext = new ServerRequestInvokeContext(ServerRequestInvokeContext.CheckerName.RPCServer, this.dispatcherModel.getAppID(), clientID, callID);
            InvokeHealthCheckTask.addInvokeContext(invokeContext);
            AsynServerRequestInvokeTask invokeActionTask = new AsynServerRequestInvokeTask(this.context, invokeContext, service, this.dispatcherModel);
            ThreadPoolManage.QingThreadPoolName threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER;
            if (LongTimeServiceHelper.isLongTimeService(service, methodName)) {
                threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_LONG_TIME_TASK_HANDLER;
            } else if (RptExecServiceHelper.isRptExecService(service, methodName)) {
                threadPoolName = ThreadPoolManage.QingThreadPoolName.QING_RPT_EXEC_TASK_HANDLER;
            }
            Future<Void> resultFuture = ThreadPoolManage.excuteThreadWithContext(threadPoolName, invokeActionTask, this.context);
            try {
                resultFuture.get(3L, TimeUnit.SECONDS);
                return invokeActionTask.getResult();
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        return null;
    }
}

