/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar;

import com.kingdee.bos.qing.common.grammar.FunctionProvider;
import com.kingdee.bos.qing.common.grammar.IContextRelativedExprConfirmer;
import com.kingdee.bos.qing.common.grammar.Scanner;
import com.kingdee.bos.qing.common.grammar.Token;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.exception.ScanCharException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractDulisticOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.AbstractExpr;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.ConstanceExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.NegativeExpr;
import com.kingdee.bos.qing.common.grammar.expr.NumberExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.grammar.expr.StringExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    private Scanner _scanner = new Scanner();
    private WorkingStack _stack = new WorkingStack();
    private FunctionProvider _functionProvider;
    private IContextRelativedExprConfirmer _refConfirmer;

    public void setFunctionProvider(FunctionProvider functionProvider) {
        this._functionProvider = functionProvider;
    }

    public void setContextRelativedExprConfirmer(IContextRelativedExprConfirmer refConfirmer) {
        this._refConfirmer = refConfirmer;
    }

    public IExpr parse(String formula) throws ParserException {
        List<Token> tokens;
        try {
            tokens = this._scanner.scan(formula);
        }
        catch (ScanCharException ex) {
            throw new ParserException(ex);
        }
        return this.syntaxParse(tokens);
    }

    private IExpr syntaxParse(List<Token> tokens) throws ParserException {
        AbstractWorkingElement node;
        this._stack.clear();
        TokenQueue queue = new TokenQueue(tokens);
        while (!queue.isEmpty()) {
            AbstractWorkingElement node2;
            TokenWrapper tokenNode = queue.dequeue();
            if (tokenNode == null || this.pushSimpleToken(node2 = this.transform(tokenNode)) || this.pushOpToEmptyStack(node2)) continue;
            this.tryToCompositeAhead(node2);
            if (node2.getPriority() == AbstractWorkingElement.OperatorPriority.RBracket) continue;
            this._stack.push(node2);
        }
        if (this._stack.size() > 1) {
            this.tryToCompositeAhead(new TokenWrapper(null));
            if (this._stack.size() > 1) {
                while (!this._stack.isEmpty()) {
                    node = this._stack.pop();
                    if (node.getPriority() == AbstractWorkingElement.OperatorPriority.LBracket) {
                        throw Parser.createException(7, node);
                    }
                    if (node.getPriority() != AbstractWorkingElement.OperatorPriority.Comma) continue;
                    throw Parser.createException(10, node);
                }
                throw new RuntimeException("Impossible");
            }
        } else if (this._stack.size() == 0) {
            throw new ParserException(5, 0);
        }
        if ((node = this._stack.pop()).getPriority() == AbstractWorkingElement.OperatorPriority.LBracket) {
            throw Parser.createException(7, node);
        }
        if (node.getPriorityLevel() < AbstractWorkingElement.OperatorPriority.Atom.getLevel()) {
            throw Parser.createException(9, node);
        }
        IExpr expr = node.getExpr();
        this.checkVariantExpr(expr);
        return expr;
    }

    private void checkVariantExpr(IExpr root) throws ParserException {
        ArrayList<IExpr> queue = new ArrayList<IExpr>();
        queue.add(root);
        while (!queue.isEmpty()) {
            IExpr node = (IExpr)queue.remove(0);
            if (node instanceof VariantExpr) {
                this._refConfirmer.checkVariantExpr((VariantExpr)node);
                continue;
            }
            if (!(node instanceof AbstractOpExpr)) continue;
            for (IExpr subExpr : ((AbstractOpExpr)node).getSubExprs()) {
                queue.add(subExpr);
            }
        }
    }

    private AbstractWorkingElement transform(TokenWrapper node) {
        if (node.getPriority() == AbstractWorkingElement.OperatorPriority.Minus && (this._stack.isEmpty() || this._stack.peek().getPriorityLevel() < AbstractWorkingElement.OperatorPriority.Atom.getLevel())) {
            return new NegativeWrapper(node.getToken());
        }
        return node;
    }

    private boolean pushSimpleToken(AbstractWorkingElement node) throws ParserException {
        switch (node.getPriority()) {
            case Const: 
            case Var: {
                this.pushValue(node);
                return true;
            }
            case LBracket: {
                this.pushLeftBracket(node);
                return true;
            }
        }
        return false;
    }

    private void pushValue(AbstractWorkingElement node) throws ParserException {
        if (!this._stack.isEmpty() && this._stack.peek().getPriorityLevel() >= AbstractWorkingElement.OperatorPriority.Atom.getLevel()) {
            throw Parser.createException(6, node);
        }
        this._stack.push(node);
    }

    private void pushLeftBracket(AbstractWorkingElement node) throws ParserException {
        if (!this._stack.isEmpty()) {
            AbstractWorkingElement aheadNode = this._stack.peek();
            if (aheadNode.getPriority() == AbstractWorkingElement.OperatorPriority.Var) {
                String text = aheadNode.getExpr().encode();
                FunctionNameWrapper rewrap = new FunctionNameWrapper(text, aheadNode.getChrIdxAtFormula());
                this._stack.pop();
                this._stack.push(rewrap);
            } else if (aheadNode.getPriorityLevel() >= AbstractWorkingElement.OperatorPriority.Atom.getLevel()) {
                throw Parser.createException(6, node);
            }
        }
        this._stack.push(node);
    }

    private boolean pushOpToEmptyStack(AbstractWorkingElement node) throws ParserException {
        if (this._stack.isEmpty()) {
            if (node.getPriority() == AbstractWorkingElement.OperatorPriority.Comma) {
                throw Parser.createException(10, node);
            }
            if (node.getPriority() == AbstractWorkingElement.OperatorPriority.RBracket) {
                throw Parser.createException(8, node);
            }
            switch (node.getOperatorPosition()) {
                case Infix: {
                    throw Parser.createException(5, node);
                }
                case Prefix: {
                    this._stack.push(node);
                    break;
                }
                default: {
                    throw new RuntimeException("Modify here when OperatorPosition added.");
                }
            }
            return true;
        }
        return false;
    }

    private void tryToCompositeAhead(AbstractWorkingElement node) throws ParserException {
        boolean isTakeoff = false;
        WorkingStack tempStack = new WorkingStack();
        while (!this._stack.isEmpty()) {
            AbstractWorkingElement aheadNode = this._stack.pop();
            AbstractWorkingElement.OperatorPosition oppos = aheadNode.getOperatorPosition();
            if (oppos == null) {
                if (aheadNode.getPriority() == AbstractWorkingElement.OperatorPriority.LBracket) {
                    if (node.getPriority() == AbstractWorkingElement.OperatorPriority.RBracket) {
                        isTakeoff = true;
                        if (this._stack.isEmpty() || this._stack.peek().getPriority() != AbstractWorkingElement.OperatorPriority.FunctionName) break;
                        continue;
                    }
                    this._stack.push(aheadNode);
                    break;
                }
                if (aheadNode.getPriority() == AbstractWorkingElement.OperatorPriority.Comma && node.getPriority() != AbstractWorkingElement.OperatorPriority.RBracket) {
                    this._stack.push(aheadNode);
                    break;
                }
                tempStack.push(aheadNode);
                continue;
            }
            if (aheadNode.getPriorityLevel() < node.getPriorityLevel()) {
                this._stack.push(aheadNode);
                break;
            }
            switch (oppos) {
                case Infix: {
                    this.compositeInfixOp(tempStack, (TokenWrapper)aheadNode);
                    this.tryToCompositeAhead(node);
                    return;
                }
                case Prefix: {
                    this.compositePrefixOp(tempStack, aheadNode);
                    if (aheadNode.getPriority() != AbstractWorkingElement.OperatorPriority.FunctionName) {
                        this.tryToCompositeAhead(node);
                    }
                    return;
                }
            }
            throw new RuntimeException("Modify here when OperatorPosition added.");
        }
        if (node.getPriority() == AbstractWorkingElement.OperatorPriority.RBracket) {
            if (isTakeoff) {
                if (!tempStack.isEmpty()) {
                    this.wrapExprWhenTakeoff(tempStack);
                }
            } else {
                throw Parser.createException(8, node);
            }
        }
        while (!tempStack.isEmpty()) {
            this._stack.push(tempStack.pop());
        }
    }

    private void wrapExprWhenTakeoff(WorkingStack poppedStack) throws ParserException {
        AbstractWorkingElement node;
        if (poppedStack.size() == 1) {
            node = poppedStack.pop();
            if (node.getPriorityLevel() == AbstractWorkingElement.OperatorPriority.Comma.getLevel()) {
                throw Parser.createException(10, node);
            }
        } else {
            while (!poppedStack.isEmpty()) {
                AbstractWorkingElement node2 = poppedStack.pop();
                if (node2.getPriorityLevel() != AbstractWorkingElement.OperatorPriority.Comma.getLevel()) continue;
                throw Parser.createException(10, node2);
            }
            throw new RuntimeException("Impossible");
        }
        this._stack.push(new ExprWrapper(node.getExpr()));
    }

    private void compositeInfixOp(WorkingStack poppedStack, TokenWrapper opNode) throws ParserException {
        AbstractDulisticOpExpr expr;
        if (poppedStack.size() != 1) {
            throw Parser.createExceptionAfterNode(5, opNode);
        }
        IExpr subExpr2 = poppedStack.pop().getExpr();
        AbstractWorkingElement subWrapper1 = this._stack.pop();
        if (subWrapper1.getPriorityLevel() < AbstractWorkingElement.OperatorPriority.Atom.getLevel()) {
            throw Parser.createException(5, opNode);
        }
        IExpr subExpr1 = subWrapper1.getExpr();
        switch (opNode.getToken().getType()) {
            case PLUS: {
                expr = new AbstractDulisticOpExpr.OpPlus(subExpr1, subExpr2);
                break;
            }
            case MINUS: {
                expr = new AbstractDulisticOpExpr.OpMinus(subExpr1, subExpr2);
                break;
            }
            case MULTIPLY: {
                expr = new AbstractDulisticOpExpr.OpMultiply(subExpr1, subExpr2);
                break;
            }
            case DIVIDE: {
                expr = new AbstractDulisticOpExpr.OpDivide(subExpr1, subExpr2);
                break;
            }
            case EQUAL: {
                expr = new AbstractDulisticOpExpr.OpEqual(subExpr1, subExpr2);
                break;
            }
            case RELOP: {
                String op = opNode.getToken().getText();
                if ("<>".equals(op)) {
                    expr = new AbstractDulisticOpExpr.OpNotEqual(subExpr1, subExpr2);
                    break;
                }
                if (">".equals(op)) {
                    expr = new AbstractDulisticOpExpr.OpLarger(subExpr1, subExpr2);
                    break;
                }
                if (">=".equals(op)) {
                    expr = new AbstractDulisticOpExpr.OpLargerEqual(subExpr1, subExpr2);
                    break;
                }
                if ("<".equals(op)) {
                    expr = new AbstractDulisticOpExpr.OpLess(subExpr1, subExpr2);
                    break;
                }
                if ("<=".equals(op)) {
                    expr = new AbstractDulisticOpExpr.OpLessEqual(subExpr1, subExpr2);
                    break;
                }
                throw new RuntimeException("Impossible");
            }
            default: {
                throw new RuntimeException("Modify here when infix-operator added.");
            }
        }
        this._stack.push(new ExprWrapper(expr, subWrapper1.getChrIdxAtFormula()));
    }

    private void compositePrefixOp(WorkingStack poppedStack, AbstractWorkingElement opNode) throws ParserException {
        switch (opNode.getPriority()) {
            case Negative: {
                this.compositeNegativeExpr(poppedStack, opNode);
                break;
            }
            case FunctionName: {
                this.compositeFunctionExpr(poppedStack, (FunctionNameWrapper)opNode);
                break;
            }
            default: {
                throw new RuntimeException("Modify here when prefix-operator added.");
            }
        }
    }

    private void compositeNegativeExpr(WorkingStack poppedStack, AbstractWorkingElement negativeOp) throws ParserException {
        if (poppedStack.size() != 1) {
            throw Parser.createExceptionAfterNode(9, negativeOp);
        }
        IExpr expr = poppedStack.pop().getExpr();
        NegativeExpr negativeExpr = new NegativeExpr(expr);
        this._stack.push(new ExprWrapper(negativeExpr, negativeOp.getChrIdxAtFormula()));
    }

    private void compositeFunctionExpr(WorkingStack poppedStack, FunctionNameWrapper opNode) throws ParserException {
        AbstractFunctionExpr prototypeExpr = null;
        if (this._functionProvider != null) {
            prototypeExpr = this._functionProvider.search(opNode.getFunctionName());
        }
        if (prototypeExpr == null) {
            throw Parser.createException(13, opNode);
        }
        boolean checkSeparator = false;
        ArrayList<IExpr> params = new ArrayList<IExpr>(3);
        while (!poppedStack.isEmpty()) {
            AbstractWorkingElement node = poppedStack.pop();
            if (checkSeparator) {
                if (node.getPriority() == AbstractWorkingElement.OperatorPriority.Comma) {
                    if (poppedStack.isEmpty()) {
                        throw Parser.createExceptionAfterNode(5, node);
                    }
                    checkSeparator = false;
                    continue;
                }
                throw new RuntimeException("Impossible");
            }
            if (node.getPriorityLevel() >= AbstractWorkingElement.OperatorPriority.Atom.getLevel()) {
                params.add(node.getExpr());
                checkSeparator = true;
                continue;
            }
            if (node.getPriority() == AbstractWorkingElement.OperatorPriority.Comma) {
                throw Parser.createException(5, node);
            }
            throw new RuntimeException("Impossible");
        }
        AbstractFunctionExpr functionExpr = null;
        try {
            functionExpr = prototypeExpr.createInstance(params.toArray(new IExpr[0]));
        }
        catch (ParserException ex) {
            if (ex.getType() == 15 || ex.getType() == 13) {
                throw Parser.createException(ex.getType(), opNode);
            }
            throw ex;
        }
        this._stack.push(new ExprWrapper(functionExpr, opNode.getChrIdxAtFormula()));
    }

    private static ParserException createException(int type, AbstractWorkingElement node) {
        int charIdx = node.getChrIdxAtFormula();
        ParserException ex = new ParserException(type, charIdx);
        return ex;
    }

    private static ParserException createExceptionAfterNode(int type, AbstractWorkingElement node) {
        int charIdx = node.getChrIdxAtFormula(true);
        ParserException ex = new ParserException(type, charIdx);
        return ex;
    }

    private static class ExprWrapper
    extends AbstractWorkingElement {
        private IExpr _expr;

        public ExprWrapper(IExpr expr) {
            this._expr = expr;
        }

        public ExprWrapper(AbstractExpr expr, int chrIdxAtFormula) {
            this._expr = expr;
            expr.setCharIndexAtFormula(chrIdxAtFormula);
        }

        @Override
        public AbstractWorkingElement.OperatorPriority getPriority() {
            return AbstractWorkingElement.OperatorPriority.Atom;
        }

        @Override
        public AbstractWorkingElement.OperatorPosition getOperatorPosition() {
            return null;
        }

        @Override
        public int getChrIdxAtFormula(boolean isAfterNode) {
            if (isAfterNode) {
                throw new RuntimeException("Unsupported");
            }
            return this._expr.getCharIndexAtFormula();
        }

        @Override
        public IExpr getExpr() throws ParserException {
            return this._expr;
        }

        public String toString() {
            return this._expr.encode();
        }
    }

    private static class FunctionNameWrapper
    extends AbstractWorkingElement {
        private String _name;
        private int _chrIdxAtFormula;

        public FunctionNameWrapper(String name, int chrIdxAtFormula) {
            this._name = name;
            this._chrIdxAtFormula = chrIdxAtFormula;
        }

        public String getFunctionName() {
            return this._name;
        }

        @Override
        public AbstractWorkingElement.OperatorPriority getPriority() {
            return AbstractWorkingElement.OperatorPriority.FunctionName;
        }

        @Override
        public AbstractWorkingElement.OperatorPosition getOperatorPosition() {
            return AbstractWorkingElement.OperatorPosition.Prefix;
        }

        @Override
        public int getChrIdxAtFormula(boolean isAfterNode) {
            if (isAfterNode) {
                return this._chrIdxAtFormula + this._name.length();
            }
            return this._chrIdxAtFormula;
        }

        public String toString() {
            return this._name + "(...)";
        }
    }

    private static class NegativeWrapper
    extends AbstractWorkingElement {
        private Token _token;

        public NegativeWrapper(Token minusToken) {
            this._token = minusToken;
        }

        @Override
        public AbstractWorkingElement.OperatorPriority getPriority() {
            return AbstractWorkingElement.OperatorPriority.Negative;
        }

        @Override
        public AbstractWorkingElement.OperatorPosition getOperatorPosition() {
            return AbstractWorkingElement.OperatorPosition.Prefix;
        }

        @Override
        public int getChrIdxAtFormula(boolean isAfterNode) {
            if (isAfterNode) {
                return this._token.getChrIdxAtFormula() + 1;
            }
            return this._token.getChrIdxAtFormula();
        }

        public String toString() {
            return "-";
        }
    }

    private class TokenWrapper
    extends AbstractWorkingElement {
        private Token _token;
        private AbstractWorkingElement.OperatorPriority _priority;
        private AbstractWorkingElement.OperatorPosition _oppos = null;

        public TokenWrapper(Token token) {
            this._token = token;
            this.init();
        }

        public Token getToken() {
            return this._token;
        }

        private void init() {
            if (this._token == null) {
                this._priority = AbstractWorkingElement.OperatorPriority.END;
                return;
            }
            switch (this._token.getType()) {
                case PLUS: {
                    this._priority = AbstractWorkingElement.OperatorPriority.Plus;
                    this._oppos = AbstractWorkingElement.OperatorPosition.Infix;
                    break;
                }
                case MINUS: {
                    this._priority = AbstractWorkingElement.OperatorPriority.Minus;
                    this._oppos = AbstractWorkingElement.OperatorPosition.Infix;
                    break;
                }
                case MULTIPLY: 
                case DIVIDE: {
                    this._priority = AbstractWorkingElement.OperatorPriority.Multiply;
                    this._oppos = AbstractWorkingElement.OperatorPosition.Infix;
                    break;
                }
                case EQUAL: {
                    this._priority = AbstractWorkingElement.OperatorPriority.Equal;
                    this._oppos = AbstractWorkingElement.OperatorPosition.Infix;
                    break;
                }
                case RELOP: {
                    this._priority = "<>".equals(this._token.getText()) ? AbstractWorkingElement.OperatorPriority.Equal : AbstractWorkingElement.OperatorPriority.Larger;
                    this._oppos = AbstractWorkingElement.OperatorPosition.Infix;
                    break;
                }
                case STRING: 
                case NUMBER: {
                    this._priority = AbstractWorkingElement.OperatorPriority.Const;
                    break;
                }
                case REFERENCE: 
                case WORD: {
                    this._priority = AbstractWorkingElement.OperatorPriority.Var;
                    break;
                }
                case COMMA: {
                    this._priority = AbstractWorkingElement.OperatorPriority.Comma;
                    break;
                }
                case LBRACKET: {
                    this._priority = AbstractWorkingElement.OperatorPriority.LBracket;
                    break;
                }
                case RBRACKET: {
                    this._priority = AbstractWorkingElement.OperatorPriority.RBracket;
                    break;
                }
                default: {
                    throw new RuntimeException("Modify here when token-type added.");
                }
            }
        }

        @Override
        public AbstractWorkingElement.OperatorPriority getPriority() {
            return this._priority;
        }

        @Override
        public AbstractWorkingElement.OperatorPosition getOperatorPosition() {
            return this._oppos;
        }

        @Override
        public int getChrIdxAtFormula(boolean isAfterNode) {
            if (isAfterNode) {
                return this._token.getChrIdxAtFormula() + this._token.getText().length();
            }
            return this._token.getChrIdxAtFormula();
        }

        @Override
        public IExpr getExpr() throws ParserException {
            AbstractExpr expr;
            switch (this._token.getType()) {
                case REFERENCE: {
                    expr = new RefExpr(this._token.getText(), true);
                    expr.setCharIndexAtFormula(this._token.getChrIdxAtFormula());
                    Parser.this._refConfirmer.checkRefExpr((RefExpr)expr);
                    break;
                }
                case STRING: {
                    expr = new StringExpr(this._token.getText(), true);
                    break;
                }
                case NUMBER: {
                    expr = new NumberExpr(this._token.getText());
                    break;
                }
                case WORD: {
                    expr = ConstanceExpr.acceptAndCreate(this._token.getText());
                    if (expr != null) break;
                    expr = new VariantExpr(this._token.getText());
                    break;
                }
                default: {
                    throw new RuntimeException("Modify here when token-type added.");
                }
            }
            expr.setCharIndexAtFormula(this._token.getChrIdxAtFormula());
            return expr;
        }

        public String toString() {
            return this._token.getText();
        }
    }

    static abstract class AbstractWorkingElement {
        AbstractWorkingElement() {
        }

        public abstract OperatorPriority getPriority();

        public abstract OperatorPosition getOperatorPosition();

        public abstract int getChrIdxAtFormula(boolean var1);

        public final int getChrIdxAtFormula() {
            return this.getChrIdxAtFormula(false);
        }

        public IExpr getExpr() throws ParserException {
            throw new RuntimeException("Unsupported");
        }

        public final int getPriorityLevel() {
            return this.getPriority().getLevel();
        }

        public static enum OperatorPosition {
            Prefix,
            Infix;

        }

        public static enum OperatorPriority {
            Const(65535),
            Var(65535),
            Atom(65535),
            Negative(30),
            Multiply(21),
            Minus(20),
            Plus(20),
            Larger(11),
            Equal(10),
            FunctionName(-1),
            Comma(-65535),
            LBracket(-65535),
            RBracket(-65535),
            END(-65535);

            private int _level;

            private OperatorPriority(int level) {
                this._level = level;
            }

            public int getLevel() {
                return this._level;
            }
        }
    }

    private static class WorkingStack {
        private List<AbstractWorkingElement> _nodes = new ArrayList<AbstractWorkingElement>();

        private WorkingStack() {
        }

        public void clear() {
            this._nodes.clear();
        }

        public boolean isEmpty() {
            return this._nodes.isEmpty();
        }

        public int size() {
            return this._nodes.size();
        }

        public AbstractWorkingElement peek() {
            return this._nodes.get(this._nodes.size() - 1);
        }

        public AbstractWorkingElement pop() {
            return this._nodes.remove(this._nodes.size() - 1);
        }

        public void push(AbstractWorkingElement node) {
            this._nodes.add(node);
        }
    }

    private class TokenQueue {
        private List<Token> _tokens;
        private int _cursor;

        public TokenQueue(List<Token> tokens) {
            this._tokens = tokens;
            this._cursor = 0;
        }

        public boolean isEmpty() {
            return this._cursor >= this._tokens.size();
        }

        public TokenWrapper dequeue() {
            Token token;
            if ((token = this._tokens.get(this._cursor++)).getType() == Token.TokenType.BLANK) {
                return null;
            }
            TokenWrapper wrapper = new TokenWrapper(token);
            return wrapper;
        }
    }
}

