/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar;

import com.kingdee.bos.qing.common.grammar.Token;
import com.kingdee.bos.qing.common.grammar.exception.ScanCharException;
import java.util.ArrayList;
import java.util.List;

class Scanner {
    public static final char EOT = '\u0004';
    private static final boolean[] RESERVED = new boolean[128];
    private List<AbstractSearcher> _searchers;
    private AbstractSearcher _currentSearcher;

    public Scanner() {
        this.init();
    }

    private void init() {
        this._searchers = new ArrayList<AbstractSearcher>();
        this._searchers.add(new BlankSearcher());
        this._searchers.add(new SingleSignSearcher('+', Token.TokenType.PLUS));
        this._searchers.add(new SingleSignSearcher('-', Token.TokenType.MINUS));
        this._searchers.add(new SingleSignSearcher('*', Token.TokenType.MULTIPLY));
        this._searchers.add(new SingleSignSearcher('/', Token.TokenType.DIVIDE));
        this._searchers.add(new SingleSignSearcher('(', Token.TokenType.LBRACKET));
        this._searchers.add(new SingleSignSearcher(')', Token.TokenType.RBRACKET));
        this._searchers.add(new SingleSignSearcher(',', Token.TokenType.COMMA));
        this._searchers.add(new SingleSignSearcher('=', Token.TokenType.EQUAL));
        this._searchers.add(new RelationOperatorsSearcher());
        this._searchers.add(new NumberSearcher());
        this._searchers.add(new StringSearcher('\"'));
        this._searchers.add(new StringSearcher('\''));
        this._searchers.add(new ReferenceSearcher('[', ']'));
        this._searchers.add(new WordSearcher());
    }

    public List<Token> scan(String formula) throws ScanCharException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this._currentSearcher = null;
        int c = formula.length();
        for (int i = 0; i < c; ++i) {
            char chr = formula.charAt(i);
            try {
                this.scanOneChar(tokens, chr, i);
                continue;
            }
            catch (ScanCharException ex) {
                if (this._currentSearcher != null) {
                    this._currentSearcher.reset();
                }
                ex.setIdx(i);
                throw ex;
            }
        }
        if (this._currentSearcher != null) {
            try {
                this._currentSearcher.check('\u0004');
            }
            catch (ScanCharException ex) {
                int afterStartMark = formula.length() - this._currentSearcher._text.length();
                ex.setIdx(afterStartMark);
                this._currentSearcher.reset();
                throw ex;
            }
            tokens.add(this._currentSearcher.createTokenAndReset(formula.length() - 1));
        }
        return tokens;
    }

    private void scanOneChar(List<Token> tokens, char chr, int idx) throws ScanCharException {
        if (this._currentSearcher == null) {
            AbstractSearcher.CheckResult result = this.lookupSearcher(chr);
            if (result.isEnd()) {
                tokens.add(this._currentSearcher.createTokenAndReset(idx));
                this._currentSearcher = null;
            }
        } else {
            AbstractSearcher.CheckResult result = this._currentSearcher.check(chr);
            if (result.isYield()) {
                AbstractSearcher oldSearcher = this._currentSearcher;
                AbstractSearcher.CheckResult anotherResult = this.lookupAnotherSearcher(chr);
                if (anotherResult == null) {
                    oldSearcher.lookBack(true);
                } else {
                    oldSearcher.lookBack(false);
                    tokens.add(oldSearcher.createTokenAndReset(idx - 1));
                    if (anotherResult.isEnd()) {
                        tokens.add(this._currentSearcher.createTokenAndReset(idx));
                        this._currentSearcher = null;
                    }
                }
            } else if (result.isEnd()) {
                tokens.add(this._currentSearcher.createTokenAndReset(idx));
                this._currentSearcher = null;
            }
        }
    }

    private AbstractSearcher.CheckResult lookupSearcher(char chr) throws ScanCharException {
        for (AbstractSearcher searcher : this._searchers) {
            AbstractSearcher.CheckResult result = searcher.check(chr);
            if (result == AbstractSearcher.CheckResult.UNKNOWN) continue;
            this._currentSearcher = searcher;
            return result;
        }
        throw new RuntimeException("Sth. must be wrong.");
    }

    private AbstractSearcher.CheckResult lookupAnotherSearcher(char chr) throws ScanCharException {
        for (AbstractSearcher searcher : this._searchers) {
            AbstractSearcher.CheckResult result;
            if (searcher == this._currentSearcher || (result = searcher.check(chr)) == AbstractSearcher.CheckResult.UNKNOWN) continue;
            this._currentSearcher = searcher;
            return result;
        }
        return null;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            Scanner.RESERVED[i] = false;
        }
        Scanner.RESERVED[33] = true;
        Scanner.RESERVED[35] = true;
        Scanner.RESERVED[36] = true;
        Scanner.RESERVED[37] = true;
        Scanner.RESERVED[38] = true;
        Scanner.RESERVED[46] = true;
        Scanner.RESERVED[58] = true;
        Scanner.RESERVED[59] = true;
        Scanner.RESERVED[63] = true;
        Scanner.RESERVED[64] = true;
        Scanner.RESERVED[92] = true;
        Scanner.RESERVED[94] = true;
        Scanner.RESERVED[96] = true;
        Scanner.RESERVED[123] = true;
        Scanner.RESERVED[124] = true;
        Scanner.RESERVED[125] = true;
        Scanner.RESERVED[126] = true;
    }

    private static class ReferenceSearcher
    extends AbstractSearcher {
        private char _startMark;
        private char _endMark;

        public ReferenceSearcher(char startMark, char endMark) {
            this._startMark = startMark;
            this._endMark = endMark;
        }

        @Override
        protected Token.TokenType getTokenType() {
            return Token.TokenType.REFERENCE;
        }

        @Override
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            boolean isEndMark;
            boolean isStartMark = chr == this._startMark;
            boolean bl = isEndMark = chr == this._endMark;
            if (this.isBeforeStart()) {
                if (isStartMark) {
                    this.append(chr);
                    return AbstractSearcher.CheckResult.START;
                }
                return AbstractSearcher.CheckResult.UNKNOWN;
            }
            if (isEndMark) {
                this.append(chr);
                return AbstractSearcher.CheckResult.END;
            }
            if (chr == '\u0004') {
                throw new ScanCharException('[', 2);
            }
            this.append(chr);
            return AbstractSearcher.CheckResult.INSIDE;
        }
    }

    private static class BlankSearcher
    extends AbstractSearcher {
        private BlankSearcher() {
        }

        @Override
        protected Token.TokenType getTokenType() {
            return Token.TokenType.BLANK;
        }

        @Override
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            if (this.isBeforeStart()) {
                if (chr <= ' ') {
                    this.append(chr);
                    return AbstractSearcher.CheckResult.START;
                }
                return AbstractSearcher.CheckResult.UNKNOWN;
            }
            if (chr <= ' ') {
                this.append(chr);
                return AbstractSearcher.CheckResult.INSIDE;
            }
            return AbstractSearcher.CheckResult.YIELD;
        }
    }

    private static class RelationOperatorsSearcher
    extends AbstractSearcher {
        private char _first;

        private RelationOperatorsSearcher() {
        }

        @Override
        protected Token.TokenType getTokenType() {
            return Token.TokenType.RELOP;
        }

        @Override
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            if (this.isBeforeStart()) {
                if (chr == '<' || chr == '>') {
                    this._first = chr;
                    this.append(chr);
                    return AbstractSearcher.CheckResult.START;
                }
                return AbstractSearcher.CheckResult.UNKNOWN;
            }
            if (this._first == '<') {
                if (chr == '>' || chr == '=') {
                    this.append(chr);
                    return AbstractSearcher.CheckResult.END;
                }
                if (chr == '<') {
                    throw new ScanCharException(new char[]{this._first, chr}, 3);
                }
            } else if (this._first == '>') {
                if (chr == '=') {
                    this.append(chr);
                    return AbstractSearcher.CheckResult.END;
                }
                if (chr == '>' || chr == '<') {
                    throw new ScanCharException(new char[]{this._first, chr}, 3);
                }
            }
            return AbstractSearcher.CheckResult.YIELD;
        }
    }

    private static class SingleSignSearcher
    extends AbstractSearcher {
        private char _sign;
        private Token.TokenType _tokenType;

        public SingleSignSearcher(char sign, Token.TokenType tokenType) {
            this._sign = sign;
            this._tokenType = tokenType;
        }

        @Override
        protected Token.TokenType getTokenType() {
            return this._tokenType;
        }

        @Override
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            if (chr == this._sign) {
                this.append(chr);
                return AbstractSearcher.CheckResult.SINGLE;
            }
            return AbstractSearcher.CheckResult.UNKNOWN;
        }
    }

    private static class StringSearcher
    extends AbstractSearcher {
        private char _mark;
        private boolean _isTransfered = false;

        public StringSearcher(char mark) {
            this._mark = mark;
        }

        @Override
        protected Token.TokenType getTokenType() {
            return Token.TokenType.STRING;
        }

        @Override
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            boolean isMark;
            boolean bl = isMark = chr == this._mark;
            if (this.isBeforeStart()) {
                if (isMark) {
                    this._isTransfered = false;
                    this.append(chr);
                    return AbstractSearcher.CheckResult.START;
                }
                return AbstractSearcher.CheckResult.UNKNOWN;
            }
            if (this._isTransfered) {
                if (chr == '\\' || chr == '\"' || chr == '\'') {
                    this.append(chr);
                } else if (chr == 'r') {
                    this.append('\r');
                } else if (chr == 'n') {
                    this.append('\n');
                } else if (chr == 't') {
                    this.append('\t');
                } else {
                    throw new ScanCharException("\\" + chr, 4);
                }
                this._isTransfered = false;
                return AbstractSearcher.CheckResult.INSIDE;
            }
            if (chr == '\\') {
                this._isTransfered = true;
                return AbstractSearcher.CheckResult.INSIDE;
            }
            if (isMark) {
                this.append(chr);
                return AbstractSearcher.CheckResult.END;
            }
            if (chr == '\u0004') {
                throw new ScanCharException('\"', 2);
            }
            this.append(chr);
            return AbstractSearcher.CheckResult.INSIDE;
        }
    }

    private static class NumberSearcher
    extends AbstractSearcher {
        private boolean _isDotAppeared;

        private NumberSearcher() {
        }

        @Override
        protected Token.TokenType getTokenType() {
            return Token.TokenType.NUMBER;
        }

        @Override
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            boolean isDot;
            boolean isNum;
            boolean bl = isNum = chr > '/' && chr < ':';
            if (this.isBeforeStart()) {
                if (isNum) {
                    this._isDotAppeared = false;
                    this.append(chr);
                    return AbstractSearcher.CheckResult.START;
                }
                return AbstractSearcher.CheckResult.UNKNOWN;
            }
            if (isNum) {
                this.append(chr);
                return AbstractSearcher.CheckResult.INSIDE;
            }
            boolean bl2 = isDot = chr == '.';
            if (isDot) {
                if (this._isDotAppeared) {
                    throw new ScanCharException(chr, 3);
                }
                this._isDotAppeared = true;
                this.append(chr);
                return AbstractSearcher.CheckResult.INSIDE;
            }
            return AbstractSearcher.CheckResult.YIELD;
        }
    }

    private static class WordSearcher
    extends AbstractSearcher {
        private char _tempChar;

        private WordSearcher() {
        }

        @Override
        protected Token.TokenType getTokenType() {
            return Token.TokenType.WORD;
        }

        @Override
        protected AbstractSearcher.CheckResult checkImpl(char chr) throws ScanCharException {
            if (chr < '\u0080' && RESERVED[chr]) {
                throw new ScanCharException(chr, 1);
            }
            if (this.isBeforeStart()) {
                this.append(chr);
                return AbstractSearcher.CheckResult.START;
            }
            if (chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9') {
                this.append(chr);
                return AbstractSearcher.CheckResult.INSIDE;
            }
            this._tempChar = chr;
            return AbstractSearcher.CheckResult.YIELD;
        }

        @Override
        public void lookBack(boolean isContinueOtherwiseEnd) {
            if (isContinueOtherwiseEnd) {
                this.append(this._tempChar);
            }
            this._tempChar = '\u0000';
        }
    }

    public static abstract class AbstractSearcher {
        public static final int Status_Unknown = 1;
        public static final int Status_Accept = 2;
        public static final int Status_End = 4;
        public static final int Status_Yield = 8;
        private StringBuilder _text;
        private CheckResult _lastCheckResult;

        public AbstractSearcher() {
            this.reset();
        }

        public final void reset() {
            this._text = new StringBuilder();
            this._lastCheckResult = null;
        }

        protected final boolean isBeforeStart() {
            return this._text.length() == 0;
        }

        protected final void append(char chr) {
            this._text.append(chr);
        }

        public Token createTokenAndReset(int endCharIdx) {
            int startCharIdx = endCharIdx - this._text.length() + 1;
            Token token = new Token(this._text.toString(), this.getTokenType(), startCharIdx);
            this.reset();
            return token;
        }

        protected abstract Token.TokenType getTokenType();

        public final CheckResult check(char chr) throws ScanCharException {
            CheckResult result = this.checkImpl(chr);
            if (result == null) {
                throw new RuntimeException("\u5fc5\u987b\u8fd4\u56de\u4e00\u4e2a\u72b6\u6001");
            }
            if (this._lastCheckResult == null) {
                if (result.isStatus(8)) {
                    throw new RuntimeException("\u4e0d\u80fd\u4e00\u4e0a\u6765\u5c31Yield");
                }
            } else {
                if (this._lastCheckResult.isStatus(4)) {
                    throw new RuntimeException("End\u540e\u4e0d\u80fd\u8df3\u8f6c\u5230\u5176\u5b83\u72b6\u6001");
                }
                if (result.isStatus(1)) {
                    throw new RuntimeException("\u4e0d\u80fd\u4ece\u5176\u5b83\u72b6\u6001\u8df3\u8f6c\u5230Unknown");
                }
            }
            if (!result.isStatus(1)) {
                this._lastCheckResult = result;
            }
            return result;
        }

        protected abstract CheckResult checkImpl(char var1) throws ScanCharException;

        public void lookBack(boolean isContinueOtherwiseEnd) {
            if (isContinueOtherwiseEnd) {
                throw new RuntimeException("\u5fc5\u987b\u6709\u53d7\u8ba9\u8005\u63a5\u6536");
            }
        }

        public static enum CheckResult {
            UNKNOWN(1),
            START(2),
            INSIDE(2),
            END(4),
            SINGLE(6),
            YIELD(8);

            private int _status;

            private CheckResult(int status) {
                this._status = status;
            }

            public boolean isEnd() {
                return this.isStatus(4);
            }

            public boolean isYield() {
                return this.isStatus(8);
            }

            private boolean isStatus(int status) {
                return (this._status & status) == status;
            }
        }
    }
}

