/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.expr;

import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public abstract class AbstractExpr
implements IExpr {
    public static final int DATA_TYPE_UNSURE = 0;
    public static final int DATA_TYPE_STRING = 1;
    public static final int DATA_TYPE_NUMBER = 2;
    public static final int DATA_TYPE_DATETIME = 3;
    public static final int DATA_TYPE_DATE = 4;
    public static final int DATA_TYPE_TIME = 5;
    public static final int DATA_TYPE_BOOLEAN = 6;
    protected static final long TIME_IN_MILLIS_19000101 = -2209017600000L;
    protected static final long TIME_IN_MILLIS_OF_DAY = 86400000L;
    private static final boolean[][] COMPATIBILITY = new boolean[][]{{true, true, true, true, true, true, true}, {true, true, true, true, true, true, true}, {true, false, true, true, true, true, false}, {true, false, false, true, true, true, false}, {true, false, false, true, true, false, false}, {true, false, false, true, false, true, false}, {true, false, false, false, false, false, true}};
    private int _charIndexAtFormula;

    protected static boolean isDataTypeCompatible(int expected, int real) {
        return COMPATIBILITY[expected][real];
    }

    @Override
    public final int getCharIndexAtFormula() {
        return this._charIndexAtFormula;
    }

    public final void setCharIndexAtFormula(int idx) {
        this._charIndexAtFormula = idx;
    }

    protected static String convertToString(Object value, int returnType) {
        switch (returnType) {
            case 1: 
            case 2: {
                return value.toString();
            }
            case 4: {
                return new SimpleDateFormat("yyyy-MM-dd").format(((Calendar)value).getTime());
            }
            case 3: 
            case 5: {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((Calendar)value).getTime());
            }
            case 6: {
                return Boolean.toString((Boolean)value);
            }
        }
        return value.toString();
    }

    protected static BigDecimal convertToNumber(Object value, IExpr expr) throws ExecuteException {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Calendar) {
            double millis = ((Calendar)value).getTimeInMillis() - -2209017600000L;
            double days = millis / 8.64E7 + 1.0;
            return BigDecimal.valueOf(days);
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException e) {
                throw ExecuteException.unexpectedParamValue(expr);
            }
        }
        throw ExecuteException.unmatchedParamValTypeException(expr);
    }

    protected static Calendar convertToDate(Object value, IExpr expr) throws ExecuteException {
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        throw new ExecuteException(14, expr);
    }

    protected static Boolean convertToBoolean(Object value, IExpr expr) throws ExecuteException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ExecuteException(14, expr);
    }

    protected static int confirmDataType(Object value) {
        if (value instanceof BigDecimal) {
            return 2;
        }
        if (value instanceof Calendar) {
            return 3;
        }
        if (value instanceof String) {
            return 1;
        }
        return 0;
    }
}

