/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.expr;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Calendar;

public abstract class AbstractFunctionExpr
extends AbstractOpExpr {
    private String _name;

    public AbstractFunctionExpr(String name) {
        this._name = name;
        this.setPriority(90);
    }

    public AbstractFunctionExpr createInstance(IExpr[] params) throws ParserException {
        AbstractFunctionExpr expr = null;
        try {
            expr = (AbstractFunctionExpr)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        expr.initInstance(this.getName(), params);
        return expr;
    }

    private void initInstance(String name, IExpr[] subExprs) throws ParserException {
        this._name = name;
        this.initInstanceFromSubExprs(subExprs);
    }

    public final String getName() {
        return this._name;
    }

    public final IExpr[] getParams() {
        return this.getSubExprs();
    }

    @Override
    public final String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._name);
        sb.append('(');
        IExpr[] subs = this.getSubExprs();
        for (int i = 0; i < subs.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            IExpr expr = subs[i];
            sb.append(expr.encode());
        }
        sb.append(')');
        return sb.toString();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof AbstractFunctionExpr) {
            AbstractFunctionExpr another = (AbstractFunctionExpr)obj;
            return this._name.equals(another._name) && this.isEquals(another);
        }
        return false;
    }

    protected int getParamIntValueUseDefaultIfNotExist(IExecuteContext context, int idx, int defaultValue) throws ExecuteException {
        if (this.getSubExprs().length <= idx) {
            return defaultValue;
        }
        return this.getIntValue(this.getSubExprs()[idx], context);
    }

    protected String getParamStringValueUseDefaultIfNotExist(IExecuteContext context, int idx, String defaultValue) throws ExecuteException {
        if (this.getSubExprs().length <= idx) {
            return defaultValue;
        }
        return this.getStringValue(this.getSubExprs()[idx], context);
    }

    protected String getStringValue(IExpr expr, IExecuteContext context) throws ExecuteException {
        Object value = expr.execute(context);
        if (value == null) {
            throw ExecuteException.nullParamException(expr);
        }
        String stringValue = AbstractFunctionExpr.convertToString(value, expr.getReturnDataType());
        return stringValue;
    }

    protected String getNullableStringValue(IExpr expr, IExecuteContext context) throws ExecuteException {
        Object value = expr.execute(context);
        if (value == null) {
            return null;
        }
        String stringValue = AbstractFunctionExpr.convertToString(value, expr.getReturnDataType());
        return stringValue;
    }

    protected int getIntValue(IExpr expr, IExecuteContext context) throws ExecuteException {
        Object value = expr.execute(context);
        if (value == null) {
            throw ExecuteException.nullParamException(expr);
        }
        BigDecimal decimal = AbstractFunctionExpr.convertToNumber(value, expr);
        return decimal.intValue();
    }

    protected double getDoubleValue(IExpr expr, IExecuteContext context) throws ExecuteException {
        Object value = expr.execute(context);
        if (value == null) {
            throw ExecuteException.nullParamException(expr);
        }
        BigDecimal decimal = AbstractFunctionExpr.convertToNumber(value, expr);
        return decimal.doubleValue();
    }

    protected Calendar getDateValue(IExpr expr, IExecuteContext context) throws ExecuteException {
        Object value = expr.execute(context);
        if (value == null) {
            throw ExecuteException.nullParamException(expr);
        }
        Calendar date = AbstractFunctionExpr.convertToDate(value, expr);
        return date;
    }

    protected Boolean getBooleanValue(IExpr expr, IExecuteContext context) throws ExecuteException {
        Object value = expr.execute(context);
        if (value == null) {
            throw ExecuteException.nullParamException(expr);
        }
        Boolean bool = AbstractFunctionExpr.convertToBoolean(value, expr);
        return bool;
    }

    protected BigDecimal getNumberTypeErrorValue() {
        return new BigDecimal(0);
    }
}

