/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.memory;

import com.kingdee.bos.qing.common.memory.MemScanListener;
import com.kingdee.bos.qing.common.memory.MemWarningLevel;
import com.kingdee.bos.qing.common.memory.MemoryObserver;
import com.kingdee.bos.qing.common.memory.WarningLevelAdvisor;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.util.LogUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MemRuntimeMonitor {
    private ExecutorService memThreadExecutor;
    private List<MemoryObserver> priorityObservers = new ArrayList<MemoryObserver>();
    private static MemRuntimeMonitor monitor = new MemRuntimeMonitor();
    private WarningLevelAdvisor levelAdvisor;
    private int intervalTime;
    private MemoryPoolMXBean oldMemMxBean;
    private List<MemScanListener> memScanListeners = new ArrayList<MemScanListener>();
    private ReentrantLock locker = new ReentrantLock();
    private Condition emptyCondition = this.locker.newCondition();

    private MemRuntimeMonitor() {
        if (QingJoinConfig.getInstance().isMemMonitorOpened()) {
            this.memThreadExecutor = Executors.newSingleThreadExecutor();
            this.intervalTime = QingJoinConfig.getInstance().getMemScanInterval();
            this.levelAdvisor = new WarningLevelAdvisor(QingJoinConfig.getInstance().getWarningConditions());
            this.memScanListeners.add(this.levelAdvisor);
            this.initMemEnviroments();
            this.memThreadExecutor.submit(new MemoryCollector());
        }
    }

    private void initMemEnviroments() {
        List<MemoryPoolMXBean> poolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : poolMXBeans) {
            if (!memoryPoolMXBean.getName().toLowerCase().contains("old")) continue;
            this.oldMemMxBean = memoryPoolMXBean;
            break;
        }
    }

    public static MemRuntimeMonitor getInstance() {
        return monitor;
    }

    public void unSafeAddScanListener(MemScanListener memScanListener) {
        this.memScanListeners.add(memScanListener);
    }

    private void sortObservers() {
        Collections.sort(this.priorityObservers, new Comparator<MemoryObserver>(){

            @Override
            public int compare(MemoryObserver o1, MemoryObserver o2) {
                return o1.getPriority() > o2.getPriority() ? -1 : 1;
            }
        });
    }

    private boolean exist(String observerId) {
        for (MemoryObserver observer : this.priorityObservers) {
            if (!observer.getObserverId().equals(observerId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerIfAbsent(MemoryObserver memoryObserver) {
        if (!QingJoinConfig.getInstance().isMemMonitorOpened()) {
            return false;
        }
        this.locker.lock();
        try {
            if (this.exist(memoryObserver.getObserverId())) {
                boolean bl = false;
                return bl;
            }
            LogUtil.info("register observer:" + memoryObserver.getObserverId());
            boolean fireScanStart = this.priorityObservers.size() == 0;
            this.priorityObservers.add(memoryObserver);
            this.sortObservers();
            if (fireScanStart) {
                this.fireScanStart();
            }
            this.emptyCondition.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    private void fireScanStart() {
        LogUtil.info("begin jvm memory scan");
        for (MemScanListener listener : this.memScanListeners) {
            listener.onStart();
        }
    }

    private void fireScanStop() {
        LogUtil.info("stop jvm memory scan");
        for (MemScanListener listener : this.memScanListeners) {
            listener.onFinished();
        }
    }

    public void unRegister(String observerID) {
        if (!QingJoinConfig.getInstance().isMemMonitorOpened()) {
            return;
        }
        this.locker.lock();
        try {
            this.removeObserver(observerID);
            if (this.priorityObservers.size() == 0) {
                this.fireScanStop();
            }
        }
        finally {
            this.locker.unlock();
        }
    }

    private void removeObserver(String observerID) {
        Iterator<MemoryObserver> iterator = this.priorityObservers.iterator();
        while (iterator.hasNext()) {
            MemoryObserver observer = iterator.next();
            if (!observer.getObserverId().equals(observerID)) continue;
            iterator.remove();
            break;
        }
    }

    public double getOldSpaceUsedPercent() {
        MemoryUsage oldMemUsage = this.oldMemMxBean.getUsage();
        double oldUsed = oldMemUsage.getUsed();
        return oldUsed / (double)oldMemUsage.getMax();
    }

    private void waitObserverNotEmpty() {
        this.locker.lock();
        try {
            while (this.priorityObservers.size() == 0) {
                this.emptyCondition.await();
            }
        }
        catch (InterruptedException e) {
            LogUtil.error("mem monitor thread interrupted", e);
        }
        finally {
            this.locker.unlock();
        }
    }

    private void doWarning(MemWarningLevel memWarningLevel, double currentOldSpaceRatio) {
        List<MemoryObserver> copys = this.createObserverCopy();
        for (MemoryObserver memoryObserver : copys) {
            if (memWarningLevel.getPriority() < memoryObserver.lowestLevel().getPriority()) continue;
            memoryObserver.notifyMemoryWarning(memWarningLevel, currentOldSpaceRatio);
        }
    }

    private List<MemoryObserver> createObserverCopy() {
        ArrayList<MemoryObserver> copys = new ArrayList<MemoryObserver>();
        this.locker.lock();
        try {
            copys.addAll(this.priorityObservers);
        }
        finally {
            this.locker.unlock();
        }
        return copys;
    }

    private class MemoryCollector
    implements Runnable {
        private boolean start = true;

        private MemoryCollector() {
        }

        @Override
        public void run() {
            while (this.start) {
                MemRuntimeMonitor.this.waitObserverNotEmpty();
                double useRatio = MemRuntimeMonitor.this.getOldSpaceUsedPercent();
                MemWarningLevel memWarningLevel = MemRuntimeMonitor.this.levelAdvisor.getWarningLevel(useRatio);
                LogUtil.info("memory warning:" + memWarningLevel.name());
                MemRuntimeMonitor.this.doWarning(memWarningLevel, useRatio);
                this.doSleep();
            }
        }

        public void stop() {
            this.start = false;
        }

        private void doSleep() {
            try {
                Thread.sleep(MemRuntimeMonitor.this.intervalTime * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

