/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.memory;

import com.kingdee.bos.qing.common.memory.MemScanListener;
import com.kingdee.bos.qing.common.memory.MemWarningLevel;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.datasource.join.config.WarningCondition;
import java.util.ArrayList;
import java.util.List;

public class WarningLevelAdvisor
implements MemScanListener {
    private List<WarningCondition> warningConditionList;
    private List<Double> recentMemUsedPercents = new ArrayList<Double>(5);
    public static final int CACHED_PERCENTS_DATA_SIZE = 5;
    private long lastMemScanFinishTime = -1L;

    public WarningLevelAdvisor(List<WarningCondition> warningConditionList) {
        this.warningConditionList = warningConditionList;
    }

    private void cacheMemUsed(double memUsedPercent) {
        if (this.recentMemUsedPercents.size() >= 5) {
            this.recentMemUsedPercents.remove(0);
        }
        this.recentMemUsedPercents.add(memUsedPercent);
    }

    public MemWarningLevel getWarningLevel(double currentPercent) {
        this.cacheMemUsed(currentPercent);
        return this.selectLevel();
    }

    @Override
    public void onStart() {
        if (this.lastMemScanFinishTime == -1L) {
            this.recentMemUsedPercents.clear();
            return;
        }
        int inervalTime = QingJoinConfig.getInstance().getMemScanInterval();
        long validDuration = inervalTime * 5 * 1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMemScanFinishTime > validDuration) {
            this.recentMemUsedPercents.clear();
            return;
        }
    }

    @Override
    public void onFinished() {
        this.lastMemScanFinishTime = System.currentTimeMillis();
    }

    private MemWarningLevel selectLevel() {
        for (int i = this.warningConditionList.size() - 1; i >= 0; --i) {
            WarningCondition condition = this.warningConditionList.get(i);
            if (!this.matchCondition(condition)) continue;
            return condition.getWarningLevel();
        }
        return MemWarningLevel.NORMAL;
    }

    private boolean matchCondition(WarningCondition condition) {
        int count;
        double radio = condition.getRatio();
        if (count > this.recentMemUsedPercents.size()) {
            return false;
        }
        int index = this.recentMemUsedPercents.size() - 1;
        for (count = condition.getCount(); count > 0; --count) {
            if (this.recentMemUsedPercents.get(index) < radio) {
                return false;
            }
            --index;
        }
        return true;
    }
}

