/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.network.blacklist;

import com.kingdee.bos.qing.common.network.CIDRAddress;
import com.kingdee.bos.qing.common.network.blacklist.BlackItem;
import com.kingdee.bos.qing.util.LogUtil;
import org.jdom2.Element;

public class BlackIPV4Range
implements BlackItem {
    private CIDRAddress cidrAddress;

    @Override
    public void fromElement(Element element) {
        String cidr = element.getText();
        try {
            this.cidrAddress = new CIDRAddress(cidr);
        }
        catch (IllegalArgumentException e) {
            LogUtil.error("", e);
        }
    }

    @Override
    public boolean match(String address) {
        if (this.cidrAddress != null) {
            if (this.cidrAddress.matchIpAddress(address)) {
                return this.cidrAddress.getSubnetInfo().isInRange(address);
            }
            return false;
        }
        return false;
    }
}

