/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.thread;

import com.kingdee.bos.qing.common.thread.ThreadMonitable;
import com.kingdee.bos.qing.common.thread.ThreadPoolExecuteListener;
import com.kingdee.bos.qing.common.thread.ThreadPoolExecutor;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolMonitor {
    private static final ThreadPoolMonitor instance = new ThreadPoolMonitor();
    private Map<ThreadPoolManage.QingThreadPoolName, ThreadPoolStatistic> statisticMap = new HashMap<ThreadPoolManage.QingThreadPoolName, ThreadPoolStatistic>();

    private ThreadPoolMonitor() {
    }

    public static ThreadPoolMonitor getInstance() {
        return instance;
    }

    public synchronized ThreadPoolStatistic getThreadPoolStatistic(ThreadPoolManage.QingThreadPoolName qingThreadPoolName) {
        return this.statisticMap.get((Object)qingThreadPoolName);
    }

    public synchronized void initThreadPoolStatistic(ThreadPoolManage.QingThreadPoolName qingThreadPoolName, ThreadPoolExecutor poolExecutor) {
        ThreadPoolStatistic statistic = this.statisticMap.get((Object)qingThreadPoolName);
        if (null == statistic) {
            statistic = new ThreadPoolStatistic();
            this.statisticMap.put(qingThreadPoolName, statistic);
        }
        statistic.setMaxThreadPoolSize(poolExecutor.getMaximumPoolSize());
        poolExecutor.setExecuteListener(statistic);
    }

    public static class ThreadPoolStatistic
    implements ThreadPoolExecuteListener {
        private int maxThreadPoolSize;
        private AtomicInteger rejectedThreadTotalSize = new AtomicInteger(0);
        private Map<Runnable, Long> beginTimeMap = new HashMap<Runnable, Long>();

        public int getMaxThreadPoolSize() {
            return this.maxThreadPoolSize;
        }

        public void setMaxThreadPoolSize(int maxThreadPoolSize) {
            this.maxThreadPoolSize = maxThreadPoolSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewThreadSubmitted(Runnable runnable) {
            Map<Runnable, Long> map = this.beginTimeMap;
            synchronized (map) {
                this.beginTimeMap.put(runnable, System.currentTimeMillis());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onThreadRejected(Runnable runnable) {
            Map<Runnable, Long> map = this.beginTimeMap;
            synchronized (map) {
                this.beginTimeMap.remove(runnable);
            }
            this.rejectedThreadTotalSize.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isThreadPoolFull() {
            Map<Runnable, Long> map = this.beginTimeMap;
            synchronized (map) {
                return this.beginTimeMap.size() >= this.maxThreadPoolSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFinished(Runnable runnable) {
            Map<Runnable, Long> map = this.beginTimeMap;
            synchronized (map) {
                this.beginTimeMap.remove(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRunningSize() {
            Map<Runnable, Long> map = this.beginTimeMap;
            synchronized (map) {
                return this.beginTimeMap.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getLongRunningSize(long leastRunningTime) {
            int size = 0;
            Map<Runnable, Long> map = this.beginTimeMap;
            synchronized (map) {
                for (Map.Entry<Runnable, Long> entry : this.beginTimeMap.entrySet()) {
                    ThreadMonitable tm;
                    Runnable runnable = entry.getKey();
                    if (runnable instanceof ThreadMonitable && (tm = (ThreadMonitable)((Object)runnable)).isResident()) continue;
                    long beginTime = entry.getValue();
                    if (System.currentTimeMillis() - beginTime <= leastRunningTime) continue;
                    ++size;
                }
            }
            return size;
        }

        public int getRejectedThreadTotalSize() {
            return this.rejectedThreadTotalSize.get();
        }
    }
}

