/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.model.graph;

import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.model.graph.DirectedGraph;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ERGraph {
    private DirectedGraph<String, DSMetaRelation> erDirectedGraph = new DirectedGraph();
    private Map<String, DSMetaEntity> allDSMetaEntityMpas = new HashMap<String, DSMetaEntity>(16);
    private List<DSMetaRelation> relations;

    public ERGraph(List<DSMetaEntity> entities, List<DSMetaRelation> relations) {
        for (DSMetaEntity entity : entities) {
            String entityName = entity.getName();
            this.allDSMetaEntityMpas.put(entityName, entity);
            this.erDirectedGraph.addVertex(entityName);
        }
        this.relations = relations;
        for (DSMetaRelation relation : relations) {
            String fromEntity = relation.getFromEntity().getName();
            String toEntity = relation.getToEntity().getName();
            switch (relation.getRelationType()) {
                case nToOne: {
                    this.erDirectedGraph.addEdge(fromEntity, toEntity, relation);
                    break;
                }
                case oneToN: {
                    this.erDirectedGraph.addEdge(toEntity, fromEntity, relation);
                    break;
                }
                case oneToOne: {
                    this.erDirectedGraph.addEdge(fromEntity, toEntity, relation);
                    this.erDirectedGraph.addEdge(toEntity, fromEntity, relation);
                    break;
                }
            }
        }
    }

    public DirectedGraph<String, DSMetaRelation> geterDirectedGraph() {
        return this.erDirectedGraph;
    }

    public List<DSMetaRelation> getRelations() {
        return this.relations;
    }

    public Map<String, DSMetaEntity> getAllDSMetaEntityMpas() {
        return this.allDSMetaEntityMpas;
    }
}

