/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.model.graph;

import com.kingdee.bos.qing.datasource.exception.UnAnalysableException;
import com.kingdee.bos.qing.datasource.meta.DSElimination;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.model.AnalysisPathModel;
import com.kingdee.bos.qing.datasource.model.graph.DirectedGraph;
import com.kingdee.bos.qing.datasource.model.graph.ERGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class ERGraphUtil {
    private static void mergeOneToOne(Set<String> allEntityNames, Set<DSMetaRelation> allRelationSet, Map<String, String> merageNameMap, DirectedGraph<String, DSMetaRelation> oneToOneSubGraph) {
        Iterator<DSMetaRelation> allRelationSetIterator = allRelationSet.iterator();
        HashMap<String, ArrayList<String>> merageNameMapList = new HashMap<String, ArrayList<String>>();
        while (allRelationSetIterator.hasNext()) {
            DSMetaRelation relation = allRelationSetIterator.next();
            String from = relation.getFromEntity().getName();
            String to = relation.getToEntity().getName();
            if (relation.getRelationType() != DSMetaRelation.DSMetaRelationType.oneToOne) continue;
            String merageName = null;
            String merageNameFrom = merageNameMap.get(from);
            String merageNameTo = merageNameMap.get(to);
            if (merageNameFrom == null && merageNameTo == null) {
                merageName = UUID.randomUUID().toString();
            } else if (merageNameFrom != null && merageNameTo != null) {
                if (merageNameFrom.equals(merageNameTo)) continue;
                merageName = merageNameFrom;
                List merageNameToList = (List)merageNameMapList.remove(merageNameTo);
                List merageNameFromList = (List)merageNameMapList.get(merageNameFrom);
                allEntityNames.remove(merageNameTo);
                if (merageNameToList != null && !merageNameToList.isEmpty()) {
                    for (String entitName : merageNameToList) {
                        merageNameMap.put(entitName, merageName);
                        merageNameFromList.add(entitName);
                    }
                }
            } else if (merageNameFrom != null) {
                merageName = merageNameFrom;
            } else if (merageNameTo != null) {
                merageName = merageNameTo;
            }
            oneToOneSubGraph.addVertex(from);
            oneToOneSubGraph.addVertex(to);
            oneToOneSubGraph.addEdge(from, to, relation);
            oneToOneSubGraph.addEdge(to, from, relation);
            merageNameMap.put(from, merageName);
            merageNameMap.put(to, merageName);
            ArrayList<String> merageNameList = (ArrayList<String>)merageNameMapList.get(merageName);
            if (merageNameList == null) {
                merageNameList = new ArrayList<String>();
                merageNameMapList.put(merageName, merageNameList);
            }
            merageNameList.add(from);
            merageNameList.add(to);
            allEntityNames.remove(from);
            allEntityNames.remove(to);
            allEntityNames.add(merageName);
            allRelationSetIterator.remove();
        }
    }

    private static void initGraphAfterMerge(Set<String> allEntityNames, Set<DSMetaRelation> allRelationSet, Map<String, String> merageNameMap, DirectedGraph<String, DSMetaRelation> graphAfterMerge) {
        Iterator<DSMetaRelation> allRelationSetIterator = allRelationSet.iterator();
        while (allRelationSetIterator.hasNext()) {
            DSMetaRelation relation = allRelationSetIterator.next();
            String from = relation.getFromEntity().getName();
            String to = relation.getToEntity().getName();
            if (relation.getRelationType() == DSMetaRelation.DSMetaRelationType.oneToOne) continue;
            String merageName = merageNameMap.get(from);
            if (merageName != null) {
                from = merageName;
            }
            if ((merageName = merageNameMap.get(to)) != null) {
                to = merageName;
            }
            graphAfterMerge.addVertex(from);
            graphAfterMerge.addVertex(to);
            switch (relation.getRelationType()) {
                case nToOne: {
                    graphAfterMerge.addEdge(from, to, relation);
                    break;
                }
                case oneToN: {
                    graphAfterMerge.addEdge(to, from, relation);
                }
            }
            allEntityNames.remove(from);
            allEntityNames.remove(to);
            allRelationSetIterator.remove();
        }
        for (String entityName : allEntityNames) {
            graphAfterMerge.addVertex(entityName);
        }
    }

    private static List<String> getStartAndMergeOneToOne(DirectedGraph<String, DSMetaRelation> mainGraph, Map<String, String> merageNameMap, DirectedGraph<String, DSMetaRelation> oneToOneSubGraph, DirectedGraph<String, DSMetaRelation> graphAfterMerge) {
        ArrayList<String> startEntities = new ArrayList<String>();
        Set<String> allEntityNames = mainGraph.getVertexs();
        if (allEntityNames.size() == 1) {
            startEntities.addAll(allEntityNames);
            graphAfterMerge.addVertexs(allEntityNames);
            return startEntities;
        }
        Set<DSMetaRelation> allRelationSet = mainGraph.getEdges();
        ERGraphUtil.mergeOneToOne(allEntityNames, allRelationSet, merageNameMap, oneToOneSubGraph);
        ERGraphUtil.initGraphAfterMerge(allEntityNames, allRelationSet, merageNameMap, graphAfterMerge);
        TreeSet<DSMetaRelation> startRelations = new TreeSet<DSMetaRelation>();
        Set<String> allEntityNameAfterMerge = graphAfterMerge.getVertexs();
        HashSet<String> startEntitySet = new HashSet<String>();
        for (String entityName : allEntityNameAfterMerge) {
            int inDegree = graphAfterMerge.getInDegree(entityName);
            if (inDegree != 0) continue;
            startRelations.addAll(graphAfterMerge.edgesFrom(entityName).values());
            startEntitySet.add(entityName);
        }
        for (DSMetaRelation metaRelation : startRelations) {
            DSMetaEntity dsMetaEntity = metaRelation.getFromEntity();
            String entityName = dsMetaEntity.getName();
            entityName = dsMetaEntity.getName();
            String merageName = merageNameMap.get(entityName);
            if (merageName != null && startEntitySet.remove(merageName) && !startEntities.contains(merageName)) {
                startEntities.add(merageName);
                continue;
            }
            if (startEntitySet.remove(entityName) && !startEntities.contains(entityName)) {
                startEntities.add(entityName);
                continue;
            }
            dsMetaEntity = metaRelation.getToEntity();
            entityName = dsMetaEntity.getName();
            merageName = merageNameMap.get(entityName);
            if (merageName != null && startEntitySet.remove(merageName) && !startEntities.contains(merageName)) {
                startEntities.add(merageName);
                continue;
            }
            if (!startEntitySet.remove(entityName) || startEntities.contains(entityName)) continue;
            startEntities.add(entityName);
        }
        if (!startEntitySet.isEmpty()) {
            startEntities.addAll(startEntitySet);
        }
        return startEntities;
    }

    public static Set<DSMetaRelation> getSelectedEntitiesRelation(ERGraph erGraph, Map<String, DSMetaEntity> selectedEntitiesMap) throws UnAnalysableException {
        DirectedGraph<String, DSMetaRelation> erDirectedGraph = erGraph.geterDirectedGraph();
        Set<String> selectEntityNames = selectedEntitiesMap.keySet();
        DirectedGraph<String, DSMetaRelation> graph = erDirectedGraph.getSelectedVertexMinConnectedSubGrapgh(selectEntityNames);
        return graph.getEdges();
    }

    public static AnalysisPathModel getAnalysisPathModel(ERGraph erGraph, Map<String, DSMetaEntity> selectedEntitiesMap) throws UnAnalysableException {
        DirectedGraph<String, DSMetaRelation> erDirectedGraph = erGraph.geterDirectedGraph();
        DirectedGraph<String, DSMetaRelation> mainGraph = ERGraphUtil.getSelectFieldMaxConnectedGraph(erDirectedGraph, selectedEntitiesMap);
        if (mainGraph == null) {
            return null;
        }
        Map<String, DSMetaEntity> allDSMetaEntityMpas = erGraph.getAllDSMetaEntityMpas();
        DirectedGraph<String, DSMetaRelation> oneToOneSubGraph = new DirectedGraph<String, DSMetaRelation>();
        DirectedGraph<String, DSMetaRelation> mainGraphAfterMerge = new DirectedGraph<String, DSMetaRelation>();
        HashMap<String, String> mergeNameMap = new HashMap<String, String>();
        List<String> startEntity = ERGraphUtil.getStartAndMergeOneToOne(mainGraph, mergeNameMap, oneToOneSubGraph, mainGraphAfterMerge);
        ERGraphUtil.fixSelectedEntities(allDSMetaEntityMpas, mainGraph, selectedEntitiesMap);
        List<DirectedGraph<String, DSMetaRelation>> oneToOneGraphs = oneToOneSubGraph.getSubGraph();
        return new AnalysisPathModel(startEntity, mergeNameMap, mainGraphAfterMerge, oneToOneGraphs);
    }

    public static List<DSElimination> getElimination(ERGraph erGraph, Map<String, DSMetaEntity> selectedEntitiesMap, Set<DSFieldKey> selectedMeasuresFieldKey) throws UnAnalysableException {
        AnalysisPathModel analysisPathModel = ERGraphUtil.getAnalysisPathModel(erGraph, selectedEntitiesMap);
        if (analysisPathModel == null) {
            return null;
        }
        DirectedGraph<String, DSMetaRelation> mainGraphAfterMerge = analysisPathModel.getMainGraphAfterMerge();
        Set<String> vertexsAfterMerge = mainGraphAfterMerge.getVertexs();
        if (vertexsAfterMerge.size() == 1) {
            return null;
        }
        Map<String, DSMetaEntity> allDSMetaEntityMpas = erGraph.getAllDSMetaEntityMpas();
        HashMap<String, DSElimination> oneToOneEliminationMap = new HashMap<String, DSElimination>();
        List<DirectedGraph<String, DSMetaRelation>> oneToOneGraphs = analysisPathModel.getOneToOneGraphs();
        Map<String, String> mergeNameMap = analysisPathModel.getMergeNameMap();
        HashMap<String, List<String>> mergeNameListWhichHasElimination = new HashMap<String, List<String>>();
        for (DirectedGraph<String, DSMetaRelation> oneToOneGraph : oneToOneGraphs) {
            Set<String> oneToOneVertexs = oneToOneGraph.getVertexs();
            for (String vertex : oneToOneVertexs) {
                DSMetaEntity selectedEntity = allDSMetaEntityMpas.get(vertex);
                DSElimination dsElimination = ERGraphUtil.createElimination(selectedEntity, selectedMeasuresFieldKey);
                if (dsElimination == null) continue;
                oneToOneEliminationMap.put(vertex, dsElimination);
                String mergeName = mergeNameMap.get(vertex);
                ArrayList<String> mergeNameWhichHasElimination = (ArrayList<String>)mergeNameListWhichHasElimination.get(mergeName);
                if (mergeNameWhichHasElimination == null) {
                    mergeNameWhichHasElimination = new ArrayList<String>(16);
                    mergeNameListWhichHasElimination.put(mergeName, mergeNameWhichHasElimination);
                }
                mergeNameWhichHasElimination.add(vertex);
            }
        }
        ArrayList<DSElimination> result = new ArrayList<DSElimination>();
        HashSet<String> visitedNode = new HashSet<String>();
        List<String> startEntities = analysisPathModel.getStartEntities();
        int startEntityCount = startEntities.size();
        for (int index = 0; index < startEntityCount; ++index) {
            String startEntityName = startEntities.get(index);
            if (startEntityCount > 1) {
                ERGraphUtil.tryToAddElimination(result, startEntityName, selectedMeasuresFieldKey, allDSMetaEntityMpas, oneToOneEliminationMap, mergeNameListWhichHasElimination);
            }
            ERGraphUtil.dfsElimination(mainGraphAfterMerge, result, oneToOneEliminationMap, startEntityName, visitedNode, selectedMeasuresFieldKey, allDSMetaEntityMpas, mergeNameListWhichHasElimination);
        }
        return result;
    }

    private static void tryToAddElimination(List<DSElimination> result, String startEntityName, Set<DSFieldKey> selectedMeasuresFieldKey, Map<String, DSMetaEntity> allDSMetaEntityMpas, Map<String, DSElimination> oneToOneEliminationMap, Map<String, List<String>> mergeNameListWhichHasElimination) {
        DSMetaEntity selectedEntity = allDSMetaEntityMpas.get(startEntityName);
        if (selectedEntity != null) {
            DSElimination dsElimination = ERGraphUtil.createElimination(selectedEntity, selectedMeasuresFieldKey);
            if (dsElimination != null) {
                result.add(dsElimination);
            }
        } else {
            List<String> mergeNameWhichHasElimination = mergeNameListWhichHasElimination.get(startEntityName);
            if (mergeNameWhichHasElimination != null) {
                for (String mergeName : mergeNameWhichHasElimination) {
                    DSElimination dsElimination = oneToOneEliminationMap.get(mergeName);
                    result.add(dsElimination);
                }
            }
        }
    }

    private static DSElimination createElimination(DSMetaEntity selectedEntity, Set<DSFieldKey> selectedMeasuresFieldKey) {
        String selectedEntityName = selectedEntity.getName();
        HashSet<String> associatedFields = new HashSet<String>();
        block0: for (DSFieldKey selectedMeasuresField : selectedMeasuresFieldKey) {
            if (!selectedEntityName.equals(selectedMeasuresField.getEntityName())) continue;
            for (DSMetaProperty dsMetaProperty : selectedEntity.getProperties()) {
                if (!dsMetaProperty.getName().equals(selectedMeasuresField.getPropertyName())) continue;
                associatedFields.add(selectedMeasuresField.toFullName());
                continue block0;
            }
        }
        if (associatedFields.size() > 0) {
            DSElimination elimination = new DSElimination();
            elimination.setIdField(new DSFieldKey(selectedEntityName, "_ROWID_").toFullName());
            elimination.addAssociatedFields(associatedFields);
            return elimination;
        }
        return null;
    }

    private static void dfsElimination(DirectedGraph<String, DSMetaRelation> graph, List<DSElimination> result, Map<String, DSElimination> oneToOneEliminationMap, String startEntityName, Set<String> visitedNode, Set<DSFieldKey> selectedMeasuresFieldKey, Map<String, DSMetaEntity> allDSMetaEntityMpas, Map<String, List<String>> mergeNameListWhichHasElimination) {
        Map<String, DSMetaRelation> to;
        if (visitedNode.add(startEntityName) && !(to = graph.edgesFrom(startEntityName)).isEmpty()) {
            for (Map.Entry<String, DSMetaRelation> toVEntry : to.entrySet()) {
                String toEntityName = toVEntry.getKey();
                if (!visitedNode.contains(toEntityName)) {
                    ERGraphUtil.tryToAddElimination(result, toEntityName, selectedMeasuresFieldKey, allDSMetaEntityMpas, oneToOneEliminationMap, mergeNameListWhichHasElimination);
                }
                ERGraphUtil.dfsElimination(graph, result, oneToOneEliminationMap, toEntityName, visitedNode, selectedMeasuresFieldKey, allDSMetaEntityMpas, mergeNameListWhichHasElimination);
            }
        }
    }

    private static void fixSelectedEntities(Map<String, DSMetaEntity> allDSMetaEntityMpas, DirectedGraph<String, DSMetaRelation> graph, Map<String, DSMetaEntity> selectedEntitiesMap) {
        for (String vertex : graph.getVertexs()) {
            Map<String, DSMetaRelation> eRRelationMap = graph.edgesFrom(vertex);
            for (Map.Entry<String, DSMetaRelation> otherEntityEntry : eRRelationMap.entrySet()) {
                String toEntityName;
                DSMetaEntity toEntity;
                DSMetaRelation relation = otherEntityEntry.getValue();
                String formEntityName = relation.getFromEntity().getName();
                DSMetaEntity fromEntity = selectedEntitiesMap.get(formEntityName);
                if (fromEntity == null) {
                    fromEntity = allDSMetaEntityMpas.get(formEntityName);
                    selectedEntitiesMap.put(formEntityName, fromEntity);
                }
                if ((toEntity = selectedEntitiesMap.get(toEntityName = relation.getToEntity().getName())) != null) continue;
                toEntity = allDSMetaEntityMpas.get(toEntityName);
                selectedEntitiesMap.put(toEntityName, toEntity);
            }
        }
    }

    private static DirectedGraph<String, DSMetaRelation> getSelectFieldMaxConnectedGraph(DirectedGraph<String, DSMetaRelation> erDirectedGraph, Map<String, DSMetaEntity> selectedEntitiesMap) throws UnAnalysableException {
        Set<String> selectEntityNames = selectedEntitiesMap.keySet();
        DirectedGraph<String, DSMetaRelation> graph = erDirectedGraph.getSelectedVertexMinConnectedSubGrapgh(selectEntityNames);
        List<DirectedGraph<String, DSMetaRelation>> subGraphs = graph.getSubGraph();
        if (subGraphs.isEmpty()) {
            throw new UnAnalysableException("no entity used");
        }
        if (subGraphs.size() > 1) {
            throw new UnAnalysableException("no relationship between two entities");
        }
        return graph;
    }
}

